/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.jrdemiurge.enigmaticdice.item.custom.crucibleofrile.ClientLookController;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class LookAtTargetPacket {
    private final UUID targetUuid;
    private final int durationTicks;

    public LookAtTargetPacket(UUID targetUuid, int durationTicks) {
        this.targetUuid = targetUuid;
        this.durationTicks = durationTicks;
    }

    public static void encode(LookAtTargetPacket pkt, FriendlyByteBuf buf) {
        buf.m_130077_(pkt.targetUuid);
        buf.m_130130_(pkt.durationTicks);
    }

    public static LookAtTargetPacket decode(FriendlyByteBuf buf) {
        return new LookAtTargetPacket(buf.m_130259_(), buf.m_130242_());
    }

    public static void handle(LookAtTargetPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientLookController.startOrExtend(pkt.targetUuid, pkt.durationTicks));
        ctx.get().setPacketHandled(true);
    }
}

