/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.mixin;

import java.util.UUID;
import net.jrdemiurge.enigmaticdice.attribute.ModAttributes;
import net.jrdemiurge.enigmaticdice.item.custom.Permafrost;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Unique
    private float demis_Enigmatic_Dice_1_20_1$scale = 1.0f;

    protected PlayerMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        Player player = (Player)this;
        AttributeInstance inst = player.m_21051_((Attribute)ModAttributes.SIZE_SCALE.get());
        if (inst == null) {
            return;
        }
        float newScale = (float)inst.m_22135_();
        if (this.demis_Enigmatic_Dice_1_20_1$scale != newScale) {
            this.demis_Enigmatic_Dice_1_20_1$scale = newScale;
            this.m_6210_();
        }
    }

    @Inject(method={"getDimensions"}, at={@At(value="TAIL")}, cancellable=true)
    public void getDimensions(Pose pPose, CallbackInfoReturnable<EntityDimensions> cir) {
        if (this.demis_Enigmatic_Dice_1_20_1$scale != 1.0f) {
            EntityDimensions original = (EntityDimensions)cir.getReturnValue();
            cir.setReturnValue((Object)original.m_20388_(this.demis_Enigmatic_Dice_1_20_1$scale));
        }
    }

    @Inject(method={"getStandingEyeHeight"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyEyeHeight(Pose pose, EntityDimensions size, CallbackInfoReturnable<Float> cir) {
        if (this.demis_Enigmatic_Dice_1_20_1$scale != 1.0f && this.demis_Enigmatic_Dice_1_20_1$scale != 0.0f) {
            Float original = (Float)cir.getReturnValue();
            cir.setReturnValue((Object)Float.valueOf(original.floatValue() * this.demis_Enigmatic_Dice_1_20_1$scale));
        }
    }

    @Inject(method={"tryToStartFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTryToStartFallFlying(CallbackInfoReturnable<Boolean> cir) {
        Player self = (Player)this;
        UUID id = self.m_20148_();
        if (Permafrost.stackMap.getOrDefault(id, 0) >= 10) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void onReadAdditionalSaveData(CompoundTag pCompound, CallbackInfo ci) {
        Player player = (Player)this;
        UUID playerId = player.m_20148_();
        float permafrostStacksFlySpeedReduction = player.getPersistentData().m_128457_("PermafrostStacksFlySpeedReduction");
        float permafrostAuraFlySpeedReduction = player.getPersistentData().m_128457_("PermafrostAuraFlySpeedReduction");
        float permafrostFlySpeedRecovery = 0.0f;
        if (permafrostStacksFlySpeedReduction != 0.0f && !Permafrost.stackMap.containsKey(playerId)) {
            permafrostFlySpeedRecovery += permafrostStacksFlySpeedReduction;
        }
        if (permafrostAuraFlySpeedReduction != 0.0f && !Permafrost.auraApplied.contains(playerId)) {
            permafrostFlySpeedRecovery += permafrostAuraFlySpeedReduction;
        }
        if (permafrostFlySpeedRecovery != 0.0f) {
            float restoredFlySpeed = player.m_150110_().m_35942_() + permafrostFlySpeedRecovery;
            player.m_150110_().m_35943_(restoredFlySpeed);
            player.m_6885_();
            player.getPersistentData().m_128473_("PermafrostStacksFlySpeedReduction");
            player.getPersistentData().m_128473_("PermafrostAuraFlySpeedReduction");
        }
    }
}

