/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.jrdemiurge.enigmaticdice.attribute.ModAttributes;
import net.jrdemiurge.enigmaticdice.mixin.EntityRendererAccessor;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T> {
    @Unique
    private float enigmatic$baseShadowRadius = Float.NaN;

    protected LivingEntityRendererMixin(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInIt(EntityRendererProvider.Context pContext, EntityModel pModel, float pShadowRadius, CallbackInfo ci) {
        this.enigmatic$baseShadowRadius = pShadowRadius;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void modifyRenderSize(LivingEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        AttributeInstance inst = entity.m_21051_((Attribute)ModAttributes.SIZE_SCALE.get());
        if (inst == null) {
            return;
        }
        float scale = (float)inst.m_22135_();
        if (scale != 1.0f) {
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, scale);
        }
        ((EntityRendererAccessor)((Object)this)).setShadowRadius(this.enigmatic$baseShadowRadius * scale);
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void onRenderEnd(LivingEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        AttributeInstance inst = entity.m_21051_((Attribute)ModAttributes.SIZE_SCALE.get());
        if (inst == null) {
            return;
        }
        float scale = (float)inst.m_22135_();
        if (scale != 1.0f) {
            poseStack.m_85849_();
        }
    }
}

