/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import java.util.Random;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.jrdemiurge.enigmaticdice.scheduler.Scheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class WonderlandField
extends RandomEvent {
    private static final int MIMIC_COUNT = 10;
    private static final int SPAWN_RADIUS = 30;

    public WonderlandField(int rarity) {
        this.rarity = rarity;
    }

    @Override
    public boolean execute(Level pLevel, Player pPlayer, boolean guaranteed) {
        if (!guaranteed && !this.rollChance(pLevel, pPlayer, this.rarity)) {
            return false;
        }
        EntityType entityType = EntityType.m_20632_((String)"artifacts:mimic").orElse(null);
        if (entityType == null) {
            return false;
        }
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            Vec3 spawnPos = this.findValidSpawnPosition(pLevel, pPlayer, random);
            Entity entity = entityType.m_20615_(pLevel);
            if (entity == null) continue;
            entity.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0f, 0.0f);
            pLevel.m_7967_(entity);
            Scheduler.schedule(() -> {
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21557_(true);
                    CompoundTag entityData = mob.m_20240_(new CompoundTag());
                    entityData.m_128359_("DeathLootTable", "enigmaticdice:entities/mimic_loot_table");
                    mob.m_20258_(entityData);
                    mob.m_21051_(Attributes.f_22281_).m_22100_(0.0);
                }
            }, 20);
        }
        Vec3 spawnPos = this.findValidSpawnPosition(pLevel, pPlayer, random);
        Entity entity = entityType.m_20615_(pLevel);
        if (entity == null) {
            return false;
        }
        entity.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0f, 0.0f);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21557_(true);
            mob.m_7292_(new MobEffectInstance(MobEffects.f_19609_, -1, 0, false, true));
        }
        pLevel.m_7967_(entity);
        MutableComponent message = Component.m_237115_((String)("enigmaticdice.event.wonderland_field." + pLevel.f_46441_.m_188503_(3)));
        pPlayer.m_5661_((Component)message, false);
        return true;
    }

    private Vec3 findValidSpawnPosition(Level level, Player player, Random random) {
        double angle = random.nextDouble() * Math.PI * 2.0;
        double distance = 30.0 * (0.15 + 0.85 * random.nextDouble());
        int x = (int)(player.m_20185_() + Math.cos(angle) * distance);
        int z = (int)(player.m_20189_() + Math.sin(angle) * distance);
        BlockPos surfacePos = level.m_5452_(Heightmap.Types.WORLD_SURFACE, new BlockPos(x, 0, z));
        return new Vec3((double)surfacePos.m_123341_() + 0.5, (double)surfacePos.m_123342_(), (double)surfacePos.m_123343_() + 0.5);
    }
}

