/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import net.jrdemiurge.enigmaticdice.EnigmaticDice;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;

public class TeleportToWorldEdgeEvent
extends RandomEvent {
    public TeleportToWorldEdgeEvent(int rarity) {
        this.rarity = rarity;
    }

    @Override
    public boolean execute(Level pLevel, Player pPlayer, boolean guaranteed) {
        if (!guaranteed && !this.rollChance(pLevel, pPlayer, this.rarity)) {
            return false;
        }
        if (!(pLevel instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)pLevel;
        try {
            int rawX;
            boolean xEdge = pLevel.f_46441_.m_188499_();
            boolean positive = pLevel.f_46441_.m_188499_();
            double borderHalfSize = serverLevel.m_6857_().m_61959_() / 2.0 - 10.0;
            double borderCenterX = serverLevel.m_6857_().m_6347_();
            double borderCenterZ = serverLevel.m_6857_().m_6345_();
            int MAX_WORLD_COORD = 29999974;
            int n = xEdge ? (int)(borderCenterX + (positive ? borderHalfSize : -borderHalfSize)) : (rawX = pPlayer.m_20183_().m_123341_());
            int rawZ = xEdge ? pPlayer.m_20183_().m_123343_() : (int)(borderCenterZ + (positive ? borderHalfSize : -borderHalfSize));
            int targetX = Math.max(-29999974, Math.min(29999974, rawX));
            int targetZ = Math.max(-29999974, Math.min(29999974, rawZ));
            serverLevel.m_7726_().m_7587_(targetX >> 4, targetZ >> 4, ChunkStatus.f_62326_, true);
            int surfaceY = serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, targetX, targetZ);
            pPlayer.m_6021_((double)targetX + 0.5, (double)(surfaceY + 1), (double)targetZ + 0.5);
            MutableComponent message = Component.m_237115_((String)"enigmaticdice.event.teleport_to_world_edge");
            pPlayer.m_5661_((Component)message, false);
            return true;
        }
        catch (Exception e) {
            EnigmaticDice.LOGGER.error("Error teleporting to world edge: ", (Throwable)e);
            return false;
        }
    }
}

