/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.EnigmaticDice;
import net.jrdemiurge.enigmaticdice.config.EnigmaticDiceConfig;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;

public class TeleportToStructureEvent
extends RandomEvent {
    public TeleportToStructureEvent(int rarity) {
        this.rarity = rarity;
    }

    @Override
    public boolean execute(Level pLevel, Player pPlayer, boolean guaranteed) {
        if (!guaranteed && !this.rollChance(pLevel, pPlayer, this.rarity)) {
            return false;
        }
        if (!(pLevel instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)pLevel;
        List<String> allStructures = EnigmaticDiceConfig.configData.teleportStructures;
        if (allStructures == null || allStructures.isEmpty()) {
            EnigmaticDice.LOGGER.error("Structure list is empty in config!");
            return false;
        }
        Registry structureRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256944_);
        List<String> validStructures = allStructures.stream().filter(id -> structureRegistry.m_7804_(new ResourceLocation(id))).toList();
        if (validStructures.isEmpty()) {
            EnigmaticDice.LOGGER.error("No valid structures found! Check your config.");
            return false;
        }
        String structureId = validStructures.get(pLevel.f_46441_.m_188503_(validStructures.size()));
        ResourceLocation structureRL = new ResourceLocation(structureId);
        try {
            Holder structureHolder = (Holder)structureRegistry.m_203636_((ResourceKey)structureRegistry.m_7854_((Object)((Structure)structureRegistry.m_7745_(structureRL))).orElseThrow()).orElseThrow();
            HolderSet.Direct structureSet = HolderSet.m_205809_((Holder[])new Holder[]{structureHolder});
            Pair result = serverLevel.m_7726_().m_8481_().m_223037_(serverLevel, (HolderSet)structureSet, pPlayer.m_20183_(), Config.StructureSearchRadius, false);
            if (result == null) {
                EnigmaticDice.LOGGER.info("Structure not found: {}", (Object)structureId);
                return false;
            }
            BlockPos structurePos = (BlockPos)result.getFirst();
            structurePos = structurePos.m_7918_(100, 0, 0);
            serverLevel.m_7726_().m_7587_(structurePos.m_123341_() >> 4, structurePos.m_123343_() >> 4, ChunkStatus.f_62326_, true);
            int surfaceY = serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, structurePos.m_123341_(), structurePos.m_123343_());
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                serverPlayer.f_8906_.m_9774_((double)structurePos.m_123341_() + 0.5, (double)(surfaceY + 1), (double)structurePos.m_123343_() + 0.5, 90.0f, 0.0f);
            }
            MutableComponent message = Component.m_237115_((String)("enigmaticdice.event.teleport_to_structure." + pLevel.f_46441_.m_188503_(4)));
            pPlayer.m_5661_((Component)message, false);
            return true;
        }
        catch (Exception e) {
            EnigmaticDice.LOGGER.error("Error while teleporting to structure {}: ", (Object)structureId, (Object)e);
            return false;
        }
    }
}

