/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.EnigmaticDice;
import net.jrdemiurge.enigmaticdice.config.EnigmaticDiceConfig;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;

public class TeleportToBiomeEvent
extends RandomEvent {
    public TeleportToBiomeEvent(int rarity) {
        this.rarity = rarity;
    }

    @Override
    public boolean execute(Level pLevel, Player pPlayer, boolean guaranteed) {
        if (!guaranteed && !this.rollChance(pLevel, pPlayer, this.rarity)) {
            return false;
        }
        if (!(pLevel instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)pLevel;
        List<String> allBiomes = EnigmaticDiceConfig.configData.teleportBiomes;
        if (allBiomes == null || allBiomes.isEmpty()) {
            EnigmaticDice.LOGGER.error("Biome list is empty in config!");
            return false;
        }
        List<String> validBiomes = allBiomes.stream().filter(biomeId -> {
            ResourceLocation biomeLocation = new ResourceLocation(biomeId);
            return serverLevel.m_9598_().m_175515_(Registries.f_256952_).m_7804_(biomeLocation);
        }).toList();
        if (validBiomes.isEmpty()) {
            EnigmaticDice.LOGGER.error("No valid biomes found! Check your config.");
            return false;
        }
        String biomeIdentifier = validBiomes.get(pLevel.f_46441_.m_188503_(validBiomes.size()));
        try {
            ResourceLocation biomeLocation = new ResourceLocation(biomeIdentifier);
            Pair biomePair = serverLevel.m_215069_(biome -> biome.m_203373_(biomeLocation), pPlayer.m_20183_(), Config.BiomeSearchRadius, Config.BiomeHorizontalStep, Config.BiomeVerticalStep);
            if (biomePair == null) {
                EnigmaticDice.LOGGER.info("Biome not found: {}", (Object)biomeIdentifier);
                return false;
            }
            BlockPos biomePos = (BlockPos)biomePair.getFirst();
            serverLevel.m_7726_().m_7587_(biomePos.m_123341_() >> 4, biomePos.m_123343_() >> 4, ChunkStatus.f_62326_, true);
            int surfaceY = serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, biomePos.m_123341_(), biomePos.m_123343_());
            pPlayer.m_6021_((double)biomePos.m_123341_() + 0.5, (double)(surfaceY + 1), (double)biomePos.m_123343_() + 0.5);
            MutableComponent message = Component.m_237115_((String)("enigmaticdice.event.teleport_to_biome." + pLevel.f_46441_.m_188503_(6)));
            pPlayer.m_5661_((Component)message, false);
            return true;
        }
        catch (Exception e) {
            EnigmaticDice.LOGGER.error("Error while teleporting to biome {}: ", (Object)biomeIdentifier, (Object)e);
            return false;
        }
    }
}

