/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import java.util.ArrayList;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.jrdemiurge.enigmaticdice.scheduler.Scheduler;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class TeleportMonstersToPlayer
extends RandomEvent {
    public TeleportMonstersToPlayer(int rarity) {
        this.rarity = rarity;
    }

    @Override
    public boolean execute(Level pLevel, Player pPlayer, boolean guaranteed) {
        if (!guaranteed && !this.rollChance(pLevel, pPlayer, this.rarity)) {
            return false;
        }
        if (!(pLevel instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)pLevel;
        AABB searchArea = pPlayer.m_20191_().m_82400_(100.0);
        ArrayList monsters = new ArrayList(serverLevel.m_45976_(Monster.class, searchArea));
        if (monsters.isEmpty()) {
            return false;
        }
        Scheduler.schedule(() -> {
            Monster mob;
            if (!monsters.isEmpty() && (mob = (Monster)monsters.remove(0)).m_6084_()) {
                double angle = serverLevel.f_46441_.m_188500_() * Math.PI * 2.0;
                double radius = 5.0;
                double targetX = pPlayer.m_20185_() + Math.cos(angle) * radius;
                double targetZ = pPlayer.m_20189_() + Math.sin(angle) * radius;
                int surfaceY = serverLevel.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)Math.floor(targetX), (int)Math.floor(targetZ));
                double targetY = (double)surfaceY + 0.1;
                mob.m_6021_(targetX, targetY, targetZ);
            }
        }, 0, 10, monsters.size());
        MutableComponent message = Component.m_237115_((String)"enigmaticdice.event.teleport_monsters_to_player");
        pPlayer.m_5661_((Component)message, false);
        return true;
    }
}

