/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.jrdemiurge.enigmaticdice.EnigmaticDice;
import net.jrdemiurge.enigmaticdice.config.EnigmaticDiceConfig;
import net.jrdemiurge.enigmaticdice.config.ItemEventConfig;
import net.jrdemiurge.enigmaticdice.config.UniqueEventConfig;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.AccelerateDayCycleEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.AncientDebrisCageEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.AntSizeShrinkEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.AntimatterBombEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.BlackHoleBombEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.BroodAwakensEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.CurseBindingEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.DayOfInvisibility;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.DayOfStrength;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.DayOfTag;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.DayOnTheMoon;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.EternalBindingEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.ExplosionEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.GiveAncientTomeEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.GiveItemEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.GiveRandomPotionEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.LightningStrikeEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.MacroBlackHoleBombEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.MassCreeperSummonEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.MiniSizeShrinkEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.NuclearBombEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.PermanentBuffEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.SkyfallTraining;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.SummonCandicornEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.SummonCarcassEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.SummonCentipedeEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.SummonDummyChest;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.SummonMimic;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.SummonRaycatEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.SummonSpiderFleasEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.SummonSubterranodonEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.SummonTamedHorse;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.SummonVallumraptorEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.SummonWarpedToadsEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.TeleportMonstersToPlayer;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.TeleportToBiomeEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.TeleportToStructureEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.TeleportToWorldEdgeEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.WonderlandField;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.ModList;

public class RandomEventManager {
    private final List<RandomEvent> events = new ArrayList<RandomEvent>();
    private final List<String> eventNames = new ArrayList<String>();

    public RandomEventManager() {
        if (EnigmaticDiceConfig.configData != null) {
            String name;
            int i;
            if (EnigmaticDiceConfig.configData.uniqueEvents != null) {
                this.loadUniqueEvents();
            }
            if (EnigmaticDiceConfig.configData.itemEvents != null) {
                this.loadItemEvents();
            }
            if (EnigmaticDiceConfig.configData.negativeEvents != null) {
                for (i = 0; i < this.events.size(); ++i) {
                    name = this.eventNames.get(i);
                    if (!EnigmaticDiceConfig.configData.negativeEvents.contains(name)) continue;
                    this.events.get(i).setNegativeEvent(true);
                }
            }
            if (EnigmaticDiceConfig.configData.neutralEvents != null) {
                for (i = 0; i < this.events.size(); ++i) {
                    name = this.eventNames.get(i);
                    if (!EnigmaticDiceConfig.configData.neutralEvents.contains(name)) continue;
                    this.events.get(i).setNeutralEvent(true);
                }
            }
        }
    }

    private void loadItemEvents() {
        for (Map.Entry<String, ItemEventConfig> entry : EnigmaticDiceConfig.configData.itemEvents.entrySet()) {
            String eventName = entry.getKey();
            ItemEventConfig config = entry.getValue();
            if (!config.enabled) {
                EnigmaticDice.LOGGER.info("Config {} is disabled.", (Object)eventName);
                continue;
            }
            if (!ModList.get().isLoaded(config.requiredMod)) {
                EnigmaticDice.LOGGER.info("Skipping event {}: required mod {} is missing.", (Object)eventName, (Object)config.requiredMod);
                continue;
            }
            this.events.add(new GiveItemEvent(config.item, config.rarity, config.amount, config.nbt, config.chatMessage));
            this.eventNames.add(eventName);
        }
    }

    private void loadUniqueEvents() {
        block88: for (Map.Entry<String, UniqueEventConfig> entry : EnigmaticDiceConfig.configData.uniqueEvents.entrySet()) {
            String eventName = entry.getKey();
            UniqueEventConfig config = entry.getValue();
            if (!config.enabled) {
                EnigmaticDice.LOGGER.info("Config {} is disabled.", (Object)eventName);
                continue;
            }
            if (!ModList.get().isLoaded(config.requiredMod)) {
                EnigmaticDice.LOGGER.info("Skipping event {}: required mod {} is missing.", (Object)eventName, (Object)config.requiredMod);
                continue;
            }
            switch (eventName) {
                case "minecraft_explosion": {
                    this.events.add(new ExplosionEvent(4.0f, false, false, config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_lightning_strike": {
                    this.events.add(new LightningStrikeEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_permanent_buff": {
                    this.events.add(new PermanentBuffEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_ancient_debris_cage": {
                    this.events.add(new AncientDebrisCageEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_teleport_to_biome": {
                    this.events.add(new TeleportToBiomeEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_teleport_to_structure": {
                    this.events.add(new TeleportToStructureEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_teleport_to_world_edge": {
                    this.events.add(new TeleportToWorldEdgeEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_summon_horse": {
                    this.events.add(new SummonTamedHorse(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_mass_creeper_summon_1": {
                    this.events.add(new MassCreeperSummonEvent(config.rarity, 1));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_mass_creeper_summon_2": {
                    this.events.add(new MassCreeperSummonEvent(config.rarity, 2));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_mass_creeper_summon_3": {
                    this.events.add(new MassCreeperSummonEvent(config.rarity, 3));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_mass_creeper_summon_4": {
                    this.events.add(new MassCreeperSummonEvent(config.rarity, 4));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_give_vanilla_random_potion": {
                    this.events.add(new GiveRandomPotionEvent(config.rarity, true));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_give_modded_random_potion": {
                    this.events.add(new GiveRandomPotionEvent(config.rarity, false));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_curse_binding": {
                    this.events.add(new CurseBindingEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_skyfall_training": {
                    this.events.add(new SkyfallTraining(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_day_of_invisibility": {
                    this.events.add(new DayOfInvisibility(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_day_of_tag": {
                    this.events.add(new DayOfTag(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_day_of_strength": {
                    this.events.add(new DayOfStrength(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_day_on_the_moon": {
                    this.events.add(new DayOnTheMoon(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_teleport_monsters_to_player": {
                    this.events.add(new TeleportMonstersToPlayer(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_accelerate_day_cycle": {
                    this.events.add(new AccelerateDayCycleEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_mini_size_shrink": {
                    this.events.add(new MiniSizeShrinkEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_ant_size_shrink": {
                    this.events.add(new AntSizeShrinkEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "minecraft_summon_spider_fleas": {
                    this.events.add(new SummonSpiderFleasEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "enigmaticlegacy_eternal_binding": {
                    this.events.add(new EternalBindingEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "alexsmobs_summon_warped_toads": {
                    this.events.add(new SummonWarpedToadsEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "alexsmobs_summon_centipede": {
                    this.events.add(new SummonCentipedeEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "alexscaves_nuclear_bomb": {
                    this.events.add(new NuclearBombEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "alexscaves_summon_raycat": {
                    this.events.add(new SummonRaycatEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "alexscaves_summon_subterranodon": {
                    this.events.add(new SummonSubterranodonEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "alexscaves_summon_vallumraptor": {
                    this.events.add(new SummonVallumraptorEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "alexscaves_summon_candicorn": {
                    this.events.add(new SummonCandicornEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "artifacts_summon_mimic": {
                    this.events.add(new SummonMimic(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "artifacts_wonderland_field": {
                    this.events.add(new WonderlandField(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "artifacts_summon_dummy_chest": {
                    this.events.add(new SummonDummyChest(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "netherexp_summon_carcass": {
                    this.events.add(new SummonCarcassEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "terramity_black_hole_bomb": {
                    this.events.add(new BlackHoleBombEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "terramity_macro_black_hole_bomb": {
                    this.events.add(new MacroBlackHoleBombEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "terramity_antimatter_bomb": {
                    this.events.add(new AntimatterBombEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "quark_give_ancient_tome": {
                    this.events.add(new GiveAncientTomeEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
                case "born_in_chaos_brood_awakens": {
                    this.events.add(new BroodAwakensEvent(config.rarity));
                    this.eventNames.add(eventName);
                    continue block88;
                }
            }
            EnigmaticDice.LOGGER.warn("Unknown fixed event in config: {}", (Object)eventName);
        }
    }

    public void triggerRandomEvent(Level pLevel, Player pPlayer) {
        RandomEvent event;
        boolean eventTriggered;
        while (!(eventTriggered = (event = this.events.get(pLevel.m_213780_().m_188503_(this.events.size()))).execute(pLevel, pPlayer))) {
        }
    }

    public void simulationRandomEvent(Level pLevel, Player pPlayer, int simulationsCount) {
        HashMap<String, Integer> eventWinCounts = new HashMap<String, Integer>();
        for (String eventName : this.eventNames) {
            eventWinCounts.put(eventName, 0);
        }
        for (int i = 0; i < simulationsCount; ++i) {
            String eventName;
            RandomEvent event;
            boolean eventTriggered;
            do {
                int numberOfEvent = pLevel.m_213780_().m_188503_(this.events.size());
                event = this.events.get(numberOfEvent);
                eventName = this.eventNames.get(numberOfEvent);
            } while (!(eventTriggered = event.simulationExecute(pLevel, pPlayer)));
            eventWinCounts.put(eventName, (Integer)eventWinCounts.get(eventName) + 1);
        }
        this.saveResultsToFile(pLevel, pPlayer, eventWinCounts, simulationsCount);
    }

    private void saveResultsToFile(Level pLevel, Player pPlayer, Map<String, Integer> eventWinCounts, int totalSimulations) {
        MinecraftServer server = pLevel.m_7654_();
        if (server == null) {
            return;
        }
        File worldFolder = server.m_129843_(LevelResource.f_78182_).toFile();
        File resultFile = new File(worldFolder, "enigmatic_dice_simulation_results.txt");
        HashSet<String> negativeSet = null;
        HashSet<String> neutralSet = null;
        if (EnigmaticDiceConfig.configData != null) {
            if (EnigmaticDiceConfig.configData.negativeEvents != null) {
                negativeSet = new HashSet<String>(EnigmaticDiceConfig.configData.negativeEvents);
            }
            if (EnigmaticDiceConfig.configData.neutralEvents != null) {
                neutralSet = new HashSet<String>(EnigmaticDiceConfig.configData.neutralEvents);
            }
        }
        if (negativeSet != null && neutralSet != null) {
            negativeSet.removeAll(neutralSet);
        }
        try (FileWriter writer = new FileWriter(resultFile);){
            writer.write("Total simulations: " + totalSimulations + "\n");
            writer.write("Player Luck: " + String.format("%.2f", Float.valueOf(pPlayer.m_36336_())) + "\n");
            writer.write("\n");
            int negativeCount = 0;
            int neutralCount = 0;
            int positiveCount = 0;
            Set<String> neg = negativeSet != null ? negativeSet : Collections.emptySet();
            Set<String> neu = neutralSet != null ? neutralSet : Collections.emptySet();
            for (Map.Entry<String, Integer> e : eventWinCounts.entrySet()) {
                int count;
                String name = e.getKey();
                int n = count = e.getValue() != null ? e.getValue() : 0;
                if (neg.contains(name)) {
                    negativeCount += count;
                    continue;
                }
                if (neu.contains(name)) {
                    neutralCount += count;
                    continue;
                }
                positiveCount += count;
            }
            double denom = totalSimulations > 0 ? (double)totalSimulations : 1.0;
            double negativeChance = (double)negativeCount / denom * 100.0;
            double neutralChance = (double)neutralCount / denom * 100.0;
            double positiveChance = (double)positiveCount / denom * 100.0;
            writer.write("Negative events total: " + negativeCount + " occurrences (" + String.format("%.2f", negativeChance) + "%)\n");
            writer.write("Neutral events total: " + neutralCount + " occurrences (" + String.format("%.2f", neutralChance) + "%)\n");
            writer.write("Positive events total: " + positiveCount + " occurrences (" + String.format("%.2f", positiveChance) + "%)\n\n");
            ArrayList<Map.Entry<String, Integer>> sortedEntries = new ArrayList<Map.Entry<String, Integer>>(eventWinCounts.entrySet());
            sortedEntries.sort((e1, e2) -> {
                int index1 = this.eventNames.indexOf(e1.getKey());
                int index2 = this.eventNames.indexOf(e2.getKey());
                return Integer.compare(index1, index2);
            });
            for (Map.Entry entry : sortedEntries) {
                String eventName = (String)entry.getKey();
                int count = (Integer)entry.getValue();
                double percentage = (double)count / (double)totalSimulations * 100.0;
                writer.write(eventName + ": " + count + " occurrences (" + String.format("%.2f", percentage) + "%)\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<Integer, Map<String, Double>> buildLuckRangeResults(Level pLevel, int simulationsCount) {
        FakePlayer fakePlayer = RandomEventManager.createCleanFakePlayer((ServerLevel)pLevel);
        LinkedHashMap<Integer, Map<String, Double>> luckPercentages = new LinkedHashMap<Integer, Map<String, Double>>();
        List<RandomEvent> localEvents = this.events;
        List<String> localEventNames = this.eventNames;
        int eventsCount = localEvents.size();
        if (eventsCount == 0) {
            return luckPercentages;
        }
        List<Integer> luckLevels = this.buildCustomLuckLevels();
        for (int luck : luckLevels) {
            AttributeInstance luckAttr = fakePlayer.m_21051_(Attributes.f_22286_);
            if (luckAttr != null) {
                luckAttr.m_22100_((double)luck);
            }
            LinkedHashMap<String, Integer> counts = new LinkedHashMap<String, Integer>();
            for (String name : localEventNames) {
                counts.put(name, 0);
            }
            for (int i = 0; i < simulationsCount; ++i) {
                String eventName;
                RandomEvent event;
                boolean triggered;
                do {
                    int idx = pLevel.m_213780_().m_188503_(eventsCount);
                    event = localEvents.get(idx);
                    eventName = localEventNames.get(idx);
                } while (!(triggered = event.simulationExecute(pLevel, (Player)fakePlayer)));
                counts.put(eventName, (Integer)counts.get(eventName) + 1);
            }
            LinkedHashMap<String, Double> percentages = new LinkedHashMap<String, Double>();
            for (String name : localEventNames) {
                int c = counts.getOrDefault(name, 0);
                double pct = (double)c / (double)simulationsCount * 100.0;
                percentages.put(name, pct);
            }
            luckPercentages.put(luck, percentages);
        }
        return luckPercentages;
    }

    private static FakePlayer createCleanFakePlayer(ServerLevel serverLevel) {
        UUID uuid = UUID.nameUUIDFromBytes("enigmaticdice-sim".getBytes(StandardCharsets.UTF_8));
        FakePlayer fp = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)new GameProfile(uuid, "[EnigmaticDiceSim]"));
        BlockPos spawn = serverLevel.m_220360_();
        fp.m_8999_(serverLevel, (double)spawn.m_123341_() + 0.5, (double)spawn.m_123342_(), (double)spawn.m_123343_() + 0.5, 0.0f, 0.0f);
        fp.m_21219_();
        fp.m_150109_().m_6211_();
        AttributeInstance luckAttr = fp.m_21051_(Attributes.f_22286_);
        if (luckAttr != null) {
            luckAttr.m_22100_(0.0);
        }
        return fp;
    }

    public void saveLuckRangeResultsToFile(Level pLevel, Map<Integer, Map<String, Double>> luckPercentages, int simulationsCount) {
        MinecraftServer server = pLevel.m_7654_();
        if (server == null) {
            return;
        }
        File worldFolder = server.m_129843_(LevelResource.f_78182_).toFile();
        File resultFile = new File(worldFolder, "enigmatic_dice_luck_range_results.txt");
        int nameColWidth = 40;
        int luckColWidth = 8;
        List<Integer> luckLevels = this.buildCustomLuckLevels();
        HashSet<String> negativeSet = null;
        if (EnigmaticDiceConfig.configData != null && EnigmaticDiceConfig.configData.negativeEvents != null) {
            negativeSet = new HashSet<String>(EnigmaticDiceConfig.configData.negativeEvents);
        }
        HashSet<String> neutralSet = null;
        if (EnigmaticDiceConfig.configData != null && EnigmaticDiceConfig.configData.neutralEvents != null) {
            neutralSet = new HashSet<String>(EnigmaticDiceConfig.configData.neutralEvents);
        }
        if (negativeSet != null && neutralSet != null) {
            negativeSet.removeAll(neutralSet);
        }
        try (FileWriter writer = new FileWriter(resultFile);){
            writer.write("Simulations per luck level: " + simulationsCount + "\n\n");
            writer.write(String.format("%-40s", "Event Name                  Luck level"));
            Iterator<Object> iterator = luckLevels.iterator();
            while (iterator.hasNext()) {
                int luck = iterator.next();
                writer.write(String.format("%8d", luck));
            }
            writer.write("\n");
            if (luckPercentages.isEmpty()) {
                writer.write("No data (no events or simulation not run).\n");
                return;
            }
            for (String eventName : this.eventNames) {
                writer.write(String.format("%-40.39s", eventName));
                for (int luck : luckLevels) {
                    Map<String, Double> map = luckPercentages.get(luck);
                    double pct = 0.0;
                    if (map != null && map.containsKey(eventName)) {
                        pct = map.get(eventName);
                    }
                    writer.write(String.format("%8.2f", pct));
                }
                writer.write("\n");
            }
            writer.write("\n");
            writer.write(String.format("%-40s", "Positive Events Total"));
            iterator = luckLevels.iterator();
            while (iterator.hasNext()) {
                int luck = (Integer)iterator.next();
                Map<String, Double> map = luckPercentages.get(luck);
                double positiveSum = 0.0;
                if (map != null) {
                    for (Map.Entry<String, Double> e : map.entrySet()) {
                        Double v;
                        String name = e.getKey();
                        if (negativeSet != null && negativeSet.contains(name) || neutralSet != null && neutralSet.contains(name) || (v = e.getValue()) == null) continue;
                        positiveSum += v.doubleValue();
                    }
                }
                writer.write(String.format("%8.2f", positiveSum));
            }
            writer.write("\n");
            writer.write(String.format("%-40s", "Neutral Events Total"));
            iterator = luckLevels.iterator();
            while (iterator.hasNext()) {
                int luck = (Integer)iterator.next();
                writer.write(String.format("%8.2f", RandomEventManager.sumForSet(luckPercentages.get(luck), neutralSet)));
            }
            writer.write("\n");
            writer.write(String.format("%-40s", "Negative Events Total"));
            iterator = luckLevels.iterator();
            while (iterator.hasNext()) {
                int luck = (Integer)iterator.next();
                writer.write(String.format("%8.2f", RandomEventManager.sumForSet(luckPercentages.get(luck), negativeSet)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static double sumForSet(Map<String, Double> map, Set<String> set) {
        if (map == null || set == null || set.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        for (String name : set) {
            Double v = map.get(name);
            if (v == null) continue;
            sum += v.doubleValue();
        }
        return sum;
    }

    private List<Integer> buildCustomLuckLevels() {
        int i;
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (i = -1000; i <= -100; i += 100) {
            levels.add(i);
        }
        for (i = -100; i <= -20; i += 5) {
            if (levels.contains(i)) continue;
            levels.add(i);
        }
        for (i = -20; i <= 0; ++i) {
            if (levels.contains(i)) continue;
            levels.add(i);
        }
        for (i = 1; i <= 20; ++i) {
            levels.add(i);
        }
        for (i = 25; i <= 100; i += 5) {
            levels.add(i);
        }
        for (i = 200; i <= 1000; i += 100) {
            levels.add(i);
        }
        return levels;
    }

    public RandomEvent getEventByName(String name) {
        int index = this.eventNames.indexOf(name);
        if (index != -1) {
            return this.events.get(index);
        }
        return null;
    }

    public List<String> getEventNames() {
        return new ArrayList<String>(this.eventNames);
    }
}

