/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class RandomEvent {
    private boolean isNegativeEvent = false;
    private boolean isNeutralEvent = false;
    protected int rarity = 2;

    public abstract boolean execute(Level var1, Player var2, boolean var3);

    public boolean execute(Level pLevel, Player pPlayer) {
        return this.execute(pLevel, pPlayer, false);
    }

    public boolean simulationExecute(Level pLevel, Player pPlayer) {
        return this.rollChance(pLevel, pPlayer, this.rarity);
    }

    public boolean rollChance(Level pLevel, Player pPlayer, int rarity) {
        int i;
        float luck = pPlayer.m_36336_();
        RandomSource random = pLevel.m_213780_();
        if (this.isNeutralEvent) {
            return random.m_188503_(rarity) == 0;
        }
        int attempts = 1;
        if (!this.isNegativeEvent && luck > 0.0f) {
            for (i = 0; i < (int)luck; ++i) {
                if (!(random.m_188501_() < 0.1f)) continue;
                ++attempts;
            }
        } else if (this.isNegativeEvent && luck < 0.0f) {
            for (i = 0; i < (int)(-luck); ++i) {
                if (!(random.m_188501_() < 0.1f)) continue;
                ++attempts;
            }
        }
        for (i = 0; i < attempts; ++i) {
            if (random.m_188503_(rarity) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isNegativeEvent() {
        return this.isNegativeEvent;
    }

    public void setNegativeEvent(boolean negativeEvent) {
        this.isNegativeEvent = negativeEvent;
    }

    public boolean isNeutralEvent() {
        return this.isNeutralEvent;
    }

    public void setNeutralEvent(boolean neutralEvent) {
        this.isNeutralEvent = neutralEvent;
    }
}

