/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import java.util.Map;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PermanentBuffEvent
extends RandomEvent {
    private static final Map<MobEffect, String> EFFECT_MESSAGES = Map.of(MobEffects.f_19600_, "enigmaticdice.effect.damage_boost", MobEffects.f_19596_, "enigmaticdice.effect.movement_speed", MobEffects.f_19598_, "enigmaticdice.effect.dig_speed", MobEffects.f_19616_, "enigmaticdice.effect.health_boost", MobEffects.f_19611_, "enigmaticdice.effect.night_vision", MobEffects.f_19609_, "enigmaticdice.effect.invisibility", MobEffects.f_19607_, "enigmaticdice.effect.fire_resistance", MobEffects.f_19605_, "enigmaticdice.effect.regeneration");
    private static final int MAX_LEVEL = 2;
    private static final int MAX_LEVEL_SINGLE = 1;

    public PermanentBuffEvent(int rarity) {
        this.rarity = rarity;
    }

    @Override
    public boolean execute(Level pLevel, Player pPlayer, boolean guaranteed) {
        if (!guaranteed && !this.rollChance(pLevel, pPlayer, this.rarity)) {
            return false;
        }
        MobEffect[] effects = EFFECT_MESSAGES.keySet().toArray(new MobEffect[0]);
        for (int i = 0; i < effects.length; ++i) {
            int maxLevel;
            MobEffect effect = effects[pLevel.m_213780_().m_188503_(effects.length)];
            MobEffectInstance existingEffect = pPlayer.m_21124_(effect);
            int n = maxLevel = effect == MobEffects.f_19611_ || effect == MobEffects.f_19607_ || effect == MobEffects.f_19609_ ? 1 : 2;
            if (existingEffect == null) {
                pPlayer.m_7292_(new MobEffectInstance(effect, -1, 0, false, false));
                pPlayer.m_213846_((Component)Component.m_237115_((String)EFFECT_MESSAGES.get(effect)));
                return true;
            }
            if (existingEffect.m_19564_() >= maxLevel - 1) continue;
            pPlayer.m_7292_(new MobEffectInstance(effect, -1, existingEffect.m_19564_() + 1, false, false));
            pPlayer.m_213846_((Component)Component.m_237115_((String)EFFECT_MESSAGES.get(effect)));
            return true;
        }
        return false;
    }
}

