/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class MassCreeperSummonEvent
extends RandomEvent {
    private final int eventLevel;
    private static final int CREEPER_COUNT = 50;
    private static final int SPAWN_RADIUS = 30;

    public MassCreeperSummonEvent(int rarity, int eventLevel) {
        this.rarity = rarity;
        this.eventLevel = eventLevel;
    }

    @Override
    public boolean execute(Level pLevel, Player pPlayer, boolean guaranteed) {
        if (!guaranteed && !this.rollChance(pLevel, pPlayer, this.rarity)) {
            return false;
        }
        Random random = new Random();
        for (int i = 0; i < 50; ++i) {
            Vec3 spawnPos = this.findValidSpawnPosition(pLevel, pPlayer, random);
            Entity entity = EntityType.f_20558_.m_20615_(pLevel);
            System.out.println(i);
            if (!(entity instanceof Creeper)) continue;
            Creeper creeper = (Creeper)entity;
            System.out.println(1);
            creeper.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0f, 0.0f);
            if (random.nextFloat() < 0.5f) {
                CompoundTag tag = creeper.m_20240_(new CompoundTag());
                tag.m_128379_("powered", true);
                creeper.m_20258_(tag);
            }
            creeper.m_21530_();
            creeper.m_21051_(Attributes.f_22279_).m_22100_(0.0);
            this.applyLevelEffects(creeper, random);
            pLevel.m_7967_((Entity)creeper);
        }
        MutableComponent message = Component.m_237115_((String)("enigmaticdice.event.creeper_party.level." + this.eventLevel));
        pPlayer.m_5661_((Component)message, false);
        return true;
    }

    private Vec3 findValidSpawnPosition(Level level, Player player, Random random) {
        double angle = random.nextDouble() * Math.PI * 2.0;
        double distance = 30.0 * (0.15 + 0.85 * random.nextDouble());
        int x = (int)(player.m_20185_() + Math.cos(angle) * distance);
        int z = (int)(player.m_20189_() + Math.sin(angle) * distance);
        BlockPos surfacePos = level.m_5452_(Heightmap.Types.WORLD_SURFACE, new BlockPos(x, 0, z));
        return new Vec3((double)surfacePos.m_123341_() + 0.5, (double)surfacePos.m_123342_(), (double)surfacePos.m_123343_() + 0.5);
    }

    private void applyLevelEffects(Creeper creeper, Random random) {
        switch (this.eventLevel) {
            case 1: {
                break;
            }
            case 2: {
                creeper.m_7292_(new MobEffectInstance(MobEffects.f_19609_, -1, 0, true, true));
                break;
            }
            case 3: {
                creeper.m_7292_(new MobEffectInstance(MobEffects.f_19609_, -1, 0, false, false));
                break;
            }
            case 4: {
                creeper.m_7292_(new MobEffectInstance(MobEffects.f_19609_, -1, 0, false, false));
                MobEffect randomEffect = this.pickRandomEffect(random);
                if (randomEffect == null) break;
                creeper.m_7292_(new MobEffectInstance(randomEffect, -1, 0, false, false));
                break;
            }
        }
    }

    private MobEffect pickRandomEffect(Random random) {
        List effects = BuiltInRegistries.f_256974_.m_123024_().filter(effect -> effect != MobEffects.f_19609_).filter(effect -> !effect.m_8093_()).collect(Collectors.toList());
        if (effects.isEmpty()) {
            return null;
        }
        return (MobEffect)effects.get(random.nextInt(effects.size()));
    }
}

