/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class GiveRandomPotionEvent
extends RandomEvent {
    private final boolean onlyVanillaEffects;
    private final Random random = new Random();

    public GiveRandomPotionEvent(int rarity, boolean onlyVanillaEffects) {
        this.rarity = rarity;
        this.onlyVanillaEffects = onlyVanillaEffects;
    }

    @Override
    public boolean execute(Level pLevel, Player pPlayer, boolean guaranteed) {
        if (!guaranteed && !this.rollChance(pLevel, pPlayer, this.rarity)) {
            return false;
        }
        ItemStack potion = new ItemStack((ItemLike)Items.f_42736_);
        int effectCount = 3 + this.random.nextInt(4);
        ArrayList<MobEffect> availableEffects = new ArrayList<MobEffect>();
        for (MobEffect effect : ForgeRegistries.MOB_EFFECTS.getValues()) {
            if (this.onlyVanillaEffects) {
                ResourceLocation key = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
                if (key == null || !"minecraft".equals(key.m_135827_())) continue;
                availableEffects.add(effect);
                continue;
            }
            availableEffects.add(effect);
        }
        Collections.shuffle(availableEffects, this.random);
        ArrayList<MobEffectInstance> selectedEffects = new ArrayList<MobEffectInstance>();
        for (int i = 0; i < Math.min(effectCount, availableEffects.size()); ++i) {
            int amplifier;
            int duration;
            MobEffect effect = (MobEffect)availableEffects.get(i);
            if (effect.m_8093_()) {
                duration = 1;
                amplifier = this.random.nextInt(5);
            } else {
                int seconds = 10 + this.random.nextInt(890);
                duration = seconds * 20;
                amplifier = this.random.nextInt(3);
            }
            selectedEffects.add(new MobEffectInstance(effect, duration, amplifier));
        }
        PotionUtils.m_43552_((ItemStack)potion, selectedEffects);
        ListTag enchantments = new ListTag();
        CompoundTag fakeEnchant = new CompoundTag();
        fakeEnchant.m_128359_("id", "0");
        fakeEnchant.m_128376_("lvl", (short)0);
        enchantments.add((Object)fakeEnchant);
        potion.m_41784_().m_128365_("Enchantments", (Tag)enchantments);
        if (this.onlyVanillaEffects) {
            potion.m_41714_((Component)Component.m_237115_((String)"item.enigmaticdice.vanilla_random_splash_potion").m_130938_(style -> style.m_131155_(Boolean.valueOf(false))));
        } else {
            potion.m_41714_((Component)Component.m_237115_((String)"item.enigmaticdice.modded_random_splash_potion").m_130938_(style -> style.m_131155_(Boolean.valueOf(false))));
        }
        ItemEntity entity = new ItemEntity(pLevel, pPlayer.m_20185_(), pPlayer.m_20186_() + 1.0, pPlayer.m_20189_(), potion);
        pLevel.m_7967_((Entity)entity);
        MutableComponent message = this.onlyVanillaEffects ? Component.m_237115_((String)"enigmaticdice.event.vanilla_random_potion") : Component.m_237115_((String)"enigmaticdice.event.modded_random_potion");
        pPlayer.m_5661_((Component)message, false);
        return true;
    }
}

