/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.jrdemiurge.enigmaticdice.EnigmaticDice;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class GiveItemEvent
extends RandomEvent {
    private final String itemIdentifier;
    private final int quantity;
    private final String nbtString;
    private final String chatMessage;

    public GiveItemEvent(String itemIdentifier, int rarity, int quantity, String nbtString, String chatMessage) {
        this.itemIdentifier = itemIdentifier;
        this.rarity = rarity;
        this.quantity = Math.max(quantity, 1);
        this.nbtString = nbtString;
        this.chatMessage = chatMessage;
    }

    @Override
    public boolean execute(Level pLevel, Player pPlayer, boolean guaranteed) {
        if (!guaranteed && !this.rollChance(pLevel, pPlayer, this.rarity)) {
            return false;
        }
        ResourceLocation resourceLocation = new ResourceLocation(this.itemIdentifier);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        if (item == null) {
            EnigmaticDice.LOGGER.error("Item not found: {}", (Object)this.itemIdentifier);
            return false;
        }
        ItemStack itemStack = new ItemStack((ItemLike)item, this.quantity);
        if (!this.nbtString.isEmpty()) {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)this.nbtString);
                itemStack.m_41751_(nbt);
            }
            catch (CommandSyntaxException e) {
                EnigmaticDice.LOGGER.error("Error while parsing nbt: ", (Throwable)e);
            }
        }
        ItemEntity keyEntity = new ItemEntity(pLevel, pPlayer.m_20185_(), pPlayer.m_20186_() + 1.0, pPlayer.m_20189_(), itemStack);
        pLevel.m_7967_((Entity)keyEntity);
        MutableComponent message = Component.m_237115_((String)this.chatMessage);
        pPlayer.m_5661_((Component)message, false);
        return true;
    }
}

