/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import java.util.ArrayList;
import net.jrdemiurge.enigmaticdice.EnigmaticDice;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class GiveAncientTomeEvent
extends RandomEvent {
    public GiveAncientTomeEvent(int rarity) {
        this.rarity = rarity;
    }

    @Override
    public boolean execute(Level pLevel, Player pPlayer, boolean guaranteed) {
        if (!guaranteed && !this.rollChance(pLevel, pPlayer, this.rarity)) {
            return false;
        }
        ResourceLocation resourceLocation = new ResourceLocation("quark:ancient_tome");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        if (item == null) {
            EnigmaticDice.LOGGER.error("Item not found: {}", (Object)"quark:ancient_tome");
            return false;
        }
        ArrayList allEnchantments = new ArrayList(ForgeRegistries.ENCHANTMENTS.getValues());
        if (allEnchantments.isEmpty()) {
            EnigmaticDice.LOGGER.warn("No enchantments found in registry.");
            return false;
        }
        Enchantment chosenEnchantment = (Enchantment)allEnchantments.get(pLevel.f_46441_.m_188503_(allEnchantments.size()));
        ResourceLocation enchantmentId = ForgeRegistries.ENCHANTMENTS.getKey((Object)chosenEnchantment);
        if (enchantmentId == null) {
            EnigmaticDice.LOGGER.warn("Chosen enchantment has no ID.");
            return false;
        }
        ItemStack itemStack = new ItemStack((ItemLike)item);
        ListTag enchantmentList = new ListTag();
        CompoundTag enchantmentTag = new CompoundTag();
        enchantmentTag.m_128359_("id", enchantmentId.toString());
        enchantmentTag.m_128376_("lvl", (short)1);
        enchantmentList.add((Object)enchantmentTag);
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("StoredEnchantments", (Tag)enchantmentList);
        itemStack.m_41751_(tag);
        ItemEntity keyEntity = new ItemEntity(pLevel, pPlayer.m_20185_(), pPlayer.m_20186_() + 1.0, pPlayer.m_20189_(), itemStack);
        pLevel.m_7967_((Entity)keyEntity);
        MutableComponent message = Component.m_237115_((String)"enigmaticdice.gift.blue");
        pPlayer.m_5661_((Component)message, false);
        return true;
    }
}

