/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie;

import java.util.EnumSet;
import java.util.Map;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class EternalBindingEvent
extends RandomEvent {
    private static final ResourceLocation ETERNAL_BINDING_ID = new ResourceLocation("enigmaticlegacy", "eternal_binding");

    public EternalBindingEvent(int rarity) {
        this.rarity = rarity;
    }

    @Override
    public boolean execute(Level pLevel, Player pPlayer, boolean guaranteed) {
        if (!guaranteed && !this.rollChance(pLevel, pPlayer, this.rarity)) {
            return false;
        }
        Enchantment eternalBinding = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ETERNAL_BINDING_ID);
        if (eternalBinding == null) {
            return false;
        }
        boolean enchantedAny = false;
        for (EquipmentSlot slot : EnumSet.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET)) {
            ItemStack itemStack = pPlayer.m_6844_(slot);
            if (itemStack.m_41619_() || EnchantmentHelper.m_44831_((ItemStack)itemStack).containsKey(eternalBinding)) continue;
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)itemStack);
            enchantments.put(eternalBinding, 1);
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)itemStack);
            enchantedAny = true;
        }
        if (enchantedAny) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"enigmaticdice.event.eternal_binding"), false);
            return true;
        }
        return false;
    }
}

