/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom.crucibleofrile;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ClientLookController {
    private static UUID currentTargetUuid = null;
    private static int ticksLeft = 0;
    private static boolean active = false;
    private static final float MAX_YAW_SPEED_DEG_PER_SEC = 720.0f;
    private static final float MAX_PITCH_SPEED_DEG_PER_SEC = 720.0f;

    public static void startOrExtend(UUID target, int durationTicks) {
        if (active && Objects.equals(currentTargetUuid, target)) {
            ticksLeft = Math.max(ticksLeft, durationTicks);
        } else {
            currentTargetUuid = target;
            ticksLeft = Math.max(1, durationTicks);
            active = true;
        }
    }

    public static void stop() {
        active = false;
        currentTargetUuid = null;
        ticksLeft = 0;
    }

    public static void onRenderFrame(float partialTick) {
        if (!active) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            return;
        }
        Player target = mc.f_91073_.m_46003_(currentTargetUuid);
        if (target == null || !target.m_6084_()) {
            return;
        }
        Vec3 eye = player.m_20299_(partialTick);
        Vec3 tEye = target.m_20299_(partialTick);
        Vec3 dir = tEye.m_82546_(eye);
        double dx = dir.f_82479_;
        double dy = dir.f_82480_;
        double dz = dir.f_82481_;
        double horiz = Math.sqrt(dx * dx + dz * dz);
        float desiredYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float desiredPitch = (float)(-(Mth.m_14136_((double)dy, (double)horiz) * 57.29577951308232));
        desiredYaw = Mth.m_14177_((float)desiredYaw);
        desiredPitch = Mth.m_14036_((float)desiredPitch, (float)-90.0f, (float)90.0f);
        float dt = mc.m_91297_();
        float maxYawStep = 720.0f * dt;
        float maxPitchStep = 720.0f * dt;
        float newYaw = Mth.m_14148_((float)player.m_146908_(), (float)desiredYaw, (float)maxYawStep);
        float newPitch = Mth.m_14148_((float)player.m_146909_(), (float)desiredPitch, (float)maxPitchStep);
        player.m_146922_(newYaw);
        player.m_146926_(newPitch);
        player.m_5616_(newYaw);
        player.f_20883_ = newYaw;
    }

    public static void onClientTickEnd() {
        if (!active) {
            return;
        }
        if (--ticksLeft <= 0) {
            ClientLookController.stop();
        }
    }

    public static boolean isActive() {
        return active;
    }
}

