/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.effect.ModEffects;
import net.jrdemiurge.enigmaticdice.item.custom.unequalexchange.UnequalExchangeData;
import net.jrdemiurge.enigmaticdice.item.custom.unequalexchange.UnequalExchangeDataStorage;
import net.jrdemiurge.enigmaticdice.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class UnequalExchange
extends SwordItem {
    private Multimap<Attribute, AttributeModifier> configModifiers;
    private static final UUID HEALTH_DEBUFF_UUID = UUID.fromString("5f1d9b20-dfd6-4284-9d3a-004776a87bfd");
    private static final UUID ATTACK_SPEED_DEBUFF_UUID = UUID.fromString("27a72973-be25-44f0-9613-187812e4627c");
    private static final UUID ARMOR_DEBUFF_UUID = UUID.fromString("44371e08-d7ae-4344-8cfa-95c9fd4825c2");
    private static final UUID ARMOR_TOUGHNESS_DEBUFF_UUID = UUID.fromString("a6fb771d-97de-4883-86a8-1ba2b8db59c2");
    private static final UUID SPEED_DEBUFF_UUID = UUID.fromString("68403af9-c76e-4b08-8196-f264d872876d");

    public UnequalExchange(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot != EquipmentSlot.MAINHAND) {
            return super.m_7167_(slot);
        }
        if (this.configModifiers == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", Config.UnequalExchangeAttackDamage - 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", Config.UnequalExchangeAttackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
            this.configModifiers = builder.build();
        }
        return this.configModifiers;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        if (!attacker.m_9236_().f_46443_ && attacker instanceof Player && (player = (Player)attacker).m_36403_(0.5f) > 0.9f) {
            UnequalExchange.removeModifierIfExists(player, Attributes.f_22276_, HEALTH_DEBUFF_UUID);
            float targetMaxHealth = target.m_21233_();
            float attackerMaxHealth = attacker.m_21233_();
            float targetNewHealth = target.m_21223_() - targetMaxHealth * (float)Config.UnequalExchangeTargetHealthReduction;
            target.m_21153_(Math.max(targetNewHealth, 0.0f));
            if (target.m_21223_() <= 0.0f) {
                target.m_6667_(attacker.m_269291_().m_269075_(player));
            }
            float attackerNewHealth = attacker.m_21223_() - attackerMaxHealth * (float)Config.UnequalExchangePlayerHealthReduction;
            attacker.m_21153_(Math.max(attackerNewHealth, 0.0f));
            if (attacker.m_21223_() <= 0.0f) {
                attacker.m_6667_(attacker.m_269291_().m_269075_(player));
            }
            UnequalExchangeData data = UnequalExchangeDataStorage.get(player);
            data.onHit();
            UnequalExchange.updateModifiers(player, data);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.UNEQUAL_EXCHANGE_HIT.get(), SoundSource.PLAYERS, 0.3f, 1.0f);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public static void updateModifiers(Player player, UnequalExchangeData data) {
        double reductionFactor = -Config.UnequalExchangeStatDebuff * (double)data.getHitCount();
        double healthReduction = Math.max(reductionFactor, -0.8);
        UnequalExchange.removeModifierIfExists(player, Attributes.f_22276_, HEALTH_DEBUFF_UUID);
        UnequalExchange.removeModifierIfExists(player, Attributes.f_22283_, ATTACK_SPEED_DEBUFF_UUID);
        UnequalExchange.removeModifierIfExists(player, Attributes.f_22284_, ARMOR_DEBUFF_UUID);
        UnequalExchange.removeModifierIfExists(player, Attributes.f_22285_, ARMOR_TOUGHNESS_DEBUFF_UUID);
        UnequalExchange.removeModifierIfExists(player, Attributes.f_22279_, SPEED_DEBUFF_UUID);
        player.m_21051_(Attributes.f_22276_).m_22118_(new AttributeModifier(HEALTH_DEBUFF_UUID, "UnequalExchangeHealthDebuff", healthReduction, AttributeModifier.Operation.MULTIPLY_TOTAL));
        player.m_21051_(Attributes.f_22283_).m_22118_(new AttributeModifier(ATTACK_SPEED_DEBUFF_UUID, "UnequalExchangeAttackSpeedDebuff", reductionFactor, AttributeModifier.Operation.MULTIPLY_TOTAL));
        player.m_21051_(Attributes.f_22284_).m_22118_(new AttributeModifier(ARMOR_DEBUFF_UUID, "UnequalExchangeArmorDebuff", reductionFactor, AttributeModifier.Operation.MULTIPLY_TOTAL));
        player.m_21051_(Attributes.f_22285_).m_22118_(new AttributeModifier(ARMOR_TOUGHNESS_DEBUFF_UUID, "UnequalExchangeArmorToughnessDebuff", reductionFactor, AttributeModifier.Operation.MULTIPLY_TOTAL));
        player.m_21051_(Attributes.f_22279_).m_22118_(new AttributeModifier(SPEED_DEBUFF_UUID, "UnequalExchangeSpeedDebuff", reductionFactor, AttributeModifier.Operation.MULTIPLY_TOTAL));
        if (player.m_21223_() > player.m_21233_()) {
            player.m_21153_(player.m_21233_());
        }
        player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.UNEQUAL_EXCHANGE_DEBUFFS.get(), data.getTimeLeftTicks(), data.getHitCount() - 1));
    }

    private static void removeModifierIfExists(Player player, Attribute attribute, UUID uuid) {
        if (player.m_21051_(attribute) != null && player.m_21051_(attribute).m_22111_(uuid) != null) {
            player.m_21051_(attribute).m_22120_(uuid);
        }
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.unequal_exchange_1"));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.unequal_exchange_2", (Object[])new Object[]{String.valueOf(Config.UnequalExchangeTargetHealthReduction * 100.0) + "%"}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.unequal_exchange_3", (Object[])new Object[]{String.valueOf(Config.UnequalExchangePlayerHealthReduction * 100.0) + "%"}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.unequal_exchange_4", (Object[])new Object[]{Config.UnequalExchangeDebuffDuration}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.unequal_exchange_5", (Object[])new Object[]{String.valueOf(Config.UnequalExchangeStatDebuff * 100.0) + "%"}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.unequal_exchange_6", (Object[])new Object[]{String.valueOf(Config.UnequalExchangeStatDebuff * 100.0) + "%"}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.unequal_exchange_7", (Object[])new Object[]{String.valueOf(Config.UnequalExchangeStatDebuff * 100.0) + "%"}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.unequal_exchange_8", (Object[])new Object[]{String.valueOf(Config.UnequalExchangeStatDebuff * 100.0) + "%"}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.unequal_exchange_9", (Object[])new Object[]{String.valueOf(Config.UnequalExchangeStatDebuff * 100.0) + "%"}).m_130940_(ChatFormatting.GOLD));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.unequal_exchange_0"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.holdShift"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

