/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.effect.ModEffects;
import net.jrdemiurge.enigmaticdice.item.custom.souleater.SoulEaterData;
import net.jrdemiurge.enigmaticdice.item.custom.souleater.SoulEaterDataStorage;
import net.jrdemiurge.enigmaticdice.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SoulEater
extends SwordItem {
    private Multimap<Attribute, AttributeModifier> configModifiers;
    private static final UUID SOUL_EATER_HEALTH_BUFF_UUID = UUID.fromString("1c378b22-ac27-406d-a123-9fa54753f35b");
    private static final Map<UUID, Long> lastAbilityUseTime = new HashMap<UUID, Long>();

    public SoulEater(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot != EquipmentSlot.MAINHAND) {
            return super.m_7167_(slot);
        }
        if (this.configModifiers == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", Config.SoulEaterAttackDamage - 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", Config.SoulEaterAttackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
            this.configModifiers = builder.build();
        }
        return this.configModifiers;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().f_46443_ && attacker instanceof Player) {
            Player player = (Player)attacker;
            CompoundTag playerData = attacker.getPersistentData();
            String dataKey = "soul_eater_spent_health_sum";
            float usedHp = playerData.m_128457_(dataKey);
            float magicDamage = usedHp * (float)Config.SoulEaterChargedAttackDamagePerHP;
            long elapsedTime = attacker.m_9236_().m_46467_() - lastAbilityUseTime.getOrDefault(player.m_20148_(), -1L);
            if (magicDamage > 0.0f && elapsedTime < 20L * (long)Config.SoulEaterChargeDuration) {
                target.f_19802_ = 0;
                target.m_6469_(attacker.m_269291_().m_269104_((Entity)attacker, (Entity)attacker), magicDamage);
                playerData.m_128350_(dataKey, 0.0f);
                attacker.m_21195_((MobEffect)ModEffects.SOUL_EATER_CHARGED_HIT.get());
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.SOUL_EATER_CHARGED_HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (target.m_21223_() <= 0.0f) {
                    attacker.m_5634_(usedHp / 2.0f);
                }
            }
            if (target.m_21223_() <= 0.0f) {
                attacker.m_5634_(target.m_21233_() * (float)Config.SoulEaterHealPercentOnKill);
                AttributeInstance attr = player.m_21051_(Attributes.f_22276_);
                if (attr != null) {
                    SoulEaterData data = SoulEaterDataStorage.get(player);
                    if (attr.m_22111_(SOUL_EATER_HEALTH_BUFF_UUID) != null) {
                        attr.m_22120_(SOUL_EATER_HEALTH_BUFF_UUID);
                    } else {
                        data.reset();
                    }
                    float bonusHealth = target.m_21233_() * (float)Config.SoulEaterMaxHealthStealPercent;
                    float newBonusHealth = Math.min(bonusHealth + data.getHpCount(), player.m_21233_() * (float)Config.SoulEaterMaxHealthMultiplierLimit);
                    data.onKill(newBonusHealth);
                    attr.m_22118_(new AttributeModifier(SOUL_EATER_HEALTH_BUFF_UUID, "SoulEaterBonusHealth", (double)newBonusHealth, AttributeModifier.Operation.ADDITION));
                    attacker.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SOUL_EATER_HEALTH_BOOST.get(), 20 * Config.SoulEaterMaxHealthBuffDuration, 0));
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack item = pPlayer.m_21120_(pUsedHand);
        CompoundTag playerData = pPlayer.getPersistentData();
        String dataKey = "soul_eater_spent_health_sum";
        playerData.m_128350_(dataKey, 0.0f);
        pPlayer.m_6672_(pUsedHand);
        return InteractionResultHolder.m_19096_((Object)item);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (!pLevel.f_46443_ && pRemainingUseDuration % 10 == 0) {
            CompoundTag playerData = pLivingEntity.getPersistentData();
            String dataKey = "soul_eater_spent_health_sum";
            float userNewHealth = pLivingEntity.m_21223_() - pLivingEntity.m_21233_() * 0.2f;
            userNewHealth = Math.max(userNewHealth, 1.0f);
            float spentHealth = pLivingEntity.m_21223_() - userNewHealth;
            pLivingEntity.m_21153_(userNewHealth);
            float spentHealthSum = playerData.m_128457_(dataKey) + spentHealth;
            playerData.m_128350_(dataKey, spentHealthSum);
            lastAbilityUseTime.put(pLivingEntity.m_20148_(), pLevel.m_46467_());
            pLivingEntity.m_21195_((MobEffect)ModEffects.SOUL_EATER_CHARGED_HIT.get());
            if (spentHealthSum > 0.0f) {
                pLivingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SOUL_EATER_CHARGED_HIT.get(), 20 * Config.SoulEaterChargeDuration, (int)(spentHealthSum - 1.0f)));
            }
            if (userNewHealth <= 1.0f && pLivingEntity instanceof Player) {
                Player player = (Player)pLivingEntity;
                player.m_5810_();
            }
        }
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_36335_().m_41524_((Item)this, 40);
        }
    }

    public int m_8105_(ItemStack pStack) {
        return 100;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.NONE;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.soul_eater_1"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.soul_eater_2"));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.soul_eater_3", (Object[])new Object[]{Config.SoulEaterChargedAttackDamagePerHP}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.soul_eater_4"));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.soul_eater_5"));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.soul_eater_6", (Object[])new Object[]{String.valueOf(Config.SoulEaterHealPercentOnKill * 100.0) + "%"}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.soul_eater_7", (Object[])new Object[]{String.valueOf(Config.SoulEaterMaxHealthStealPercent * 100.0) + "%", (double)Config.SoulEaterMaxHealthBuffDuration / 60.0, String.valueOf(Config.SoulEaterMaxHealthMultiplierLimit * 100.0) + "%"}).m_130940_(ChatFormatting.GOLD));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.soul_eater_0"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.holdShift"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

