/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom;

import java.util.List;
import java.util.Random;
import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class RingOfAgility
extends Item
implements ICurioItem {
    private static final Random RANDOM = new Random();

    public RingOfAgility(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
        return true;
    }

    public static boolean isWearingRingOfAgility(LivingEntity livingEntity) {
        return CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(handler -> !handler.findCurios((Item)ModItems.RING_OF_AGILITY.get()).isEmpty()).orElse(false);
    }

    public static boolean shouldDodge(LivingEntity livingEntity) {
        AttributeInstance movementSpeedAttr = livingEntity.m_21051_(Attributes.f_22279_);
        if (movementSpeedAttr == null) {
            return false;
        }
        double movementSpeed = movementSpeedAttr.m_22135_();
        double scale = Config.RingOfAgilityChanceScale;
        double maxChance = Config.RingOfAgilityMaxDodgeChance;
        double dodgeChance = 1.0 - Math.pow(0.99, movementSpeed * 100.0 * scale);
        dodgeChance = Math.min(dodgeChance, maxChance);
        return RANDOM.nextDouble() < dodgeChance;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            double dodgeChance;
            if (Minecraft.m_91087_().f_91074_ != null) {
                AttributeInstance movementSpeedAttr = Minecraft.m_91087_().f_91074_.m_21051_(Attributes.f_22279_);
                double movementSpeed = movementSpeedAttr.m_22135_();
                double scale = Config.RingOfAgilityChanceScale;
                double maxChance = Config.RingOfAgilityMaxDodgeChance;
                dodgeChance = 1.0 - Math.pow(0.99, movementSpeed * 100.0 * scale);
                dodgeChance = Math.min(dodgeChance, maxChance);
            } else {
                dodgeChance = 0.1;
            }
            String formattedChance = String.format("%.1f", dodgeChance * 100.0);
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.ring_of_agility_1", (Object[])new Object[]{formattedChance}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.ring_of_agility_2"));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.ring_of_agility_0"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.holdShift"));
        }
    }
}

