/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.effect.ModEffects;
import net.jrdemiurge.enigmaticdice.item.ModItems;
import net.jrdemiurge.enigmaticdice.scheduler.Scheduler;
import net.jrdemiurge.enigmaticdice.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class Permafrost
extends SwordItem {
    private Multimap<Attribute, AttributeModifier> configModifiers;
    public static final String PERSISTENT_DATA_PERMAFROST_STACKS_FLY_SPEED_REDUCTION = "PermafrostStacksFlySpeedReduction";
    public static final String PERSISTENT_DATA_PERMAFROST_AURA_FLY_SPEED_REDUCTION = "PermafrostAuraFlySpeedReduction";
    private static final UUID STACKED_SPEED_DEBUFF_UUID = UUID.fromString("52276cff-92bc-4a7b-aaf3-56edcdd49521");
    private static final UUID STACKED_FLYING_SPEED_DEBUFF_UUID = UUID.fromString("3feb3b9b-a99c-42b3-9d2a-e53ca1ca5440");
    private static final UUID AURA_SPEED_DEBUFF_UUID = UUID.fromString("a2f507ba-3631-4a91-ace0-41711c981a47");
    private static final UUID AURA_FLYING_SPEED_DEBUFF_UUID = UUID.fromString("60c8804b-cb86-4efc-8a9a-63f7801731ac");
    public static final Map<UUID, Integer> stackMap = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastHitTimeMap = new HashMap<UUID, Long>();
    public static final Set<UUID> auraApplied = new HashSet<UUID>();
    private static final Map<UUID, Long> lastAuraTimeMap = new HashMap<UUID, Long>();

    public Permafrost(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot != EquipmentSlot.MAINHAND) {
            return super.m_7167_(slot);
        }
        if (this.configModifiers == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", Config.PermafrostAttackDamage - 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", Config.PermafrostAttackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
            this.configModifiers = builder.build();
        }
        return this.configModifiers;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        if (!attacker.m_9236_().f_46443_ && attacker instanceof Player && (player = (Player)attacker).m_36403_(0.5f) > 0.9f) {
            AttributeInstance flyingSpeedAttribute;
            int debuffDuration = Config.PermafrostAttackDebuffDuration;
            int maxStacks = Config.PermafrostAttackMaxStacks;
            double reductionFactorPerStack = Config.PermafrostAttackReductionPerStack;
            UUID targetId = target.m_20148_();
            int stacksOld = stackMap.getOrDefault(targetId, 0);
            int stacks = Math.min(maxStacks, stacksOld + 1);
            stackMap.put(targetId, stacks);
            long gameTime = target.m_9236_().m_46467_();
            lastHitTimeMap.put(targetId, gameTime);
            if (stacks == maxStacks) {
                player.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)ModSounds.PERMAFROST_FROZEN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (stacks == maxStacks && target instanceof Player) {
                Player targetPlayer = (Player)target;
                targetPlayer.m_36321_();
            }
            double reductionFactor = -reductionFactorPerStack * (double)stacks;
            AttributeInstance movementSpeedAttribute = target.m_21051_(Attributes.f_22279_);
            if (movementSpeedAttribute != null) {
                movementSpeedAttribute.m_22120_(STACKED_SPEED_DEBUFF_UUID);
                AttributeModifier slowModifier = new AttributeModifier(STACKED_SPEED_DEBUFF_UUID, "PermafrostStackedSpeedDebuff", reductionFactor, AttributeModifier.Operation.MULTIPLY_TOTAL);
                movementSpeedAttribute.m_22118_(slowModifier);
            }
            if ((flyingSpeedAttribute = target.m_21051_(Attributes.f_22280_)) != null) {
                flyingSpeedAttribute.m_22120_(STACKED_FLYING_SPEED_DEBUFF_UUID);
                AttributeModifier slowModifier = new AttributeModifier(STACKED_FLYING_SPEED_DEBUFF_UUID, "PermafrostStackedFlyingSpeedDebuff", reductionFactor, AttributeModifier.Operation.MULTIPLY_TOTAL);
                flyingSpeedAttribute.m_22118_(slowModifier);
            }
            target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_HIT.get(), debuffDuration, stacks - 1));
            float flyingSpeedReduction = 0.05f * (float)reductionFactorPerStack;
            if (target instanceof Player) {
                Player targetPlayer = (Player)target;
                if (stacks > stacksOld) {
                    float currentFlySpeed = targetPlayer.m_150110_().m_35942_();
                    targetPlayer.m_150110_().m_35943_(currentFlySpeed - flyingSpeedReduction);
                    targetPlayer.m_6885_();
                    targetPlayer.getPersistentData().m_128350_(PERSISTENT_DATA_PERMAFROST_STACKS_FLY_SPEED_REDUCTION, flyingSpeedReduction * (float)stacks);
                }
            }
            Scheduler.schedule(() -> {
                if (gameTime == lastHitTimeMap.getOrDefault(targetId, -1L)) {
                    if (target instanceof Player) {
                        Player targetPlayer = (Player)target;
                        float restoredFlySpeed = targetPlayer.m_150110_().m_35942_() + flyingSpeedReduction * (float)stackMap.getOrDefault(targetId, 0).intValue();
                        targetPlayer.m_150110_().m_35943_(restoredFlySpeed);
                        targetPlayer.m_6885_();
                        targetPlayer.getPersistentData().m_128473_(PERSISTENT_DATA_PERMAFROST_STACKS_FLY_SPEED_REDUCTION);
                    }
                    if (movementSpeedAttribute != null && target.m_6084_()) {
                        movementSpeedAttribute.m_22120_(STACKED_SPEED_DEBUFF_UUID);
                    }
                    if (flyingSpeedAttribute != null && target.m_6084_()) {
                        flyingSpeedAttribute.m_22120_(STACKED_FLYING_SPEED_DEBUFF_UUID);
                    }
                    if (target.m_6084_()) {
                        player.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)ModSounds.PERMAFROST_UNFROZEN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    stackMap.remove(targetId);
                    lastHitTimeMap.remove(targetId);
                }
            }, debuffDuration);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pLevel.f_46443_ && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pLevel.m_46467_() % 5L != 0L) {
                return;
            }
            boolean isInMainHand = player.m_21205_().m_150930_((Item)ModItems.PERMAFROST.get());
            if (isInMainHand) {
                int auraRadius = Config.PermafrostAuraRadius;
                int debuffDuration = Config.PermafrostAuraDebuffDuration;
                double reductionFactor = Config.PermafrostAuraReductionFactor;
                AABB area = pEntity.m_20191_().m_82400_((double)auraRadius);
                List victims = pLevel.m_6443_(LivingEntity.class, area, e -> e != player && e.m_6084_() && e.m_6087_());
                for (LivingEntity victim : victims) {
                    AttributeInstance flyingSpeedAttribute;
                    if (!Permafrost.checkFriendlyFire(victim, (LivingEntity)player)) continue;
                    UUID targetId = victim.m_20148_();
                    long gameTime = victim.m_9236_().m_46467_();
                    lastAuraTimeMap.put(targetId, gameTime);
                    AttributeInstance movementSpeedAttribute = victim.m_21051_(Attributes.f_22279_);
                    if (movementSpeedAttribute != null) {
                        movementSpeedAttribute.m_22120_(AURA_SPEED_DEBUFF_UUID);
                        AttributeModifier slowModifier = new AttributeModifier(AURA_SPEED_DEBUFF_UUID, "PermafrostAuraSpeedDebuff", -reductionFactor, AttributeModifier.Operation.MULTIPLY_TOTAL);
                        movementSpeedAttribute.m_22118_(slowModifier);
                    }
                    if ((flyingSpeedAttribute = victim.m_21051_(Attributes.f_22280_)) != null) {
                        flyingSpeedAttribute.m_22120_(AURA_FLYING_SPEED_DEBUFF_UUID);
                        AttributeModifier slowModifier = new AttributeModifier(AURA_FLYING_SPEED_DEBUFF_UUID, "PermafrostAuraFlyingSpeedDebuff", -reductionFactor, AttributeModifier.Operation.MULTIPLY_TOTAL);
                        flyingSpeedAttribute.m_22118_(slowModifier);
                    }
                    victim.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_AURA.get(), debuffDuration, 0));
                    float flyingSpeedReduction = 0.05f * (float)reductionFactor;
                    if (victim instanceof Player) {
                        Player targetPlayer = (Player)victim;
                        if (!auraApplied.contains(targetId)) {
                            float currentFlySpeed = targetPlayer.m_150110_().m_35942_();
                            targetPlayer.m_150110_().m_35943_(currentFlySpeed - flyingSpeedReduction);
                            targetPlayer.m_6885_();
                            auraApplied.add(targetId);
                            targetPlayer.getPersistentData().m_128350_(PERSISTENT_DATA_PERMAFROST_AURA_FLY_SPEED_REDUCTION, flyingSpeedReduction);
                        }
                    }
                    Scheduler.schedule(() -> {
                        if (gameTime == lastAuraTimeMap.getOrDefault(targetId, -1L)) {
                            if (movementSpeedAttribute != null && victim.m_6084_()) {
                                movementSpeedAttribute.m_22120_(AURA_SPEED_DEBUFF_UUID);
                            }
                            if (flyingSpeedAttribute != null && victim.m_6084_()) {
                                flyingSpeedAttribute.m_22120_(AURA_FLYING_SPEED_DEBUFF_UUID);
                            }
                            if (victim instanceof Player) {
                                Player targetPlayer = (Player)victim;
                                float restoredFlySpeed = targetPlayer.m_150110_().m_35942_() + flyingSpeedReduction;
                                targetPlayer.m_150110_().m_35943_(restoredFlySpeed);
                                targetPlayer.m_6885_();
                                auraApplied.remove(targetId);
                                targetPlayer.getPersistentData().m_128473_(PERSISTENT_DATA_PERMAFROST_AURA_FLY_SPEED_REDUCTION);
                            }
                            lastAuraTimeMap.remove(targetId);
                        }
                    }, debuffDuration);
                }
                BlockPos center = player.m_20183_();
                for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_(-auraRadius, -auraRadius, -auraRadius), (BlockPos)center.m_7918_(auraRadius, auraRadius, auraRadius))) {
                    if (!pos.m_203195_((Position)center.m_252807_(), (double)auraRadius)) continue;
                    BlockState bs = pLevel.m_8055_(pos);
                    FluidState fs = bs.m_60819_();
                    if (fs.m_192917_((Fluid)Fluids.f_76193_)) {
                        if (bs.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)bs.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) continue;
                        pLevel.m_46597_(pos, Blocks.f_50126_.m_49966_());
                        continue;
                    }
                    if (fs.m_192917_((Fluid)Fluids.f_76195_)) {
                        pLevel.m_46597_(pos, Blocks.f_50080_.m_49966_());
                        continue;
                    }
                    if (!fs.m_192917_((Fluid)Fluids.f_76194_)) continue;
                    pLevel.m_46597_(pos, Blocks.f_50652_.m_49966_());
                }
            }
        }
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public static boolean checkFriendlyFire(LivingEntity target, LivingEntity attacker) {
        OwnableEntity tameable;
        Team attackerTeam = attacker.m_5647_();
        Team entityTeam = target.m_5647_();
        if (entityTeam != null && attackerTeam == entityTeam && !attackerTeam.m_6260_()) {
            return false;
        }
        if (target instanceof OwnableEntity && (tameable = (OwnableEntity)target).m_269323_() != null) {
            LivingEntity owner = tameable.m_269323_();
            if (owner == attacker) {
                return false;
            }
            Team ownerTeam = owner.m_5647_();
            if (ownerTeam != null && attackerTeam == ownerTeam && !attackerTeam.m_6260_()) {
                return false;
            }
        }
        return true;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            int stackDebuffDuration = Config.PermafrostAttackDebuffDuration / 20;
            int maxStacks = Config.PermafrostAttackMaxStacks;
            double reductionFactorPerStack = Config.PermafrostAttackReductionPerStack * 100.0;
            int auraRadius = Config.PermafrostAuraRadius;
            double auraReductionFactor = Config.PermafrostAuraReductionFactor * 100.0;
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.permafrost_1"));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.permafrost_2", (Object[])new Object[]{reductionFactorPerStack, stackDebuffDuration}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.permafrost_3", (Object[])new Object[]{maxStacks}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.permafrost_4"));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.permafrost_5", (Object[])new Object[]{auraRadius}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.permafrost_6", (Object[])new Object[]{auraReductionFactor}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.permafrost_7"));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.holdShift"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

