/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom;

import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.item.ModItems;
import net.jrdemiurge.enigmaticdice.scheduler.Scheduler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;

public class MoonShard
extends Item {
    private static final UUID GRAVITY_MODIFIER_UUID = UUID.fromString("205dfaf9-1a96-4005-9a30-5d736a87c9b4");
    private static final WeakHashMap<Player, Boolean> gravityDisable = new WeakHashMap();

    public MoonShard(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pLevel.f_46443_ && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pSlotId >= 0 && pSlotId <= 8) {
                boolean isSneaking = player.m_6144_();
                AttributeInstance gravityAttribute = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                if (gravityAttribute != null) {
                    AttributeModifier existingModifier = gravityAttribute.m_22111_(GRAVITY_MODIFIER_UUID);
                    if (player.m_21205_().m_150930_((Item)ModItems.MOON.get()) || player.m_21206_().m_150930_((Item)ModItems.MOON.get())) {
                        if (existingModifier != null) {
                            gravityAttribute.m_22120_(GRAVITY_MODIFIER_UUID);
                        }
                        return;
                    }
                    if (MoonShard.isWearingGravityCore(player)) {
                        boolean gravityDisabled = gravityDisable.getOrDefault(player, false);
                        if (isSneaking && !player.m_20096_() && !gravityDisabled) {
                            gravityDisable.put(player, true);
                            if (existingModifier != null) {
                                gravityAttribute.m_22120_(GRAVITY_MODIFIER_UUID);
                            }
                        }
                        if (player.m_20096_()) {
                            gravityDisable.put(player, false);
                            if (existingModifier == null) {
                                gravityAttribute.m_22118_(new AttributeModifier(GRAVITY_MODIFIER_UUID, "MoonShard gravity reduction", Config.MoonShardGravityReduction, AttributeModifier.Operation.ADDITION));
                            }
                        }
                    } else if (!isSneaking) {
                        if (existingModifier == null) {
                            gravityAttribute.m_22118_(new AttributeModifier(GRAVITY_MODIFIER_UUID, "MoonShard gravity reduction", Config.MoonShardGravityReduction, AttributeModifier.Operation.ADDITION));
                        }
                    } else if (existingModifier != null) {
                        gravityAttribute.m_22120_(GRAVITY_MODIFIER_UUID);
                    }
                }
                Scheduler.schedule(() -> {
                    AttributeModifier modifier;
                    boolean found = false;
                    for (int i = 0; i <= 8; ++i) {
                        ItemStack invStack = player.m_150109_().m_8020_(i);
                        if (!invStack.m_150930_((Item)ModItems.MOON_SHARD.get())) continue;
                        found = true;
                        break;
                    }
                    AttributeInstance gravityAttributeLater = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                    if (!found && gravityAttributeLater != null && (modifier = gravityAttributeLater.m_22111_(GRAVITY_MODIFIER_UUID)) != null) {
                        gravityAttributeLater.m_22120_(GRAVITY_MODIFIER_UUID);
                    }
                }, 10);
            }
        }
    }

    private static boolean isWearingGravityCore(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(handler -> !handler.findCurios((Item)ModItems.GRAVITY_CORE.get()).isEmpty()).orElse(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.while_hotbar"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.moon_shard_1"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.moon_shard_2"));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.moon_shard_3"));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.holdShift"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

