/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class GravityCore
extends Item
implements ICurioItem {
    private static final UUID GRAVITY_BOOST_UUID = UUID.fromString("fa944f2a-d00f-48bb-a6c9-b2d0115ba628");
    private static AttributeModifier GRAVITY_MODIFIER;
    private static final WeakHashMap<Player, Boolean> gravityActive;
    private static final WeakHashMap<Player, Deque<Double>> lastYVelocities;

    public GravityCore(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
        return true;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        AttributeInstance gravityAttr;
        LivingEntity livingEntity;
        if (slotContext.entity().m_9236_().f_46443_ || !((livingEntity = slotContext.entity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (GRAVITY_MODIFIER == null) {
            GRAVITY_MODIFIER = new AttributeModifier(GRAVITY_BOOST_UUID, "Gravity boost", Config.GravityCoreGravityMultiplier - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        if ((gravityAttr = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get())) != null && gravityAttr.m_22109_(GRAVITY_MODIFIER)) {
            gravityAttr.m_22130_(GRAVITY_MODIFIER);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity().m_9236_().f_46443_ || !((livingEntity = slotContext.entity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        AttributeInstance gravityAttr = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        if (gravityAttr == null) {
            return;
        }
        if (GRAVITY_MODIFIER == null) {
            GRAVITY_MODIFIER = new AttributeModifier(GRAVITY_BOOST_UUID, "Gravity boost", Config.GravityCoreGravityMultiplier - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        boolean gravityEnabled = gravityActive.getOrDefault(player, false);
        if (player.m_6144_() && !player.m_20096_() && !gravityEnabled) {
            gravityActive.put(player, true);
            if (!gravityAttr.m_22109_(GRAVITY_MODIFIER)) {
                gravityAttr.m_22118_(GRAVITY_MODIFIER);
            }
        }
        Deque velocities = lastYVelocities.computeIfAbsent(player, p -> new ArrayDeque());
        if (gravityEnabled) {
            velocities.addLast(player.m_20184_().f_82480_);
            if (velocities.size() > 5) {
                velocities.removeFirst();
            }
        }
        if (player.m_20096_() && gravityEnabled) {
            gravityActive.put(player, false);
            if (gravityAttr.m_22109_(GRAVITY_MODIFIER)) {
                gravityAttr.m_22130_(GRAVITY_MODIFIER);
            }
            double minY = velocities.stream().min(Double::compareTo).orElse(0.0);
            velocities.clear();
            if (minY > -1.8) {
                return;
            }
            Level world = player.m_9236_();
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.5f, 1.0f / (player.m_217043_().m_188501_() * 0.4f + 0.8f));
            double totalDamage = player.m_21133_(Attributes.f_22281_) * Config.GravityCoreImpactDamageCoefficient * Math.abs(minY);
            float radius = (float)Math.abs(minY) * (float)Config.GravityCoreImpactRadiusCoefficient;
            AABB stompBox = new AABB(player.m_20185_() - (double)radius, player.m_20186_() - 1.1, player.m_20189_() - (double)radius, player.m_20185_() + (double)radius, player.m_20186_() + 1.1, player.m_20189_() + (double)radius);
            List victims = player.m_9236_().m_6443_(LivingEntity.class, stompBox, e -> e != player && e.m_6084_() && e.m_6087_());
            for (LivingEntity victim : victims) {
                if (!GravityCore.checkFriendlyFire(victim, (LivingEntity)player)) continue;
                victim.m_6469_(player.m_269291_().m_269075_(player), (float)totalDamage);
                victim.m_20256_(victim.m_20184_().m_82542_(0.0, 2.0, 0.0));
            }
            BlockState block = world.m_8055_(player.m_20183_().m_7495_());
            double particlesPerBlock = 20.0;
            double numberOfParticles = (double)radius * particlesPerBlock;
            int i = 0;
            while ((double)i < numberOfParticles) {
                float angle = (float)((double)i / numberOfParticles * 360.0);
                double d0 = player.m_20185_() + (double)(radius * Mth.m_14031_((float)angle));
                double d1 = player.m_20186_() + 0.15;
                double d2 = player.m_20189_() + (double)(radius * Mth.m_14089_((float)angle));
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                }
                ++i;
            }
        }
    }

    public static void jump(Player player) {
        if (player.m_36335_().m_41519_((Item)ModItems.GRAVITY_CORE.get())) {
            return;
        }
        double jumpMultiplier = Config.GravityCoreJumpStrength;
        double jumpBoostPower = player.m_21023_(MobEffects.f_19603_) ? (double)(0.1f * ((float)player.m_21124_(MobEffects.f_19603_).m_19564_() + 1.0f)) : 0.0;
        double jumpPower = (0.42 + jumpBoostPower) * jumpMultiplier;
        Vec3 vec3 = player.m_20184_();
        player.m_20334_(vec3.f_82479_, jumpPower, vec3.f_82481_);
        if (player.m_20142_()) {
            float f = player.m_146908_() * ((float)Math.PI / 180);
            player.m_20256_(player.m_20184_().m_82520_((double)(-Mth.m_14031_((float)f) * 0.2f) * jumpMultiplier, 0.0, (double)(Mth.m_14089_((float)f) * 0.2f) * jumpMultiplier));
        }
        player.f_19812_ = true;
        player.m_36220_(Stats.f_12926_);
        ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
        if (Config.GravityCoreCooldown != 0) {
            player.m_36335_().m_41524_((Item)ModItems.GRAVITY_CORE.get(), Config.GravityCoreCooldown);
        }
    }

    public static boolean checkFriendlyFire(LivingEntity target, LivingEntity attacker) {
        OwnableEntity tameable;
        Team attackerTeam = attacker.m_5647_();
        Team entityTeam = target.m_5647_();
        if (entityTeam != null && attackerTeam == entityTeam && !attackerTeam.m_6260_()) {
            return false;
        }
        if (target instanceof OwnableEntity && (tameable = (OwnableEntity)target).m_269323_() != null) {
            LivingEntity owner = tameable.m_269323_();
            if (owner == attacker) {
                return false;
            }
            Team ownerTeam = owner.m_5647_();
            if (ownerTeam != null && attackerTeam == ownerTeam && !attackerTeam.m_6260_()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isWearingGravityCore(LivingEntity livingEntity) {
        return CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(handler -> !handler.findCurios((Item)ModItems.GRAVITY_CORE.get()).isEmpty()).orElse(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            int gravityMultiplier = (int)Config.GravityCoreGravityMultiplier;
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.gravity_core_1"));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.gravity_core_2", (Object[])new Object[]{gravityMultiplier}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.gravity_core_3"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.gravity_core_4"));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.gravity_core_5"));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.holdShift"));
        }
    }

    static {
        gravityActive = new WeakHashMap();
        lastYVelocities = new WeakHashMap();
    }
}

