/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.attribute.ModAttributes;
import net.jrdemiurge.enigmaticdice.item.ModItems;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class GiantsRing
extends Item
implements ICurioItem {
    private static final AttributeModifier STEP_HEIGHT_BONUS = new AttributeModifier(UUID.fromString("979b021d-47b6-42dc-b68c-4c296aca0b01"), "enigmaticdice:giants_ring_step_height", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier SIZE_SCALE_MULTIPLIER = new AttributeModifier(UUID.fromString("b3d7b5e8-d381-45bf-8d9f-6291e7e5913d"), "enigmaticdice:giants_ring_size_scale", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final Map<LivingEntity, Integer> stompCooldowns = new WeakHashMap<LivingEntity, Integer>();

    public GiantsRing(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
        return true;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        AttributeInstance sizeScale;
        if (slotContext.entity().m_9236_().f_46443_ || !(slotContext.entity() instanceof Player)) {
            return;
        }
        AttributeInstance stepHeight = slotContext.entity().m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (stepHeight != null && stepHeight.m_22109_(STEP_HEIGHT_BONUS)) {
            stepHeight.m_22130_(STEP_HEIGHT_BONUS);
        }
        if ((sizeScale = slotContext.entity().m_21051_((Attribute)ModAttributes.SIZE_SCALE.get())) != null && sizeScale.m_22109_(SIZE_SCALE_MULTIPLIER)) {
            sizeScale.m_22130_(SIZE_SCALE_MULTIPLIER);
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        AttributeInstance sizeScale;
        if (slotContext.entity().m_9236_().f_46443_ || !(slotContext.entity() instanceof Player)) {
            return;
        }
        AttributeInstance stepHeight = slotContext.entity().m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (stepHeight != null && !stepHeight.m_22109_(STEP_HEIGHT_BONUS)) {
            stepHeight.m_22118_(STEP_HEIGHT_BONUS);
        }
        if ((sizeScale = slotContext.entity().m_21051_((Attribute)ModAttributes.SIZE_SCALE.get())) != null && !sizeScale.m_22109_(SIZE_SCALE_MULTIPLIER)) {
            sizeScale.m_22118_(SIZE_SCALE_MULTIPLIER);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity().m_9236_().f_46443_ || !(slotContext.entity() instanceof Player)) {
            return;
        }
        Player player = (Player)slotContext.entity();
        if (!player.m_20142_() || player.m_6069_()) {
            return;
        }
        int currentTick = player.f_19797_;
        double totalDamage = player.m_21133_(Attributes.f_22281_);
        ItemStack weapon = player.m_21205_();
        Multimap weaponModifiers = weapon.m_41638_(EquipmentSlot.MAINHAND);
        for (AttributeModifier mod : weaponModifiers.get((Object)Attributes.f_22281_)) {
            if (mod.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            totalDamage -= mod.m_22218_();
        }
        float radius = 1.0f;
        AABB playerBox = player.m_20191_();
        AABB stompBox = new AABB(playerBox.f_82288_ - (double)radius, player.m_20186_() - 0.1, playerBox.f_82290_ - (double)radius, playerBox.f_82291_ + (double)radius, player.m_20186_() + 0.4, playerBox.f_82293_ + (double)radius);
        List victims = player.m_9236_().m_6443_(LivingEntity.class, stompBox, e -> e != player && e.m_6084_() && e.m_6087_());
        for (LivingEntity victim : victims) {
            double victimVolume;
            double playerVolume;
            Integer nextAvailableTick = this.stompCooldowns.getOrDefault(victim, 0);
            if (currentTick < nextAvailableTick || !((playerVolume = player.m_20191_().m_82362_() * player.m_20191_().m_82376_() * player.m_20191_().m_82385_()) > (victimVolume = victim.m_20191_().m_82362_() * victim.m_20191_().m_82376_() * victim.m_20191_().m_82385_())) || !GiantsRing.checkFriendlyFire(victim, (LivingEntity)player)) continue;
            victim.m_6469_(player.m_269291_().m_269075_(player), (float)totalDamage);
            this.stompCooldowns.put(victim, currentTick + 20);
        }
    }

    public static boolean checkFriendlyFire(LivingEntity target, LivingEntity attacker) {
        OwnableEntity tameable;
        Team attackerTeam = attacker.m_5647_();
        Team entityTeam = target.m_5647_();
        if (entityTeam != null && attackerTeam == entityTeam && !attackerTeam.m_6260_()) {
            return false;
        }
        if (target instanceof OwnableEntity && (tameable = (OwnableEntity)target).m_269323_() != null) {
            LivingEntity owner = tameable.m_269323_();
            if (owner == attacker) {
                return false;
            }
            Team ownerTeam = owner.m_5647_();
            if (ownerTeam != null && attackerTeam == ownerTeam && !attackerTeam.m_6260_()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isWearingGiantRing(LivingEntity livingEntity) {
        return CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(handler -> !handler.findCurios((Item)ModItems.GIANTS_RING.get()).isEmpty()).orElse(false);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("44aeda56-97d8-40d8-9c57-3727f50bea16"), "enigmaticdice:giants_ring_health_bonus", Config.GiantsRingMaxHealth, AttributeModifier.Operation.ADDITION));
        attributes.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("be2c96bc-2f43-471e-8cff-150ac8750b57"), "enigmaticdice:giants_ring_speed_bonus", Config.GiantsRingSpeedBonus, AttributeModifier.Operation.MULTIPLY_BASE));
        attributes.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("cc5c05c0-916a-4165-bd3f-61a6b9ccfab0"), "enigmaticdice:giants_ring_damage_bonus", Config.GiantsRingAttackDamage, AttributeModifier.Operation.ADDITION));
        return attributes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.giants_ring_1"));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.giants_ring_2"));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.giants_ring_0"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.holdShift"));
        }
    }
}

