/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.effect.ModEffects;
import net.jrdemiurge.enigmaticdice.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class DivineShield
extends Item
implements ICurioItem {
    private static final Map<UUID, Long> activeImmunity = new HashMap<UUID, Long>();

    public DivineShield(Item.Properties pProperties) {
        super(pProperties);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity().m_9236_().f_46443_ || !((livingEntity = slotContext.entity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        player.m_21195_((MobEffect)ModEffects.DIVINE_SHIELD_INVULNERABILITY.get());
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity().m_9236_().f_46443_ || !((livingEntity = slotContext.entity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        player.m_21195_((MobEffect)ModEffects.DIVINE_SHIELD_INVULNERABILITY.get());
    }

    public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
        return true;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity().m_9236_().f_46443_ || !((livingEntity = slotContext.entity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (Config.DivineShieldGiveEffect) {
            if (DivineShield.isOnCooldown((LivingEntity)player)) {
                player.m_21195_((MobEffect)ModEffects.DIVINE_SHIELD_INVULNERABILITY.get());
            } else {
                player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.DIVINE_SHIELD_INVULNERABILITY.get(), -1, 0, true, true));
            }
        }
    }

    public static boolean isWearingDivineShield(LivingEntity livingEntity) {
        return CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(handler -> !handler.findCurios((Item)ModItems.DIVINE_SHIELD.get()).isEmpty()).orElse(false);
    }

    public static boolean isOnCooldown(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_36335_().m_41519_((Item)ModItems.DIVINE_SHIELD.get());
        }
        return false;
    }

    public static void triggerCooldown(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        player.m_36335_().m_41524_((Item)ModItems.DIVINE_SHIELD.get(), Config.DivineShieldCooldownTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            String formattedCooldown = String.format("%.1f", Float.valueOf((float)Config.DivineShieldCooldownTicks / 20.0f));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.divine_shield_1", (Object[])new Object[]{formattedCooldown}).m_130940_(ChatFormatting.GOLD));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.divine_shield_0"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.holdShift"));
        }
    }
}

