/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.effect.ModEffects;
import net.jrdemiurge.enigmaticdice.network.LookAtTargetPacket;
import net.jrdemiurge.enigmaticdice.network.NetworkHandler;
import net.jrdemiurge.enigmaticdice.scheduler.Scheduler;
import net.jrdemiurge.enigmaticdice.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class CrucibleOfRile
extends SwordItem {
    public static final String PDATA_RILE_HITS = "enigmaticdice_crucible_of_rile_hits";
    public static final String TAG_UNIQUE_KILLS = "enigmaticdice_crucible_of_rile_unique_kills";
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("5f4837ed-f638-4e29-8e26-bc26d2c41e2d");
    private static final UUID ARMOR_TOUGHNESS_MODIFIER_UUID = UUID.fromString("4430c313-c502-4db4-9b9a-ae50d3f446aa");
    private Multimap<Attribute, AttributeModifier> configModifiers;

    public CrucibleOfRile(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot != EquipmentSlot.MAINHAND) {
            return super.m_7167_(slot);
        }
        if (this.configModifiers == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", Config.CrucibleOfRileAttackDamage - 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", Config.CrucibleOfRileAttackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
            this.configModifiers = builder.build();
        }
        return this.configModifiers;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot != EquipmentSlot.MAINHAND) {
            return super.m_7167_(slot);
        }
        int kills = CrucibleOfRile.getUniqueKills(stack).size();
        if (kills == 0) {
            return super.getAttributeModifiers(slot, stack);
        }
        double armor = Config.CrucibleOfRilePermanentArmorPerUnique * (double)kills;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", Config.CrucibleOfRileAttackDamage - 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", Config.CrucibleOfRileAttackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_MODIFIER_UUID, "Weapon modifier", armor, AttributeModifier.Operation.MULTIPLY_TOTAL));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(ARMOR_TOUGHNESS_MODIFIER_UUID, "Weapon modifier", armor, AttributeModifier.Operation.MULTIPLY_TOTAL));
        return builder.build();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().f_46443_ && attacker instanceof Player) {
            Player player = (Player)attacker;
            player.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)ModSounds.CRUCIBLE_OF_RILE_ATTACK.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            if ((double)target.m_21223_() <= Config.CrucibleOfRileExecuteThreshold) {
                target.m_21153_(0.0f);
                if (target.m_21223_() <= 0.0f) {
                    target.getPersistentData().m_128379_("enigmaticdice_should_die", true);
                    target.m_6667_(attacker.m_269291_().m_269075_(player));
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack item = pPlayer.m_21120_(pUsedHand);
        if (pLevel.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)item);
        }
        CrucibleOfRile.aggroMobsAndLockPlayers((ServerLevel)pLevel, (ServerPlayer)pPlayer);
        CrucibleOfRile.giveArmorBoost(pPlayer);
        pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), (SoundEvent)ModSounds.CRUCIBLE_OF_RILE_USE.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
        pPlayer.m_36335_().m_41524_((Item)this, Config.CrucibleOfRileCooldown);
        return InteractionResultHolder.m_19090_((Object)item);
    }

    public static void aggroMobsAndLockPlayers(ServerLevel level, ServerPlayer caster) {
        double radius = Config.CrucibleOfRileAggroRadius;
        int durationTicks = Config.CrucibleOfRileAggroDuration;
        List mobs = level.m_6443_(Mob.class, caster.m_20191_().m_82400_(radius), m -> m.m_6084_() && CrucibleOfRile.checkFriendlyFire((LivingEntity)m, (LivingEntity)caster));
        for (Mob mob : mobs) {
            mob.m_6710_((LivingEntity)caster);
        }
        if (Config.CrucibleOfRileAggroPlayers) {
            List victims = level.m_6443_(ServerPlayer.class, caster.m_20191_().m_82400_(radius), sp -> sp != caster && sp.m_6084_() && CrucibleOfRile.checkFriendlyFire((LivingEntity)sp, (LivingEntity)caster));
            for (ServerPlayer sp2 : victims) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp2), (Object)new LookAtTargetPacket(caster.m_20148_(), durationTicks));
            }
        }
    }

    public static void giveArmorBoost(Player player) {
        AttributeInstance armor = player.m_21051_(Attributes.f_22284_);
        AttributeInstance toughness = player.m_21051_(Attributes.f_22285_);
        float effectValue = (float)Config.CrucibleOfRileArmorBuffValue;
        int buffDuration = Config.CrucibleOfRileArmorBuffDuration;
        if (armor == null || toughness == null) {
            return;
        }
        UUID ARMOR_BOOST_UUID = UUID.fromString("2fe31679-2a55-415d-9d49-9f1cc61e4731");
        UUID TOUGHNESS_BOOST_UUID = UUID.fromString("e6481205-0401-4508-ace8-0ce73d48d2a9");
        AttributeModifier armorBoost = new AttributeModifier(ARMOR_BOOST_UUID, "crucible_of_rile_use_armor_buff", (double)effectValue, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeModifier toughnessBoost = new AttributeModifier(TOUGHNESS_BOOST_UUID, "crucible_of_rile_use_armor_toughness_buff", (double)effectValue, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (!armor.m_22109_(armorBoost)) {
            armor.m_22118_(armorBoost);
        }
        if (!toughness.m_22109_(toughnessBoost)) {
            toughness.m_22118_(toughnessBoost);
        }
        Scheduler.schedule(() -> {
            AttributeInstance a = player.m_21051_(Attributes.f_22284_);
            AttributeInstance t = player.m_21051_(Attributes.f_22285_);
            if (a != null) {
                a.m_22120_(ARMOR_BOOST_UUID);
            }
            if (t != null) {
                t.m_22120_(TOUGHNESS_BOOST_UUID);
            }
        }, buffDuration);
        player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.CRUCIBLE_OF_RILE_ARMOR_BOOST.get(), buffDuration, 0));
    }

    public static boolean checkFriendlyFire(LivingEntity target, LivingEntity attacker) {
        OwnableEntity tameable;
        Team attackerTeam = attacker.m_5647_();
        Team entityTeam = target.m_5647_();
        if (entityTeam != null && attackerTeam == entityTeam && !attackerTeam.m_6260_()) {
            return false;
        }
        if (target instanceof OwnableEntity && (tameable = (OwnableEntity)target).m_269323_() != null) {
            LivingEntity owner = tameable.m_269323_();
            if (owner == attacker) {
                return false;
            }
            Team ownerTeam = owner.m_5647_();
            if (ownerTeam != null && attackerTeam == ownerTeam && !attackerTeam.m_6260_()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isHeldMainHand(LivingEntity livingEntity) {
        return livingEntity.m_21205_().m_41720_() instanceof CrucibleOfRile;
    }

    public static void handleOnOwnerAttacked(LivingEntity livingEntity) {
        CompoundTag data = livingEntity.getPersistentData();
        int hits = data.m_128451_(PDATA_RILE_HITS) + 1;
        if (hits >= Config.CrucibleOfRileHitsForCounterattack) {
            data.m_128405_(PDATA_RILE_HITS, 0);
            CrucibleOfRile.doAoEDamage(livingEntity);
        } else {
            data.m_128405_(PDATA_RILE_HITS, hits);
        }
    }

    private static void doAoEDamage(LivingEntity livingEntity) {
        DamageSource src;
        livingEntity.m_9236_().m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), (SoundEvent)ModSounds.CRUCIBLE_OF_RILE_HELIX.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
        AABB box = livingEntity.m_20191_().m_82400_(Config.CrucibleOfRileCounterattackRadius);
        List targets = livingEntity.m_9236_().m_6443_(LivingEntity.class, box, e -> e.m_6084_() && e != livingEntity && CrucibleOfRile.checkFriendlyFire(e, livingEntity));
        float dmg = (float)livingEntity.m_21133_(Attributes.f_22281_);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            src = livingEntity.m_269291_().m_269075_(player);
        } else {
            src = livingEntity.m_269291_().m_269333_(livingEntity);
        }
        for (LivingEntity t : targets) {
            t.m_6469_(src, dmg);
        }
    }

    public static Set<String> getUniqueKills(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        HashSet<String> set = new HashSet<String>();
        if (tag.m_128425_(TAG_UNIQUE_KILLS, 9)) {
            ListTag list = tag.m_128437_(TAG_UNIQUE_KILLS, 8);
            for (Tag t : list) {
                set.add(t.m_7916_());
            }
        }
        return set;
    }

    public static void setUniqueKills(ItemStack stack, Set<String> ids) {
        ListTag list = new ListTag();
        for (String s : ids) {
            list.add((Object)StringTag.m_129297_((String)s));
        }
        stack.m_41784_().m_128365_(TAG_UNIQUE_KILLS, (Tag)list);
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            double crucibleOfRileExecuteThreshold = Config.CrucibleOfRileExecuteThreshold;
            double crucibleOfRileAggroRadius = Config.CrucibleOfRileAggroRadius;
            double crucibleOfRileArmorBuffValue = Config.CrucibleOfRileArmorBuffValue * 100.0;
            int crucibleOfRileArmorBuffDuration = Config.CrucibleOfRileArmorBuffDuration / 20;
            int crucibleOfRileHitsForCounterattack = Config.CrucibleOfRileHitsForCounterattack;
            double crucibleOfRileCounterattackRadius = Config.CrucibleOfRileCounterattackRadius;
            double crucibleOfRilePermanentArmorPerUnique = Config.CrucibleOfRilePermanentArmorPerUnique * 100.0;
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.on_use"));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.crucible_of_rile_1", (Object[])new Object[]{crucibleOfRileAggroRadius}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.crucible_of_rile_2", (Object[])new Object[]{crucibleOfRileArmorBuffValue, crucibleOfRileArmorBuffDuration}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.crucible_of_rile_3", (Object[])new Object[]{crucibleOfRileHitsForCounterattack}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.crucible_of_rile_4", (Object[])new Object[]{crucibleOfRileCounterattackRadius}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.on_hit"));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.crucible_of_rile_5", (Object[])new Object[]{crucibleOfRileExecuteThreshold}).m_130940_(ChatFormatting.GOLD));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.crucible_of_rile_6"));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.enigmaticdice.crucible_of_rile_7", (Object[])new Object[]{crucibleOfRilePermanentArmorPerUnique}).m_130940_(ChatFormatting.GOLD));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.enigmaticdice.holdShift"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

