/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.event;

import java.util.UUID;
import net.jrdemiurge.enigmaticdice.item.custom.UnequalExchange;
import net.jrdemiurge.enigmaticdice.item.custom.souleater.SoulEaterData;
import net.jrdemiurge.enigmaticdice.item.custom.souleater.SoulEaterDataStorage;
import net.jrdemiurge.enigmaticdice.item.custom.unequalexchange.UnequalExchangeData;
import net.jrdemiurge.enigmaticdice.item.custom.unequalexchange.UnequalExchangeDataStorage;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enigmaticdice")
public class PlayerTickHandler {
    private static final UUID HEALTH_DEBUFF_UUID = UUID.fromString("5f1d9b20-dfd6-4284-9d3a-004776a87bfd");
    private static final UUID ATTACK_SPEED_DEBUFF_UUID = UUID.fromString("27a72973-be25-44f0-9613-187812e4627c");
    private static final UUID ARMOR_DEBUFF_UUID = UUID.fromString("44371e08-d7ae-4344-8cfa-95c9fd4825c2");
    private static final UUID ARMOR_TOUGHNESS_DEBUFF_UUID = UUID.fromString("a6fb771d-97de-4883-86a8-1ba2b8db59c2");
    private static final UUID SPEED_DEBUFF_UUID = UUID.fromString("68403af9-c76e-4b08-8196-f264d872876d");
    private static final UUID SOUL_EATER_HEALTH_BUFF_UUID = UUID.fromString("1c378b22-ac27-406d-a123-9fa54753f35b");

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!player.m_9236_().f_46443_) {
            UnequalExchangeData data = UnequalExchangeDataStorage.get(player);
            data.tick();
            if (data.isExpired()) {
                if (player.m_21051_(Attributes.f_22276_).m_22111_(HEALTH_DEBUFF_UUID) != null) {
                    player.m_21051_(Attributes.f_22276_).m_22120_(HEALTH_DEBUFF_UUID);
                }
                if (player.m_21051_(Attributes.f_22283_).m_22111_(ATTACK_SPEED_DEBUFF_UUID) != null) {
                    player.m_21051_(Attributes.f_22283_).m_22120_(ATTACK_SPEED_DEBUFF_UUID);
                }
                if (player.m_21051_(Attributes.f_22284_).m_22111_(ARMOR_DEBUFF_UUID) != null) {
                    player.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_DEBUFF_UUID);
                }
                if (player.m_21051_(Attributes.f_22285_).m_22111_(ARMOR_TOUGHNESS_DEBUFF_UUID) != null) {
                    player.m_21051_(Attributes.f_22285_).m_22120_(ARMOR_TOUGHNESS_DEBUFF_UUID);
                }
                if (player.m_21051_(Attributes.f_22279_).m_22111_(SPEED_DEBUFF_UUID) != null) {
                    player.m_21051_(Attributes.f_22279_).m_22120_(SPEED_DEBUFF_UUID);
                }
                data.reset();
            }
            if (data.getHitCount() > 0 && player.m_21051_(Attributes.f_22276_).m_22111_(HEALTH_DEBUFF_UUID) == null) {
                UnequalExchange.updateModifiers(player, data);
            }
            SoulEaterData soulEaterData = SoulEaterDataStorage.get(player);
            soulEaterData.tick();
            if (soulEaterData.isExpired()) {
                if (player.m_21051_(Attributes.f_22276_).m_22111_(SOUL_EATER_HEALTH_BUFF_UUID) != null) {
                    player.m_21051_(Attributes.f_22276_).m_22120_(SOUL_EATER_HEALTH_BUFF_UUID);
                    if (player.m_21223_() > player.m_21233_()) {
                        player.m_21153_(player.m_21233_());
                    }
                }
                soulEaterData.reset();
            }
        }
    }
}

