/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.event;

import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.item.ModItems;
import net.jrdemiurge.enigmaticdice.stat.ModStats;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enigmaticdice")
public class MobDropHandler {
    @SubscribeEvent
    public static void onMobDeath(LivingDropsEvent event) {
        DamageSource source = event.getSource();
        LivingEntity killed = event.getEntity();
        if (!(killed instanceof Monster)) {
            return;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!(source.m_7639_() instanceof FakePlayer) && (double)player.m_9236_().f_46441_.m_188501_() < Config.EnigmaticDieMobDropChance && MobDropHandler.canObtainDice(player, ModStats.OBTAINED_DICE_FROM_MOB)) {
                ItemStack drop = new ItemStack((ItemLike)ModItems.ENIGAMTIC_DIE.get());
                event.getDrops().add(new ItemEntity(player.m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), drop));
                player.m_36220_(ModStats.OBTAINED_DICE_FROM_MOB);
                player.m_5661_((Component)Component.m_237115_((String)("enigmaticdice.mob_drop." + player.m_9236_().f_46441_.m_188503_(4))), false);
            }
        }
    }

    public static boolean canObtainDice(Player player, ResourceLocation statKey) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (Config.MobDiceTimeInterval == 0) {
                return true;
            }
            int playTimeTicks = serverPlayer.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_144256_));
            int playTimeMinutes = playTimeTicks / 1200;
            int allowedCount = playTimeMinutes / Config.MobDiceTimeInterval;
            int currentCount = serverPlayer.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)statKey));
            return currentCount < allowedCount;
        }
        return false;
    }
}

