/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.event;

import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.item.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enigmaticdice")
public class LootEventHandler {
    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation lootTable = event.getName();
        for (ResourceLocation targetChest : Config.lootTables) {
            if (!lootTable.equals((Object)targetChest)) continue;
            LootEventHandler.addEnigmaticDieToLoot(event);
        }
    }

    private static void addEnigmaticDieToLoot(LootTableLoadEvent event) {
        double chance = Config.EnigmaticDieChestChance;
        int totalWeight = 100;
        int enigmaticDieWeight = (int)(chance * (double)totalWeight);
        int emptyWeight = totalWeight - enigmaticDieWeight;
        if (enigmaticDieWeight <= 0) {
            enigmaticDieWeight = 1;
        }
        if (emptyWeight <= 0) {
            emptyWeight = 1;
        }
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ENIGAMTIC_DIE.get())).m_79707_(enigmaticDieWeight);
        LootPoolSingletonContainer.Builder emptyEntry = LootItem.m_79579_((ItemLike)Items.f_41852_).m_79707_(emptyWeight);
        LootPool pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_79076_((LootPoolEntryContainer.Builder)emptyEntry).m_79082_();
        event.getTable().addPool(pool);
    }
}

