/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.event;

import java.util.WeakHashMap;
import net.jrdemiurge.enigmaticdice.item.custom.GravityCore;
import net.jrdemiurge.enigmaticdice.network.DoubleJumpPacket;
import net.jrdemiurge.enigmaticdice.network.NetworkHandler;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enigmaticdice", value={Dist.CLIENT})
public class GravityCorePlayerTickHandler {
    private static final int DOUBLE_JUMP_THRESHOLD_TICKS = 6;
    private static final WeakHashMap<Player, Long> lastJumpPressTick = new WeakHashMap();
    private static final WeakHashMap<Player, Boolean> wasJumping = new WeakHashMap();
    private static final WeakHashMap<Player, Boolean> lastTickIsJumping = new WeakHashMap();

    @SubscribeEvent
    public static void onClientTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase != TickEvent.Phase.END || !((player = event.player) instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player2 = (LocalPlayer)player;
        if (!GravityCore.isWearingGravityCore((LivingEntity)player2)) {
            return;
        }
        if (player2.m_7500_() || player2.m_5833_()) {
            return;
        }
        if (player2.m_20096_()) {
            wasJumping.put((Player)player2, false);
        }
        if (!player2.f_108618_.f_108572_) {
            lastTickIsJumping.put((Player)player2, false);
            return;
        }
        if (player2.f_108618_.f_108572_ && !lastTickIsJumping.getOrDefault(player2, false).booleanValue() && !wasJumping.getOrDefault(player2, false).booleanValue()) {
            long lastTick = lastJumpPressTick.getOrDefault(player2, -100L);
            long currentTick = player2.m_9236_().m_46467_();
            lastJumpPressTick.put((Player)player2, currentTick);
            lastTickIsJumping.put((Player)player2, true);
            if (currentTick - lastTick < 6L) {
                NetworkHandler.INSTANCE.sendToServer((Object)new DoubleJumpPacket());
                wasJumping.put((Player)player2, true);
                lastJumpPressTick.put((Player)player2, -100L);
            }
        }
    }
}

