/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.event;

import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.item.ModItems;
import net.jrdemiurge.enigmaticdice.stat.ModStats;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enigmaticdice")
public class BlockBreakHandler {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        Level level = (Level)event.getLevel();
        if (!level.f_46443_ && player != null && !(player instanceof FakePlayer) && (double)level.f_46441_.m_188501_() < Config.EnigmaticDieBlockDropChance && BlockBreakHandler.canObtainDice(player, ModStats.OBTAINED_DICE_FROM_BLOCK)) {
            ItemStack drop = new ItemStack((ItemLike)ModItems.ENIGAMTIC_DIE.get());
            ItemEntity entity = new ItemEntity(level, (double)event.getPos().m_123341_() + 0.5, (double)event.getPos().m_123342_() + 0.5, (double)event.getPos().m_123343_() + 0.5, drop);
            level.m_7967_((Entity)entity);
            player.m_36220_(ModStats.OBTAINED_DICE_FROM_BLOCK);
            player.m_5661_((Component)Component.m_237115_((String)"enigmaticdice.block_break"), false);
        }
    }

    public static boolean canObtainDice(Player player, ResourceLocation statKey) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (Config.BlockDiceTimeInterval == 0) {
                return true;
            }
            int playTimeTicks = serverPlayer.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_144256_));
            int playTimeMinutes = playTimeTicks / 1200;
            int allowedCount = playTimeMinutes / Config.BlockDiceTimeInterval;
            int currentCount = serverPlayer.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)statKey));
            return currentCount < allowedCount;
        }
        return false;
    }
}

