/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import net.jrdemiurge.enigmaticdice.Config;
import net.jrdemiurge.enigmaticdice.EnigmaticDice;
import net.jrdemiurge.enigmaticdice.config.ItemEventConfig;
import net.jrdemiurge.enigmaticdice.config.ModConfig;
import net.jrdemiurge.enigmaticdice.config.UniqueEventConfig;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;

public class EnigmaticDiceConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static ModConfig configData;

    public static void loadConfig() {
        Path path = EnigmaticDiceConfig.getConfigPath();
        if (Files.exists(path, new LinkOption[0])) {
            EnigmaticDiceConfig.loadFromFile(path);
        } else {
            EnigmaticDiceConfig.copyDefaultConfigTo(path);
            EnigmaticDiceConfig.loadFromFile(path);
        }
        if (configData == null) {
            EnigmaticDice.LOGGER.error("EnigmaticDiceConfig.configData is null! Config not loaded properly.");
            configData = new ModConfig();
            EnigmaticDiceConfig.configData.uniqueEvents = new HashMap<String, UniqueEventConfig>();
            EnigmaticDiceConfig.configData.itemEvents = new HashMap<String, ItemEventConfig>();
            EnigmaticDiceConfig.configData.teleportBiomes = new ArrayList<String>();
            EnigmaticDiceConfig.configData.teleportStructures = new ArrayList<String>();
            EnigmaticDiceConfig.configData.negativeEvents = new ArrayList<String>();
        }
    }

    private static Path getConfigPath() {
        boolean versioned = Config.UseVersionedJson;
        Path dir = FMLPaths.CONFIGDIR.get();
        if (versioned) {
            String ver = EnigmaticDiceConfig.getModVersionSafe();
            return dir.resolve("enigmatic_dice_" + ver + ".json");
        }
        return dir.resolve("enigmatic_dice.json");
    }

    private static String getModVersionSafe() {
        return ModList.get().getModContainerById("enigmaticdice").map(c -> c.getModInfo().getVersion().toString()).orElse("unknown");
    }

    private static void loadFromFile(Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            configData = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
        }
        catch (IOException e) {
            EnigmaticDice.LOGGER.error("Failed to read JSON config {}", (Object)path, (Object)e);
        }
    }

    private static void copyDefaultConfigTo(Path target) {
        try (InputStream in = EnigmaticDiceConfig.class.getResourceAsStream("/assets/enigmaticdice/config/enigmatic_dice.json");){
            if (in == null) {
                EnigmaticDice.LOGGER.error("Default JSON config not found in mod resources!");
                return;
            }
            Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            EnigmaticDice.LOGGER.error("Failed to copy default JSON to {}", (Object)target, (Object)e);
        }
    }
}

