/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.jrdemiurge.enigmaticdice.EnigmaticDice;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEvent;
import net.jrdemiurge.enigmaticdice.item.custom.enigmaticdie.RandomEventManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class EnigmaticDiceCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"enigmaticDice").requires(source -> source.m_6761_(2))).executes(EnigmaticDiceCommand::triggerRandomEvent)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"eventType", (ArgumentType)StringArgumentType.string()).suggests(EnigmaticDiceCommand::suggestEventTypes).then(Commands.m_82129_((String)"forceExecution", (ArgumentType)BoolArgumentType.bool()).executes(EnigmaticDiceCommand::triggerSpecificEventWithForce))).executes(EnigmaticDiceCommand::triggerSpecificEvent));
    }

    private static CompletableFuture<Suggestions> suggestEventTypes(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        if (EnigmaticDice.eventManager == null) {
            EnigmaticDice.eventManager = new RandomEventManager();
        }
        for (String eventName : EnigmaticDice.eventManager.getEventNames()) {
            builder.suggest(eventName);
        }
        return builder.buildFuture();
    }

    private static int triggerSpecificEvent(CommandContext<CommandSourceStack> context) {
        return EnigmaticDiceCommand.executeEvent(context, false);
    }

    private static int triggerSpecificEventWithForce(CommandContext<CommandSourceStack> context) {
        boolean forceExecution = BoolArgumentType.getBool(context, (String)"forceExecution");
        return EnigmaticDiceCommand.executeEvent(context, forceExecution);
    }

    private static int executeEvent(CommandContext<CommandSourceStack> context, boolean forceExecution) {
        if (EnigmaticDice.eventManager == null) {
            EnigmaticDice.eventManager = new RandomEventManager();
        }
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel pLevel = source.m_81372_();
        ServerPlayer pPlayer = source.m_230896_();
        String eventType = StringArgumentType.getString(context, (String)"eventType");
        RandomEvent event = EnigmaticDice.eventManager.getEventByName(eventType);
        if (event != null) {
            event.execute((Level)pLevel, (Player)pPlayer, forceExecution);
            return 1;
        }
        return 0;
    }

    private static int triggerRandomEvent(CommandContext<CommandSourceStack> context) {
        if (EnigmaticDice.eventManager == null) {
            EnigmaticDice.eventManager = new RandomEventManager();
        }
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel pLevel = source.m_81372_();
        ServerPlayer pPlayer = source.m_230896_();
        EnigmaticDice.eventManager.triggerRandomEvent((Level)pLevel, (Player)pPlayer);
        return 1;
    }
}

