/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="enigmaticdice", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final List<String> defaultLootTables = new ArrayList<String>();
    private static final ForgeConfigSpec.ConfigValue<Boolean> USE_VERSIONED_JSON;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> LOOT_TABLES;
    private static final ForgeConfigSpec.ConfigValue<Double> ENIGMATIC_DIE_MOB_DROP_CHANCE;
    private static final ForgeConfigSpec.ConfigValue<Integer> MOB_DICE_TIME_INTERVAL;
    private static final ForgeConfigSpec.ConfigValue<Double> ENIGMATIC_DIE_BLOCK_DROP_CHANCE;
    private static final ForgeConfigSpec.ConfigValue<Integer> BLOCK_DICE_TIME_INTERVAL;
    private static final ForgeConfigSpec.ConfigValue<Double> ENIGMATIC_DIE_CHEST_CHANCE;
    private static final ForgeConfigSpec.ConfigValue<Integer> STRUCTURE_SEARCH_RADIUS;
    private static final ForgeConfigSpec.ConfigValue<Integer> BIOME_SEARCH_RADIUS;
    private static final ForgeConfigSpec.ConfigValue<Integer> BIOME_HORIZONTAL_STEP;
    private static final ForgeConfigSpec.ConfigValue<Integer> BIOME_VERTICAL_STEP;
    private static final ForgeConfigSpec.ConfigValue<Double> UNEQUAL_EXCHANGE_TARGET_HEALTH_REDUCTION;
    private static final ForgeConfigSpec.ConfigValue<Double> UNEQUAL_EXCHANGE_PLAYER_HEALTH_REDUCTION;
    private static final ForgeConfigSpec.ConfigValue<Double> UNEQUAL_EXCHANGE_STAT_DEBUFF;
    private static final ForgeConfigSpec.ConfigValue<Integer> UNEQUAL_EXCHANGE_DEBUFF_DURATION;
    private static final ForgeConfigSpec.ConfigValue<Double> UNEQUAL_EXCHANGE_ATTACK_DAMAGE;
    private static final ForgeConfigSpec.ConfigValue<Double> UNEQUAL_EXCHANGE_ATTACK_SPEED;
    private static final ForgeConfigSpec.ConfigValue<Double> SOUL_EATER_CHARGED_ATTACK_DAMAGE_PER_HP;
    private static final ForgeConfigSpec.ConfigValue<Integer> SOUL_EATER_CHARGE_DURATION;
    private static final ForgeConfigSpec.ConfigValue<Double> SOUL_EATER_HEAL_PERCENT_ON_KILL;
    private static final ForgeConfigSpec.ConfigValue<Double> SOUL_EATER_MAX_HEALTH_STEAL_PERCENT;
    private static final ForgeConfigSpec.ConfigValue<Integer> SOUL_EATER_MAX_HEALTH_BUFF_DURATION;
    private static final ForgeConfigSpec.ConfigValue<Double> SOUL_EATER_MAX_HEALTH_MULTIPLIER_LIMIT;
    private static final ForgeConfigSpec.ConfigValue<Double> SOUL_EATER_ATTACK_DAMAGE;
    private static final ForgeConfigSpec.ConfigValue<Double> SOUL_EATER_ATTACK_SPEED;
    private static final ForgeConfigSpec.ConfigValue<Double> GIANTS_RING_ATTACK_DAMAGE;
    private static final ForgeConfigSpec.ConfigValue<Double> GIANTS_RING_MAX_HEALTH;
    private static final ForgeConfigSpec.ConfigValue<Double> GIANTS_RING_SPEED_BONUS;
    private static final ForgeConfigSpec.ConfigValue<Double> MOON_SHARD_GRAVITY_REDUCTION;
    private static final ForgeConfigSpec.ConfigValue<Double> MOON_GRAVITY_REDUCTION;
    private static final ForgeConfigSpec.ConfigValue<Double> GRAVITY_CORE_GRAVITY_MULTIPLIER;
    private static final ForgeConfigSpec.ConfigValue<Double> GRAVITY_CORE_IMPACT_RADIUS_COEFFICIENT;
    private static final ForgeConfigSpec.ConfigValue<Double> GRAVITY_CORE_IMPACT_DAMAGE_COEFFICIENT;
    private static final ForgeConfigSpec.ConfigValue<Double> GRAVITY_CORE_JUMP_STRENGTH;
    private static final ForgeConfigSpec.IntValue GRAVITY_CORE_COOLDOWN;
    private static final ForgeConfigSpec.ConfigValue<Double> RING_OF_AGILITY_CHANCE_SCALE;
    private static final ForgeConfigSpec.ConfigValue<Double> RING_OF_AGILITY_MAX_DODGE_CHANCE;
    private static final ForgeConfigSpec.ConfigValue<Integer> DIVINE_SHIELD_COOLDOWN_TICKS;
    private static final ForgeConfigSpec.BooleanValue DIVINE_SHIELD_GIVE_EFFECT;
    private static final ForgeConfigSpec.ConfigValue<Double> PERMAFROST_ATTACK_DAMAGE;
    private static final ForgeConfigSpec.ConfigValue<Double> PERMAFROST_ATTACK_SPEED;
    private static final ForgeConfigSpec.ConfigValue<Integer> PERMAFROST_ATTACK_DEBUFF_DURATION;
    private static final ForgeConfigSpec.ConfigValue<Integer> PERMAFROST_ATTACK_MAX_STACKS;
    private static final ForgeConfigSpec.ConfigValue<Double> PERMAFROST_ATTACK_REDUCTION_PER_STACK;
    private static final ForgeConfigSpec.ConfigValue<Integer> PERMAFROST_AURA_RADIUS;
    private static final ForgeConfigSpec.ConfigValue<Integer> PERMAFROST_AURA_DEBUFF_DURATION;
    private static final ForgeConfigSpec.ConfigValue<Double> PERMAFROST_AURA_REDUCTION_FACTOR;
    private static final ForgeConfigSpec.ConfigValue<Double> CRUCIBLE_OF_RILE_ATTACK_DAMAGE;
    private static final ForgeConfigSpec.ConfigValue<Double> CRUCIBLE_OF_RILE_ATTACK_SPEED;
    private static final ForgeConfigSpec.ConfigValue<Double> CRUCIBLE_OF_RILE_EXECUTE_THRESHOLD;
    private static final ForgeConfigSpec.ConfigValue<Integer> CRUCIBLE_OF_RILE_COOLDOWN;
    private static final ForgeConfigSpec.ConfigValue<Double> CRUCIBLE_OF_RILE_AGGRO_RADIUS;
    private static final ForgeConfigSpec.BooleanValue CRUCIBLE_OF_RILE_AGGRO_PLAYERS;
    private static final ForgeConfigSpec.ConfigValue<Integer> CRUCIBLE_OF_RILE_AGGRO_DURATION;
    private static final ForgeConfigSpec.ConfigValue<Double> CRUCIBLE_OF_RILE_ARMOR_BUFF_VALUE;
    private static final ForgeConfigSpec.ConfigValue<Integer> CRUCIBLE_OF_RILE_ARMOR_BUFF_DURATION;
    private static final ForgeConfigSpec.ConfigValue<Integer> CRUCIBLE_OF_RILE_HITS_FOR_COUNTERATTACK;
    private static final ForgeConfigSpec.ConfigValue<Double> CRUCIBLE_OF_RILE_COUNTERATTACK_RADIUS;
    private static final ForgeConfigSpec.ConfigValue<Double> CRUCIBLE_OF_RILE_PERM_ARMOR_PER_UNIQUE;
    private static final ForgeConfigSpec.ConfigValue<Double> MOAI_CHARM_KNOCKBACK_RESISTANCE;
    static final ForgeConfigSpec SPEC;
    public static boolean UseVersionedJson;
    public static double EnigmaticDieMobDropChance;
    public static double EnigmaticDieBlockDropChance;
    public static double EnigmaticDieChestChance;
    public static int BlockDiceTimeInterval;
    public static int MobDiceTimeInterval;
    public static int StructureSearchRadius;
    public static int BiomeSearchRadius;
    public static int BiomeHorizontalStep;
    public static int BiomeVerticalStep;
    public static double UnequalExchangeTargetHealthReduction;
    public static double UnequalExchangePlayerHealthReduction;
    public static double UnequalExchangeStatDebuff;
    public static int UnequalExchangeDebuffDuration;
    public static double UnequalExchangeAttackDamage;
    public static double UnequalExchangeAttackSpeed;
    public static double SoulEaterChargedAttackDamagePerHP;
    public static int SoulEaterChargeDuration;
    public static double SoulEaterHealPercentOnKill;
    public static double SoulEaterMaxHealthStealPercent;
    public static int SoulEaterMaxHealthBuffDuration;
    public static double SoulEaterMaxHealthMultiplierLimit;
    public static double SoulEaterAttackDamage;
    public static double SoulEaterAttackSpeed;
    public static double GiantsRingAttackDamage;
    public static double GiantsRingMaxHealth;
    public static double GiantsRingSpeedBonus;
    public static double MoonShardGravityReduction;
    public static double MoonGravityReduction;
    public static double GravityCoreGravityMultiplier;
    public static double GravityCoreImpactRadiusCoefficient;
    public static double GravityCoreImpactDamageCoefficient;
    public static double GravityCoreJumpStrength;
    public static int GravityCoreCooldown;
    public static double RingOfAgilityChanceScale;
    public static double RingOfAgilityMaxDodgeChance;
    public static int DivineShieldCooldownTicks;
    public static boolean DivineShieldGiveEffect;
    public static double PermafrostAttackDamage;
    public static double PermafrostAttackSpeed;
    public static int PermafrostAttackDebuffDuration;
    public static int PermafrostAttackMaxStacks;
    public static double PermafrostAttackReductionPerStack;
    public static int PermafrostAuraRadius;
    public static int PermafrostAuraDebuffDuration;
    public static double PermafrostAuraReductionFactor;
    public static double CrucibleOfRileAttackDamage;
    public static double CrucibleOfRileAttackSpeed;
    public static double CrucibleOfRileExecuteThreshold;
    public static int CrucibleOfRileCooldown;
    public static double CrucibleOfRileAggroRadius;
    public static boolean CrucibleOfRileAggroPlayers;
    public static int CrucibleOfRileAggroDuration;
    public static double CrucibleOfRileArmorBuffValue;
    public static int CrucibleOfRileArmorBuffDuration;
    public static int CrucibleOfRileHitsForCounterattack;
    public static double CrucibleOfRileCounterattackRadius;
    public static double CrucibleOfRilePermanentArmorPerUnique;
    public static double MoaiCharmKnockbackResistanceBonus;
    public static List<ResourceLocation> lootTables;

    private static boolean validateLootTable(Object obj) {
        String lootTable;
        return obj instanceof String && ResourceLocation.m_135830_((String)(lootTable = (String)obj));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        UseVersionedJson = (Boolean)USE_VERSIONED_JSON.get();
        EnigmaticDieMobDropChance = (Double)ENIGMATIC_DIE_MOB_DROP_CHANCE.get();
        EnigmaticDieBlockDropChance = (Double)ENIGMATIC_DIE_BLOCK_DROP_CHANCE.get();
        EnigmaticDieChestChance = (Double)ENIGMATIC_DIE_CHEST_CHANCE.get();
        BlockDiceTimeInterval = (Integer)BLOCK_DICE_TIME_INTERVAL.get();
        MobDiceTimeInterval = (Integer)MOB_DICE_TIME_INTERVAL.get();
        StructureSearchRadius = (Integer)STRUCTURE_SEARCH_RADIUS.get();
        BiomeSearchRadius = (Integer)BIOME_SEARCH_RADIUS.get();
        BiomeHorizontalStep = (Integer)BIOME_HORIZONTAL_STEP.get();
        BiomeVerticalStep = (Integer)BIOME_VERTICAL_STEP.get();
        UnequalExchangeTargetHealthReduction = (Double)UNEQUAL_EXCHANGE_TARGET_HEALTH_REDUCTION.get();
        UnequalExchangePlayerHealthReduction = (Double)UNEQUAL_EXCHANGE_PLAYER_HEALTH_REDUCTION.get();
        UnequalExchangeStatDebuff = (Double)UNEQUAL_EXCHANGE_STAT_DEBUFF.get();
        UnequalExchangeDebuffDuration = (Integer)UNEQUAL_EXCHANGE_DEBUFF_DURATION.get();
        UnequalExchangeAttackDamage = (Double)UNEQUAL_EXCHANGE_ATTACK_DAMAGE.get();
        UnequalExchangeAttackSpeed = (Double)UNEQUAL_EXCHANGE_ATTACK_SPEED.get();
        SoulEaterChargedAttackDamagePerHP = (Double)SOUL_EATER_CHARGED_ATTACK_DAMAGE_PER_HP.get();
        SoulEaterChargeDuration = (Integer)SOUL_EATER_CHARGE_DURATION.get();
        SoulEaterHealPercentOnKill = (Double)SOUL_EATER_HEAL_PERCENT_ON_KILL.get();
        SoulEaterMaxHealthStealPercent = (Double)SOUL_EATER_MAX_HEALTH_STEAL_PERCENT.get();
        SoulEaterMaxHealthBuffDuration = (Integer)SOUL_EATER_MAX_HEALTH_BUFF_DURATION.get();
        SoulEaterMaxHealthMultiplierLimit = (Double)SOUL_EATER_MAX_HEALTH_MULTIPLIER_LIMIT.get();
        SoulEaterAttackDamage = (Double)SOUL_EATER_ATTACK_DAMAGE.get();
        SoulEaterAttackSpeed = (Double)SOUL_EATER_ATTACK_SPEED.get();
        GiantsRingAttackDamage = (Double)GIANTS_RING_ATTACK_DAMAGE.get();
        GiantsRingMaxHealth = (Double)GIANTS_RING_MAX_HEALTH.get();
        GiantsRingSpeedBonus = (Double)GIANTS_RING_SPEED_BONUS.get();
        MoonShardGravityReduction = (Double)MOON_SHARD_GRAVITY_REDUCTION.get();
        MoonGravityReduction = (Double)MOON_GRAVITY_REDUCTION.get();
        GravityCoreGravityMultiplier = (Double)GRAVITY_CORE_GRAVITY_MULTIPLIER.get();
        GravityCoreImpactRadiusCoefficient = (Double)GRAVITY_CORE_IMPACT_RADIUS_COEFFICIENT.get();
        GravityCoreImpactDamageCoefficient = (Double)GRAVITY_CORE_IMPACT_DAMAGE_COEFFICIENT.get();
        GravityCoreJumpStrength = (Double)GRAVITY_CORE_JUMP_STRENGTH.get();
        GravityCoreCooldown = (Integer)GRAVITY_CORE_COOLDOWN.get();
        RingOfAgilityChanceScale = (Double)RING_OF_AGILITY_CHANCE_SCALE.get();
        RingOfAgilityMaxDodgeChance = (Double)RING_OF_AGILITY_MAX_DODGE_CHANCE.get();
        DivineShieldCooldownTicks = (Integer)DIVINE_SHIELD_COOLDOWN_TICKS.get();
        DivineShieldGiveEffect = (Boolean)DIVINE_SHIELD_GIVE_EFFECT.get();
        PermafrostAttackDamage = (Double)PERMAFROST_ATTACK_DAMAGE.get();
        PermafrostAttackSpeed = (Double)PERMAFROST_ATTACK_SPEED.get();
        PermafrostAttackDebuffDuration = (Integer)PERMAFROST_ATTACK_DEBUFF_DURATION.get();
        PermafrostAttackMaxStacks = (Integer)PERMAFROST_ATTACK_MAX_STACKS.get();
        PermafrostAttackReductionPerStack = (Double)PERMAFROST_ATTACK_REDUCTION_PER_STACK.get();
        PermafrostAuraRadius = (Integer)PERMAFROST_AURA_RADIUS.get();
        PermafrostAuraDebuffDuration = (Integer)PERMAFROST_AURA_DEBUFF_DURATION.get();
        PermafrostAuraReductionFactor = (Double)PERMAFROST_AURA_REDUCTION_FACTOR.get();
        CrucibleOfRileAttackDamage = (Double)CRUCIBLE_OF_RILE_ATTACK_DAMAGE.get();
        CrucibleOfRileAttackSpeed = (Double)CRUCIBLE_OF_RILE_ATTACK_SPEED.get();
        CrucibleOfRileExecuteThreshold = (Double)CRUCIBLE_OF_RILE_EXECUTE_THRESHOLD.get();
        CrucibleOfRileCooldown = (Integer)CRUCIBLE_OF_RILE_COOLDOWN.get();
        CrucibleOfRileAggroRadius = (Double)CRUCIBLE_OF_RILE_AGGRO_RADIUS.get();
        CrucibleOfRileAggroPlayers = (Boolean)CRUCIBLE_OF_RILE_AGGRO_PLAYERS.get();
        CrucibleOfRileAggroDuration = (Integer)CRUCIBLE_OF_RILE_AGGRO_DURATION.get();
        CrucibleOfRileArmorBuffValue = (Double)CRUCIBLE_OF_RILE_ARMOR_BUFF_VALUE.get();
        CrucibleOfRileArmorBuffDuration = (Integer)CRUCIBLE_OF_RILE_ARMOR_BUFF_DURATION.get();
        CrucibleOfRileHitsForCounterattack = (Integer)CRUCIBLE_OF_RILE_HITS_FOR_COUNTERATTACK.get();
        CrucibleOfRileCounterattackRadius = (Double)CRUCIBLE_OF_RILE_COUNTERATTACK_RADIUS.get();
        CrucibleOfRilePermanentArmorPerUnique = (Double)CRUCIBLE_OF_RILE_PERM_ARMOR_PER_UNIQUE.get();
        MoaiCharmKnockbackResistanceBonus = (Double)MOAI_CHARM_KNOCKBACK_RESISTANCE.get();
        lootTables = ((List)LOOT_TABLES.get()).stream().map(ResourceLocation::new).collect(Collectors.toList());
    }

    static {
        defaultLootTables.add("minecraft:chests/abandoned_mineshaft");
        defaultLootTables.add("minecraft:chests/ancient_city");
        defaultLootTables.add("minecraft:chests/ancient_city_ice_box");
        defaultLootTables.add("minecraft:chests/bastion_bridge");
        defaultLootTables.add("minecraft:chests/bastion_hoglin_stable");
        defaultLootTables.add("minecraft:chests/bastion_other");
        defaultLootTables.add("minecraft:chests/bastion_treasure");
        defaultLootTables.add("minecraft:chests/buried_treasure");
        defaultLootTables.add("minecraft:chests/desert_pyramid");
        defaultLootTables.add("minecraft:chests/end_city_treasure");
        defaultLootTables.add("minecraft:chests/igloo_chest");
        defaultLootTables.add("minecraft:chests/jungle_temple");
        defaultLootTables.add("minecraft:chests/nether_bridge");
        defaultLootTables.add("minecraft:chests/pillager_outpost");
        defaultLootTables.add("minecraft:chests/ruined_portal");
        defaultLootTables.add("minecraft:chests/shipwreck_map");
        defaultLootTables.add("minecraft:chests/shipwreck_supply");
        defaultLootTables.add("minecraft:chests/shipwreck_treasure");
        defaultLootTables.add("minecraft:chests/simple_dungeon");
        defaultLootTables.add("minecraft:chests/spawn_bonus_chest");
        defaultLootTables.add("minecraft:chests/stronghold_corridor");
        defaultLootTables.add("minecraft:chests/stronghold_crossing");
        defaultLootTables.add("minecraft:chests/stronghold_library");
        defaultLootTables.add("minecraft:chests/underwater_ruin_big");
        defaultLootTables.add("minecraft:chests/underwater_ruin_small");
        defaultLootTables.add("minecraft:chests/village/village_armorer");
        defaultLootTables.add("minecraft:chests/village/village_snowy_house");
        defaultLootTables.add("minecraft:chests/village/village_temple");
        defaultLootTables.add("minecraft:chests/village/village_toolsmith");
        defaultLootTables.add("minecraft:chests/village/village_weaponsmith");
        defaultLootTables.add("minecraft:chests/woodland_mansion");
        if (ModList.get().isLoaded("born_in_chaos_v1")) {
            defaultLootTables.add("minecraft:chests/basic_chest");
            defaultLootTables.add("minecraft:chests/chest_level_1");
            defaultLootTables.add("minecraft:chests/chest_level_2");
            defaultLootTables.add("minecraft:chests/chest_level_3");
            defaultLootTables.add("minecraft:chests/farm_drop");
            defaultLootTables.add("minecraft:chests/firewell_d");
            defaultLootTables.add("minecraft:chests/shater");
        }
        if (ModList.get().isLoaded("iceandfire")) {
            defaultLootTables.add("iceandfire:chest/cyclops_cave");
            defaultLootTables.add("iceandfire:chest/fire_dragon_female_cave");
            defaultLootTables.add("iceandfire:chest/fire_dragon_male_cave");
            defaultLootTables.add("iceandfire:chest/fire_dragon_roost");
            defaultLootTables.add("iceandfire:chest/graveyard");
            defaultLootTables.add("iceandfire:chest/hydra_cave");
            defaultLootTables.add("iceandfire:chest/ice_dragon_female_cave");
            defaultLootTables.add("iceandfire:chest/ice_dragon_male_cave");
            defaultLootTables.add("iceandfire:chest/ice_dragon_roost");
            defaultLootTables.add("iceandfire:chest/lightning_dragon_female_cave");
            defaultLootTables.add("iceandfire:chest/lightning_dragon_male_cave");
            defaultLootTables.add("iceandfire:chest/lightning_dragon_roost");
            defaultLootTables.add("iceandfire:chest/mausoleum_chest");
            defaultLootTables.add("iceandfire:chest/myrmex_desert_food_chest");
            defaultLootTables.add("iceandfire:chest/myrmex_jungle_food_chest");
            defaultLootTables.add("iceandfire:chest/myrmex_loot_chest");
            defaultLootTables.add("iceandfire:chest/myrmex_trash_chest");
            defaultLootTables.add("iceandfire:chest/village_scribe");
        }
        if (ModList.get().isLoaded("call_of_yucutan")) {
            defaultLootTables.add("call_of_yucutan:chest/crypt_chest_loot");
            defaultLootTables.add("call_of_yucutan:chest/overgrown_chest_loot");
        }
        USE_VERSIONED_JSON = BUILDER.comment(new String[]{"If true, JSON config file name is enigmatic_dice_<modVersion>.json.", "This means the config will auto-update to a fresh copy when the mod version changes.", "If false, a single enigmatic_dice.json is used and never auto-updated.", "In this mode new events added in mod updates will NOT appear automatically;", "pack makers will need to add them manually."}).define("useVersionedJson", true);
        LOOT_TABLES = BUILDER.comment("The list of chests in which the Enigmatic Die is added").defineListAllowEmpty("lootTables", defaultLootTables, Config::validateLootTable);
        ENIGMATIC_DIE_MOB_DROP_CHANCE = BUILDER.comment("Chance for Enigmatic Die to drop from a mob when killed by a player.\nFor example, a value of 0.005 means a 0.5% chance to drop.").defineInRange("enigmaticDieDropChance", 0.005, 0.0, 1.0);
        MOB_DICE_TIME_INTERVAL = BUILDER.comment("Defines the time requirement (in minutes) for earning Enigmatic Dice from killing mobs.\nThis is NOT a cooldown.\nFor every X minutes the player spends in the world, they are allowed to obtain 1 die from mobs.\nExample: If set to 10, then after 60 minutes of total playtime, the player may have earned up to 6 dice from mobs.\nSet to 0 to disable the limitation entirely.").defineInRange("mobDiceTimeInterval", 10, 0, 100000);
        ENIGMATIC_DIE_BLOCK_DROP_CHANCE = BUILDER.comment("Chance for Enigmatic Die to drop from a block when broken by a player.\nFor example, a value of 0.001 means a 0.1% chance to drop.").defineInRange("enigmaticDieBlockDropChance", 0.001, 0.0, 1.0);
        BLOCK_DICE_TIME_INTERVAL = BUILDER.comment("Defines the time requirement (in minutes) for earning Enigmatic Dice from breaking blocks.\nThis is NOT a cooldown.\nFor every X minutes the player spends in the world, they are allowed to obtain 1 die from blocks.\nExample: If set to 10, then after 60 minutes of total playtime, the player may have earned up to 6 dice from blocks.\nSet to 0 to disable the limitation entirely.").defineInRange("blockDiceTimeInterval", 10, 0, 100000);
        ENIGMATIC_DIE_CHEST_CHANCE = BUILDER.comment("Chance for Enigmatic Die to appear in a chest.\nValue is between 0.0 and 1.0. For example, 0.1 means a 10% chance.").defineInRange("enigmaticDieChestChance", 0.1, 0.0, 1.0);
        STRUCTURE_SEARCH_RADIUS = BUILDER.comment("Radius within which the structure is searched for during the 'minecraft_teleport_to_structure' event. Default is 100.\nHigher values search further but may impact performance.").defineInRange("structureSearchRadius", 100, 1, 10000);
        BIOME_SEARCH_RADIUS = BUILDER.comment("Radius (in blocks) to search for the target biome during the 'minecraft_teleport_to_biome' event.\nHigher values search further but may impact performance.").defineInRange("biomeSearchRadius", 4480, 256, 100000);
        BIOME_HORIZONTAL_STEP = BUILDER.comment("Horizontal search step when scanning for biomes in the 'minecraft_teleport_to_biome' event.\nSmaller values may increase accuracy but reduce performance.").defineInRange("biomeHorizontalStep", 64, 1, 512);
        BIOME_VERTICAL_STEP = BUILDER.comment("Vertical search step when scanning for biomes in the 'minecraft_teleport_to_biome' event.\nSmaller values may increase accuracy but reduce performance.").defineInRange("biomeVerticalStep", 128, 1, 512);
        UNEQUAL_EXCHANGE_TARGET_HEALTH_REDUCTION = BUILDER.comment("Percentage of target's max health reduced per hit by Unequal Exchange sword.\nExample: 0.10 = 10% of target's max health.").defineInRange("unequalExchangeTargetHealthReduction", 0.1, 0.0, 1.0);
        UNEQUAL_EXCHANGE_PLAYER_HEALTH_REDUCTION = BUILDER.comment("Percentage of player's max health reduced per hit by Unequal Exchange sword.\nExample: 0.20 = 20% of player's max health.").defineInRange("unequalExchangePlayerHealthReduction", 0.2, 0.0, 1.0);
        UNEQUAL_EXCHANGE_STAT_DEBUFF = BUILDER.comment("Percentage reduction of player's stats (armor, speed, etc.) per hit by Unequal Exchange sword.\nExample: 0.20 = 20% reduction.").defineInRange("unequalExchangeStatDebuff", 0.2, 0.0, 1.0);
        UNEQUAL_EXCHANGE_DEBUFF_DURATION = BUILDER.comment("Duration of the Unequal Exchange debuff (stat reduction) in seconds.\nEach hit refreshes this timer.").defineInRange("unequalExchangeDebuffDuration", 30, 0, 10000);
        UNEQUAL_EXCHANGE_ATTACK_DAMAGE = BUILDER.comment("Unequal Exchange Attack Damage.").define("unequalExchangeAttackDamage", (Object)1.0);
        UNEQUAL_EXCHANGE_ATTACK_SPEED = BUILDER.comment("Unequal Exchange Attack Speed.").define("unequalExchangeAttackSpeed", (Object)1.6);
        SOUL_EATER_CHARGED_ATTACK_DAMAGE_PER_HP = BUILDER.comment("Extra magic damage of Soul Eater's charged attack per HP spent.").defineInRange("soulEaterChargedAttackDamagePerHP", 2.5, 0.0, 100.0);
        SOUL_EATER_CHARGE_DURATION = BUILDER.comment("The duration of the effect of a charged Soul Eater attack (in seconds).").defineInRange("soulEaterChargeDuration", 60, 0, 100000);
        SOUL_EATER_HEAL_PERCENT_ON_KILL = BUILDER.comment("Percent of killed enemy's max HP restored to the player.\nExample: 0.1 = 10% of target's max HP.").defineInRange("soulEaterHealPercentOnKill", 0.1, 0.0, 1.0);
        SOUL_EATER_MAX_HEALTH_STEAL_PERCENT = BUILDER.comment("Percent of killed enemy's max HP added to player's max HP as bonus.\nExample: 0.1 = +10% max HP of killed enemy.").defineInRange("soulEaterMaxHealthStealPercent", 0.1, 0.0, 1.0);
        SOUL_EATER_MAX_HEALTH_BUFF_DURATION = BUILDER.comment("Duration (in seconds) of max health buff after killing an enemy.").defineInRange("soulEaterMaxHealthBuffDuration", 300, 0, 100000);
        SOUL_EATER_MAX_HEALTH_MULTIPLIER_LIMIT = BUILDER.comment("Maximum multiplier for player's max HP from Soul Eater.\nExample: 1.0 = Player's max HP can be increased up to 100%.").defineInRange("soulEaterMaxHealthMultiplierLimit", 1.0, 0.0, 100.0);
        SOUL_EATER_ATTACK_DAMAGE = BUILDER.comment("Soul Eater Attack Damage.").define("soulEaterAttackDamage", (Object)10.0);
        SOUL_EATER_ATTACK_SPEED = BUILDER.comment("Soul Eater Attack Speed.").define("soulEaterAttackSpeed", (Object)2.0);
        GIANTS_RING_ATTACK_DAMAGE = BUILDER.comment("Bonus attack damage granted by Giant's Ring.").defineInRange("giantsRingAttackDamage", 3.0, 0.0, 1024.0);
        GIANTS_RING_MAX_HEALTH = BUILDER.comment("Bonus max health granted by Giant's Ring.").defineInRange("giantsRingMaxHealth", 10.0, 0.0, 1024.0);
        GIANTS_RING_SPEED_BONUS = BUILDER.comment("Giant's Ring: movement speed bonus multiplier. (0.2 = +20% of base movement speed)").define("giantsRingSpeedBonus", (Object)0.2);
        MOON_SHARD_GRAVITY_REDUCTION = BUILDER.comment("Gravity change applied while Moon Shard is in hotbar.\nDefault Minecraft gravity is 0.08.").defineInRange("moonShardGravityReduction", -0.06, -1.0, 1.0);
        MOON_GRAVITY_REDUCTION = BUILDER.comment("Gravity change applied while holding the Moon item.\nDefault Minecraft gravity is 0.08.").defineInRange("moonGravityReduction", -0.1, -1.0, 1.0);
        GRAVITY_CORE_GRAVITY_MULTIPLIER = BUILDER.comment("Multiplier applied to gravity when holding SHIFT with Gravity Core.").defineInRange("gravityCoreGravityMultiplier", 5.0, 0.0, 100.0);
        GRAVITY_CORE_IMPACT_RADIUS_COEFFICIENT = BUILDER.comment("Impact radius coefficient when falling with Gravity Core.\nImpact radius = fall speed * this value.").defineInRange("gravityCoreImpactRadiusCoefficient", 1.0, 0.0, 10.0);
        GRAVITY_CORE_IMPACT_DAMAGE_COEFFICIENT = BUILDER.comment("Impact damage coefficient when falling with Gravity Core.\nDamage = player's attack damage * fall speed * this value.").defineInRange("gravityCoreImpactDamageCoefficient", 0.5, 0.0, 10.0);
        GRAVITY_CORE_JUMP_STRENGTH = BUILDER.comment("Jump strength boost applied when using Gravity Core.").defineInRange("gravityCoreJumpStrength", 5.0, 0.0, 50.0);
        GRAVITY_CORE_COOLDOWN = BUILDER.comment("Cooldown in ticks for Gravity Core jump (20 ticks = 1 second).").defineInRange("gravityCoreCooldown", 0, 0, 100000);
        RING_OF_AGILITY_CHANCE_SCALE = BUILDER.comment("Multiplier for movement speed in dodge chance formula.\nFormula: dodgeChance = 1.0 - pow(0.99, movementSpeed * 100 * scale)").defineInRange("ringOfAgilityChanceScale", 1.0, 0.0, 100.0);
        RING_OF_AGILITY_MAX_DODGE_CHANCE = BUILDER.comment("Maximum dodge chance.\nExample: 0.9 = 90% maximum dodge chance.").defineInRange("ringOfAgilityMaxDodgeChance", 0.9, 0.0, 1.0);
        DIVINE_SHIELD_COOLDOWN_TICKS = BUILDER.comment("Cooldown duration of the Divine Shield in ticks. (1 second = 20 ticks)").defineInRange("divineShieldCooldownTicks", 240, 0, Integer.MAX_VALUE);
        DIVINE_SHIELD_GIVE_EFFECT = BUILDER.comment("Whether to give the player the Divine Shield effect as an indicator that the item is not on cooldown.").define("divineShieldGiveEffect", true);
        PERMAFROST_ATTACK_DAMAGE = BUILDER.comment("Permafrost Attack Damage.").define("permafrostAttackDamage", (Object)10.0);
        PERMAFROST_ATTACK_SPEED = BUILDER.comment("Permafrost Attack Speed.").define("permafrostAttackSpeed", (Object)2.0);
        PERMAFROST_ATTACK_DEBUFF_DURATION = BUILDER.comment("Duration of the Permafrost debuff applied when hitting a target, in ticks. (1 second = 20 ticks)").defineInRange("permafrostAttackDebuffDuration", 600, 0, Integer.MAX_VALUE);
        PERMAFROST_ATTACK_MAX_STACKS = BUILDER.comment("Maximum number of Permafrost stacks applied from attacks.").defineInRange("permafrostAttackMaxStacks", 10, 0, Integer.MAX_VALUE);
        PERMAFROST_ATTACK_REDUCTION_PER_STACK = BUILDER.comment("Movement/Flying speed reduction per Permafrost stack applied from attacks (0.05 = 5% slower).").defineInRange("permafrostAttackReductionPerStack", 0.05, 0.0, 1.0);
        PERMAFROST_AURA_RADIUS = BUILDER.comment("Radius of the Permafrost aura effect in blocks.").defineInRange("permafrostAuraRadius", 5, 0, 32);
        PERMAFROST_AURA_DEBUFF_DURATION = BUILDER.comment("Duration of the Permafrost aura debuff in ticks. (1 second = 20 ticks)").defineInRange("permafrostAuraDebuffDuration", 100, 0, Integer.MAX_VALUE);
        PERMAFROST_AURA_REDUCTION_FACTOR = BUILDER.comment("Movement/Flying speed reduction factor from Permafrost aura. (0.2 = 20% slower)").defineInRange("permafrostAuraReductionFactor", 0.2, 0.0, 1.0);
        CRUCIBLE_OF_RILE_ATTACK_DAMAGE = BUILDER.comment("Crucible Of Rile Attack Damage.").define("crucibleOfRileAttackDamage", (Object)16.0);
        CRUCIBLE_OF_RILE_ATTACK_SPEED = BUILDER.comment("Crucible Of Rile Attack Speed.").define("crucibleOfRileAttackSpeed", (Object)1.4);
        CRUCIBLE_OF_RILE_EXECUTE_THRESHOLD = BUILDER.comment("Crucible Of Rile: health threshold at or below which enemies can be executed.").define("crucibleOfRileExecuteThreshold", (Object)5.0);
        CRUCIBLE_OF_RILE_COOLDOWN = BUILDER.comment("Crucible Of Rile: ability cooldown in ticks. (1 second = 20 ticks)").defineInRange("crucibleOfRileCooldown", 400, 0, Integer.MAX_VALUE);
        CRUCIBLE_OF_RILE_AGGRO_RADIUS = BUILDER.comment("Crucible Of Rile: aggro radius of the ability, in blocks.").define("crucibleOfRileAggroRadius", (Object)16.0);
        CRUCIBLE_OF_RILE_AGGRO_PLAYERS = BUILDER.comment("Crucible Of Rile: whether the ability should aggro players (forcing them to look at the item user).").define("crucibleOfRileAggroPlayers", true);
        CRUCIBLE_OF_RILE_AGGRO_DURATION = BUILDER.comment("Crucible Of Rile: duration of the forced aggro (camera lock) effect in ticks. (1 second = 20 ticks)").defineInRange("crucibleOfRileAggroDuration", 100, 0, Integer.MAX_VALUE);
        CRUCIBLE_OF_RILE_ARMOR_BUFF_VALUE = BUILDER.comment("Crucible Of Rile: armor buff multiplier applied by the active ability. (0.5 = +50%)").define("crucibleOfRileArmorBuffValue", (Object)0.5);
        CRUCIBLE_OF_RILE_ARMOR_BUFF_DURATION = BUILDER.comment("Crucible Of Rile: duration of the armor buff from the active ability, in ticks. (1 second = 20 ticks)").defineInRange("crucibleOfRileArmorBuffDuration", 100, 0, Integer.MAX_VALUE);
        CRUCIBLE_OF_RILE_HITS_FOR_COUNTERATTACK = BUILDER.comment("Crucible Of Rile: number of hits the player must take before triggering a counterattack.").defineInRange("crucibleOfRileHitsForCounterattack", 5, 1, Integer.MAX_VALUE);
        CRUCIBLE_OF_RILE_COUNTERATTACK_RADIUS = BUILDER.comment("Crucible Of Rile: radius of the counterattack, in blocks.").define("crucibleOfRileCounterattackRadius", (Object)3.5);
        CRUCIBLE_OF_RILE_PERM_ARMOR_PER_UNIQUE = BUILDER.comment("Permanent armor bonus (percent as fraction) per unique killed enemy type. (0.01 = +1%)").define("crucibleOfRilePermanentArmorPerUnique", (Object)0.005);
        MOAI_CHARM_KNOCKBACK_RESISTANCE = BUILDER.comment("Moai Charm: knockback resistance bonus. (1.0 = full knockback immunity)").define("moaiCharmKnockbackResistanceBonus", (Object)1.0);
        SPEC = BUILDER.build();
    }
}

