/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.simplyswordsoverhaul.mixin;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.jrdemiurge.simplyswordsoverhaul.Config;
import net.jrdemiurge.simplyswordsoverhaul.scheduler.Scheduler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.custom.StarsEdgeSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StarsEdgeSwordItem.class})
public abstract class MixinStarsEdgeSword
extends UniqueSwordItem {
    private static final HashMap<UUID, Vec3> savedPositions = new HashMap();

    public MixinStarsEdgeSword(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyHurtEnemyMethod(ItemStack stack, LivingEntity target, LivingEntity attacker, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.enableStarsEdgeChanges) {
            return;
        }
        if (!attacker.m_9236_().m_5776_()) {
            float magicDamage = (float)Config.starsEdgeMagicDamage;
            target.f_19802_ = 0;
            target.m_6469_(attacker.m_269291_().m_269104_((Entity)attacker, (Entity)attacker), magicDamage);
        }
        cir.setReturnValue((Object)super.m_7579_(stack, target, attacker));
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyUseMethod(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!Config.enableStarsEdgeChanges) {
            return;
        }
        if (!user.m_9236_().m_5776_()) {
            boolean isOffHandItemNotOnCooldown;
            UUID playerId = user.m_20148_();
            ItemStack offHandItem = user.m_21120_(InteractionHand.OFF_HAND);
            boolean isMainHandUse = hand == InteractionHand.MAIN_HAND;
            boolean bl = isOffHandItemNotOnCooldown = !user.m_36335_().m_41519_(offHandItem.m_41720_());
            if (isMainHandUse && isOffHandItemNotOnCooldown) {
                user.m_36335_().m_41524_(offHandItem.m_41720_(), 4);
            }
            int teleportDelay = Config.starsEdgeTeleportDelay;
            int cooldown = Config.starsEdgeCooldownTicks;
            int speedDuration = Config.starsEdgeSpeedDuration;
            int speedLevel = Config.starsEdgeSpeedLevel;
            int hasteDuration = Config.starsEdgeHasteDuration;
            int hasteLevel = Config.starsEdgeHasteLevel;
            double dashForce = Config.starsEdgeDashForce;
            int resistanceDuration = Config.starsEdgeResistanceDuration;
            user.m_6674_(hand);
            if (savedPositions.containsKey(playerId)) {
                Vec3 savedPos = savedPositions.remove(playerId);
                user.m_6021_(savedPos.f_82479_, savedPos.f_82480_, savedPos.f_82481_);
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_HOLY_SHOOT_IMPACT_01.get(), user.m_5720_(), 0.5f, 1.3f);
                user.m_36335_().m_41524_((Item)((StarsEdgeSwordItem)this), cooldown);
            } else {
                savedPositions.put(playerId, user.m_20182_());
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_HOLY_SHOOT_IMPACT_02.get(), user.m_5720_(), 0.5f, 1.3f);
                if (user.m_6144_()) {
                    user.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20 * resistanceDuration, 4, false, false));
                } else {
                    Vec3 lookVec = user.m_20154_();
                    Vec3 horizontalLookVec = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_).m_82541_().m_82490_(dashForce);
                    user.m_20256_(horizontalLookVec);
                    ((ServerPlayer)user).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)user));
                    user.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20 * resistanceDuration, 4, false, false));
                }
                Scheduler.schedule(() -> {
                    if (savedPositions.containsKey(playerId)) {
                        Vec3 savedPos = savedPositions.remove(playerId);
                        user.m_6021_(savedPos.f_82479_, savedPos.f_82480_, savedPos.f_82481_);
                        world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_HOLY_SHOOT_IMPACT_01.get(), user.m_5720_(), 0.5f, 1.3f);
                        user.m_36335_().m_41524_((Item)((StarsEdgeSwordItem)this), cooldown);
                    }
                }, 20 * teleportDelay, 0);
                this.applyOrUpgradeEffect(user, MobEffects.f_19596_, 20 * speedDuration, speedLevel - 1);
                this.applyOrUpgradeEffect(user, MobEffects.f_19598_, 20 * hasteDuration, hasteLevel - 1);
                user.m_36335_().m_41524_((Item)((StarsEdgeSwordItem)this), 10);
            }
        }
        cir.setReturnValue((Object)super.m_7203_(world, user, hand));
    }

    private void applyOrUpgradeEffect(Player player, MobEffect effect, int duration, int baseAmplifier) {
        MobEffectInstance existingEffect = player.m_21124_(effect);
        int newAmplifier = existingEffect != null ? existingEffect.m_19564_() + baseAmplifier + 1 : baseAmplifier;
        player.m_7292_(new MobEffectInstance(effect, duration, newAmplifier, false, true));
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext, CallbackInfo ci) {
        if (!Config.enableStarsEdgeChanges) {
            return;
        }
        ci.cancel();
        float magicDamage = (float)Config.starsEdgeMagicDamage;
        int teleportDelay = Config.starsEdgeTeleportDelay;
        int speedLevel = Config.starsEdgeSpeedLevel;
        int hasteDuration = Config.starsEdgeHasteDuration;
        int hasteLevel = Config.starsEdgeHasteLevel;
        int cooldown = Config.starsEdgeCooldownTicks;
        float floatCooldown = (float)cooldown / 20.0f;
        if (Screen.m_96639_()) {
            String translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.starsedgeitem", (Object[])new Object[]{Float.valueOf(magicDamage), speedLevel, hasteLevel, hasteDuration, teleportDelay}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
        } else if (Screen.m_96638_()) {
            String translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.starsedgeitem", (Object[])new Object[]{Float.valueOf(magicDamage), speedLevel, hasteLevel, hasteDuration, teleportDelay}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.starsedgeitem_shift").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line).m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
        } else {
            String translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.starsedgeitem", (Object[])new Object[]{Float.valueOf(magicDamage), speedLevel, hasteLevel, hasteDuration, teleportDelay}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
            if (!tooltip.get(tooltip.size() - 1).getString().equals(Component.m_237115_((String)"item.simplyswords.common.showtooltip").getString())) {
                tooltip.add((Component)Component.m_237113_((String)""));
            }
            tooltip.add((Component)Component.m_237115_((String)"tooltip.simply_swords_overhaul.shift"));
        }
    }
}

