/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.simplyswordsoverhaul.mixin;

import java.util.List;
import net.jrdemiurge.simplyswordsoverhaul.Config;
import net.jrdemiurge.simplyswordsoverhaul.util.DamageTracker;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.custom.ShadowstingSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShadowstingSwordItem.class})
public abstract class MixinShadowstingSword
extends UniqueSwordItem {
    public MixinShadowstingSword(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyHurtEnemyMethod(ItemStack stack, LivingEntity target, LivingEntity attacker, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.enableShadowstingChanges) {
            return;
        }
        if (!attacker.m_9236_().m_5776_()) {
            float armorDamageMultiplier = (float)Config.shadowstingArmorDamageMultiplier;
            float previousHealth = DamageTracker.getLastHealth(target.m_20148_());
            if (previousHealth != -1.0f) {
                float damage = 0.0f;
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    float f = (float)player.m_21133_(Attributes.f_22281_);
                    float f1 = target instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)target.m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)MobType.f_21640_);
                    float f2 = player.m_36403_(0.5f);
                    f1 *= f2;
                    if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                        boolean flag = f2 > 0.9f;
                        boolean flag2 = flag && player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_() && target instanceof LivingEntity;
                        flag2 = flag2 && !player.m_20142_();
                        CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)player, (Entity)target, (boolean)flag2, (float)(flag2 ? 1.5f : 1.0f));
                        boolean bl = flag2 = hitResult != null;
                        if (flag2) {
                            f *= hitResult.getDamageModifier();
                        }
                        damage = f += f1;
                    }
                } else {
                    float f = (float)attacker.m_21133_(Attributes.f_22281_);
                    float f1 = target instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)attacker.m_21205_(), (MobType)target.m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)attacker.m_21205_(), (MobType)MobType.f_21640_);
                    damage = f += f1;
                }
                double armorValue = target.m_21133_(Attributes.f_22284_);
                if ((damage *= 1.0f + (float)(armorValue * (double)armorDamageMultiplier)) != 0.0f) {
                    target.m_21153_(previousHealth);
                    target.f_19802_ = 0;
                    target.m_6469_(attacker.m_269291_().m_269104_((Entity)attacker, (Entity)attacker), damage);
                }
            }
        }
        cir.setReturnValue((Object)super.m_7579_(stack, target, attacker));
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyUseMethod(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!Config.enableShadowstingChanges) {
            return;
        }
        if (!user.m_9236_().m_5776_()) {
            Vec3 targetPos;
            boolean isOffHandItemNotOnCooldown;
            ItemStack offHandItem = user.m_21120_(InteractionHand.OFF_HAND);
            boolean isMainHandUse = hand == InteractionHand.MAIN_HAND;
            boolean bl = isOffHandItemNotOnCooldown = !user.m_36335_().m_41519_(offHandItem.m_41720_());
            if (isMainHandUse && isOffHandItemNotOnCooldown) {
                user.m_36335_().m_41524_(offHandItem.m_41720_(), 4);
            }
            double teleportDistance = Config.shadowstingTeleportDistance;
            int blindnessDuration = Config.shadowstingBlindnessDuration;
            int cooldown = Config.shadowstingCooldownTicks;
            float radius = 4.0f;
            Vec3 lookVec = user.m_20154_();
            Vec3 horizontalLookVec = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_).m_82541_().m_82490_(teleportDistance);
            if (user.m_6144_()) {
                horizontalLookVec = horizontalLookVec.m_82490_(-1.0);
            }
            if (world.m_8055_(BlockPos.m_274446_((Position)(targetPos = user.m_20182_().m_82549_(horizontalLookVec)))).m_60812_((BlockGetter)world, BlockPos.m_274446_((Position)targetPos)).m_83281_()) {
                world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_EARTH_ATTACK_01.get(), user.m_5720_(), 0.4f, 1.6f);
                AABB box = new AABB(user.m_20185_() + (double)radius, user.m_20186_() + (double)radius, user.m_20189_() + (double)radius, user.m_20185_() - (double)radius, user.m_20186_() - (double)radius, user.m_20189_() - (double)radius);
                for (Entity entity : world.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                    LivingEntity le;
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire((LivingEntity)(le = (LivingEntity)entity), (LivingEntity)user)) continue;
                    le.m_147207_(new MobEffectInstance(MobEffects.f_19610_, 20 * blindnessDuration, 0), (Entity)user);
                }
                double xpos = user.m_20185_() - (double)(radius + 1.0f);
                double ypos = user.m_20186_();
                double zpos = user.m_20189_() - (double)(radius + 1.0f);
                for (int i = (int)radius * 2; i > 0; --i) {
                    for (int j = (int)radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle((Level)world, (ParticleOptions)ParticleTypes.f_123755_, (double)(xpos + (double)i + (double)choose), (double)(ypos + 0.4), (double)(zpos + (double)j + (double)choose), (double)0.0, (double)0.1, (double)0.0);
                        HelperMethods.spawnParticle((Level)world, (ParticleOptions)ParticleTypes.f_123777_, (double)(xpos + (double)i + (double)choose), (double)(ypos + 0.1), (double)(zpos + (double)j + (double)choose), (double)0.0, (double)0.0, (double)0.0);
                        HelperMethods.spawnParticle((Level)world, (ParticleOptions)ParticleTypes.f_123762_, (double)(xpos + (double)i + (double)choose), (double)ypos, (double)(zpos + (double)j + (double)choose), (double)0.0, (double)0.1, (double)0.0);
                    }
                }
                user.m_6021_(targetPos.f_82479_, user.m_20186_(), targetPos.f_82481_);
                user.m_36335_().m_41524_((Item)((ShadowstingSwordItem)this), cooldown);
            } else {
                user.m_36335_().m_41524_((Item)((ShadowstingSwordItem)this), 10);
            }
        }
        cir.setReturnValue((Object)super.m_7203_(world, user, hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext, CallbackInfo ci) {
        if (!Config.enableShadowstingChanges) {
            return;
        }
        ci.cancel();
        float armorDamageMultiplier = (float)Config.shadowstingArmorDamageMultiplier;
        double teleportDistance = Config.shadowstingTeleportDistance;
        int cooldown = Config.shadowstingCooldownTicks;
        float floatCooldown = (float)cooldown / 20.0f;
        if (Screen.m_96639_()) {
            String translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.shadowstingitem_1").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.shadowstingitem_2", (Object[])new Object[]{teleportDistance}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
        } else if (Screen.m_96638_()) {
            String translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.shadowstingitem_1").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.shadowstingitem_shift_1", (Object[])new Object[]{Float.valueOf(armorDamageMultiplier * 100.0f)}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line).m_130940_(ChatFormatting.GRAY));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.shadowstingitem_2", (Object[])new Object[]{teleportDistance}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.shadowstingitem_shift_2").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line).m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
        } else {
            String translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.shadowstingitem_1").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.shadowstingitem_2", (Object[])new Object[]{teleportDistance}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.simply_swords_overhaul.cooldown", (Object[])new Object[]{Float.valueOf(floatCooldown)}).m_130940_(ChatFormatting.BLUE));
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
            if (!tooltip.get(tooltip.size() - 1).getString().equals(Component.m_237115_((String)"item.simplyswords.common.showtooltip").getString())) {
                tooltip.add((Component)Component.m_237113_((String)""));
            }
            tooltip.add((Component)Component.m_237115_((String)"tooltip.simply_swords_overhaul.shift"));
        }
    }
}

