/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.simplyswordsoverhaul.mixin;

import java.util.List;
import net.jrdemiurge.simplyswordsoverhaul.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.custom.MoltenEdgeSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MoltenEdgeSwordItem.class})
public abstract class MixinMoltenEdgeSword
extends UniqueSwordItem {
    @Unique
    private static int simply_Swords_Overhaul_1_20_1$stepMod = 0;

    public MixinMoltenEdgeSword(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyHurtEnemyMethod(ItemStack stack, LivingEntity target, LivingEntity attacker, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.enableMoltenEdgeChanges) {
            return;
        }
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            target.m_20254_(3);
            world.m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), attacker.m_5720_(), 0.4f, 2.0f);
        }
        cir.setReturnValue((Object)super.m_7579_(stack, target, attacker));
    }

    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyInventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected, CallbackInfo ci) {
        Player player;
        if (!Config.enableMoltenEdgeChanges) {
            return;
        }
        if (!world.f_46443_ && entity instanceof Player && ((player = (Player)entity).m_6844_(EquipmentSlot.MAINHAND) == stack || player.m_6844_(EquipmentSlot.OFFHAND) == stack)) {
            ItemStack mainHandItem = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offHandItem = player.m_21120_(InteractionHand.OFF_HAND);
            boolean hasTwoSwords = mainHandItem.m_150930_((Item)ItemsRegistry.MOLTEN_EDGE.get()) && offHandItem.m_150930_((Item)ItemsRegistry.MOLTEN_EDGE.get());
            float missingHealthPercentage = 1.0f - player.m_21223_() / player.m_21233_();
            int effectLevel = (int)(missingHealthPercentage / 0.2f);
            effectLevel -= 2;
            if (hasTwoSwords) {
                ++effectLevel;
            }
            if (effectLevel >= 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 100, effectLevel, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 100, effectLevel, false, false));
            }
            if (effectLevel - 1 >= 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, effectLevel - 1, false, false));
            }
        }
        if (simply_Swords_Overhaul_1_20_1$stepMod > 0) {
            --simply_Swords_Overhaul_1_20_1$stepMod;
        }
        if (simply_Swords_Overhaul_1_20_1$stepMod <= 0) {
            simply_Swords_Overhaul_1_20_1$stepMod = 7;
        }
        player = (Player)entity;
        SimpleParticleType particlePassive = ParticleTypes.f_123762_;
        float healthPercentage = player.m_21223_() / player.m_21233_();
        if ((double)healthPercentage < 0.66) {
            particlePassive = ParticleTypes.f_123755_;
        }
        if ((double)healthPercentage < 0.33) {
            particlePassive = ParticleTypes.f_123756_;
        }
        HelperMethods.createFootfalls((Entity)entity, (ItemStack)stack, (Level)world, (int)simply_Swords_Overhaul_1_20_1$stepMod, (SimpleParticleType)particlePassive, (SimpleParticleType)particlePassive, (SimpleParticleType)particlePassive, (boolean)true);
        super.m_6883_(stack, world, entity, slot, selected);
        ci.cancel();
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyUseMethod(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!Config.enableMoltenEdgeChanges) {
            return;
        }
        if (!user.m_9236_().m_5776_()) {
            boolean isOffHandItemNotOnCooldown;
            ItemStack offHandItem = user.m_21120_(InteractionHand.OFF_HAND);
            boolean isMainHandUse = hand == InteractionHand.MAIN_HAND;
            boolean bl = isOffHandItemNotOnCooldown = !user.m_36335_().m_41519_(offHandItem.m_41720_());
            if (isMainHandUse && isOffHandItemNotOnCooldown) {
                user.m_36335_().m_41524_(offHandItem.m_41720_(), 4);
            }
            world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), user.m_5720_(), 0.4f, 2.0f);
            float newHealth = Math.max(1.0f, user.m_21223_() - 4.0f);
            user.m_21153_(newHealth);
            user.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0, false, true));
            user.m_36335_().m_41524_((Item)((MoltenEdgeSwordItem)this), 4);
        }
        cir.setReturnValue((Object)super.m_7203_(world, user, hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext, CallbackInfo ci) {
        if (!Config.enableMoltenEdgeChanges) {
            return;
        }
        ci.cancel();
        if (Screen.m_96639_()) {
            String translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.moltenedgeitem_1").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.moltenedgeitem_2").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
        } else if (Screen.m_96638_()) {
            String translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.moltenedgeitem_1").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.moltenedgeitem_shift").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line).m_130940_(ChatFormatting.GRAY));
            }
            translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.moltenedgeitem_2").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
        } else {
            String translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.moltenedgeitem_1").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.moltenedgeitem_2").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
            if (!tooltip.get(tooltip.size() - 1).getString().equals(Component.m_237115_((String)"item.simplyswords.common.showtooltip").getString())) {
                tooltip.add((Component)Component.m_237113_((String)""));
            }
            tooltip.add((Component)Component.m_237115_((String)"tooltip.simply_swords_overhaul.shift"));
        }
    }
}

