/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.world.structure.brass;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.world.structurepiece.LargeAercloudChunk;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import teamrazor.deepaether.world.structure.DAStructureTypes;
import teamrazor.deepaether.world.structure.brass.BrassRoom;

public class BrassDungeonStructure
extends Structure {
    public static final Codec<BrassDungeonStructure> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BrassDungeonStructure.m_226567_((RecordCodecBuilder.Instance)builder), (App)Codec.INT.fieldOf("minY").forGetter(o -> o.minY), (App)Codec.INT.fieldOf("rangeY").forGetter(o -> o.rangeY)).apply((Applicative)builder, BrassDungeonStructure::new));
    private final int minY;
    private final int rangeY;

    public BrassDungeonStructure(Structure.StructureSettings settings, int minY, int rangeY) {
        super(settings);
        this.minY = minY;
        this.rangeY = rangeY;
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        WorldgenRandom random = context.f_226626_();
        ChunkPos chunkpos = context.f_226628_();
        int height = this.minY + random.m_188503_(this.rangeY);
        BlockPos blockpos = new BlockPos(chunkpos.m_151390_(), height, chunkpos.m_151393_());
        return Optional.of(new Structure.GenerationStub(blockpos, piecesBuilder -> this.generatePieces((StructurePiecesBuilder)piecesBuilder, context, blockpos)));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)DAStructureTypes.BRASS_DUNGEON.get();
    }

    private String getRandomRoomType(RandomSource random) {
        int num = random.m_188503_(77);
        if (num <= 25) {
            return "brass_dungeon_room_4";
        }
        if (num <= 45) {
            return "brass_dungeon_room_0";
        }
        if (num <= 55) {
            return "brass_dungeon_room_2";
        }
        if (num <= 70) {
            return "brass_dungeon_room_1";
        }
        return "brass_dungeon_room_3";
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, BlockPos elevatedPos) {
        WorldgenRandom random = context.f_226626_();
        StructureTemplateManager templateManager = context.f_226625_();
        this.buildCloudBed(builder, (RandomSource)random, elevatedPos.m_7494_().m_5484_(Direction.NORTH, 34).m_122025_(10));
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        this.createBossRoom((RandomSource)random, builder, elevatedPos, rotation, templateManager, true);
        rotation = rotation.m_55952_(Rotation.CLOCKWISE_90);
        this.createBossRoom((RandomSource)random, builder, elevatedPos.m_5484_(rotation.m_55954_(Direction.SOUTH), 1), rotation, templateManager, false);
        rotation = rotation.m_55952_(Rotation.CLOCKWISE_90);
        this.createBossRoom((RandomSource)random, builder, elevatedPos.m_5484_(rotation.m_55954_(Direction.SOUTH), 1).m_5484_(rotation.m_55954_(Direction.EAST), 1), rotation, templateManager, false);
        rotation = rotation.m_55952_(Rotation.CLOCKWISE_90);
        this.createBossRoom((RandomSource)random, builder, elevatedPos.m_5484_(rotation.m_55954_(Direction.EAST), 1), rotation, templateManager, false);
        rotation = rotation.m_55952_(Rotation.CLOCKWISE_90);
        builder.m_142679_((StructurePiece)new BrassRoom(templateManager, "door", elevatedPos.m_5484_(rotation.m_55954_(Direction.EAST), 4), rotation));
    }

    private void createBossRoom(RandomSource random, StructurePiecesBuilder builder, BlockPos pos, Rotation rotation, StructureTemplateManager templateManager, boolean parent) {
        String room = this.getRandomRoomType(random);
        if (parent) {
            builder.m_142679_((StructurePiece)new BrassRoom.BossRoom(templateManager, room + "_boss", pos, rotation));
        } else {
            builder.m_142679_((StructurePiece)new BrassRoom(templateManager, room, pos, rotation));
        }
        builder.m_142679_((StructurePiece)new BrassRoom(templateManager, "room_part_up", pos.m_6630_(32), rotation));
    }

    private void buildCloudBed(StructurePiecesBuilder builder, RandomSource random, BlockPos origin) {
        int xBounds = 77;
        int zBounds = 77;
        BlockPos.MutableBlockPos offset = origin.m_122032_().m_122184_(0, -1, 0);
        HashMap<ChunkPos, Set> chunks = new HashMap<ChunkPos, Set>();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int tries = 0; tries < 100; ++tries) {
            int x = offset.m_123341_() + random.m_188503_(xBounds);
            int y = offset.m_123342_();
            int z = offset.m_123343_() + random.m_188503_(zBounds);
            int xTendency = random.m_188503_(3) - 1;
            int zTendency = random.m_188503_(3) - 1;
            for (int n = 0; n < 10; ++n) {
                x += random.m_188503_(3) - 1 + xTendency;
                if (random.m_188499_()) {
                    y += random.m_188503_(3) - 1;
                }
                z += random.m_188503_(3) - 1 + zTendency;
                for (int x1 = x; x1 < x + random.m_188503_(4) + 3; ++x1) {
                    for (int y1 = y; y1 < y + random.m_188503_(1) + 2; ++y1) {
                        for (int z1 = z; z1 < z + random.m_188503_(4) + 3; ++z1) {
                            if (Math.abs(x1 - x) + Math.abs(y1 - y) + Math.abs(z1 - z) >= 4 + random.m_188503_(2)) continue;
                            BlockPos newPosition = new BlockPos(x1, y1, z1);
                            positions.add(newPosition);
                            chunks.computeIfAbsent(new ChunkPos(newPosition), pos -> new HashSet());
                        }
                    }
                }
            }
        }
        chunks.forEach((chunkPos, blockPosSet) -> {
            blockPosSet.addAll(positions.stream().filter(pos -> new ChunkPos(pos).equals(chunkPos)).toList());
            builder.m_142679_((StructurePiece)new LargeAercloudChunk(blockPosSet, (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)AetherBlocks.COLD_AERCLOUD.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)))), new BoundingBox(chunkPos.m_45604_(), origin.m_123342_(), chunkPos.m_45605_(), chunkPos.m_45608_(), origin.m_123342_(), chunkPos.m_45609_()), Direction.NORTH));
        });
    }
}

