/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.world.feature.features;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import teamrazor.deepaether.datagen.tags.DATags;
import teamrazor.deepaether.world.feature.features.configuration.AercloudCloudConfiguration;

public class AercloudCloudFeature
extends Feature<AercloudCloudConfiguration> {
    public static final PerlinSimplexNoise NOISE = new PerlinSimplexNoise((RandomSource)new XoroshiroRandomSource(42L), List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1)));

    public AercloudCloudFeature(Codec<AercloudCloudConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<AercloudCloudConfiguration> context) {
        WorldGenLevel reader = context.m_159774_();
        BlockPos pos = context.m_159777_();
        AercloudCloudConfiguration config = (AercloudCloudConfiguration)context.m_159778_();
        this.place(reader, pos, config, context.m_225041_());
        return true;
    }

    public void place(WorldGenLevel reader, BlockPos pos, AercloudCloudConfiguration config, RandomSource random) {
        boolean goAgainstX = !reader.m_7062_().m_204216_(pos.m_5487_(Direction.Axis.X, 16)).m_203656_(DATags.Biomes.IS_CLOUD);
        boolean goAgainstNegativeX = !reader.m_7062_().m_204216_(pos.m_5487_(Direction.Axis.X, -16)).m_203656_(DATags.Biomes.IS_CLOUD);
        boolean goAgainstZ = !reader.m_7062_().m_204216_(pos.m_5487_(Direction.Axis.Z, 16)).m_203656_(DATags.Biomes.IS_CLOUD);
        boolean goAgainstNegativeZ = !reader.m_7062_().m_204216_(pos.m_5487_(Direction.Axis.Z, -16)).m_203656_(DATags.Biomes.IS_CLOUD);
        boolean goAgainstXAndZ = !reader.m_7062_().m_204216_(pos.m_5487_(Direction.Axis.X, 16).m_5487_(Direction.Axis.Z, 16)).m_203656_(DATags.Biomes.IS_CLOUD) && !goAgainstX && !goAgainstZ;
        boolean goAgainstXAndNegativeZ = !reader.m_7062_().m_204216_(pos.m_5487_(Direction.Axis.X, 16).m_5487_(Direction.Axis.Z, -16)).m_203656_(DATags.Biomes.IS_CLOUD) && !goAgainstX && !goAgainstNegativeZ;
        boolean goAgainstNegativeXAndZ = !reader.m_7062_().m_204216_(pos.m_5487_(Direction.Axis.X, -16).m_5487_(Direction.Axis.Z, 16)).m_203656_(DATags.Biomes.IS_CLOUD) && !goAgainstNegativeX && !goAgainstZ;
        boolean goAgainstNegativeXAndNegativeZ = !reader.m_7062_().m_204216_(pos.m_5487_(Direction.Axis.X, -16).m_5487_(Direction.Axis.Z, -16)).m_203656_(DATags.Biomes.IS_CLOUD) && !goAgainstNegativeX && !goAgainstNegativeZ;
        int chunkX = pos.m_123341_() - pos.m_123341_() % 16;
        int chunkZ = pos.m_123343_() - pos.m_123343_() % 16;
        int lowestY = config.height();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double bottom;
                int xCoord = chunkX + x;
                int zCoord = chunkZ + z;
                double bottomNoiseValue = NOISE.m_75449_((double)xCoord * 0.02, (double)zCoord * 0.02, false);
                double originalBottom = bottom = Math.abs(Mth.m_14139_((double)bottomNoiseValue, (double)4.0, (double)2.0));
                double topNoiseValue = NOISE.m_75449_((double)xCoord * 0.007, (double)zCoord * 0.007, false);
                double top = Mth.m_14139_((double)topNoiseValue, (double)-2.0, (double)7.0) + 2.0;
                if (top < 3.0) {
                    top -= (3.0 - top) * 2.0;
                }
                double decreaseMultiplier = 1.5;
                double decreaseMultiplierCorner = 4.0;
                if (goAgainstX && x > 8) {
                    bottom += ((double)x - 8.0) / 1.5;
                    top -= ((double)x - 8.0) / 1.5;
                }
                if (goAgainstNegativeX && x <= 8) {
                    bottom += (8.0 - (double)x) / 1.5;
                    top -= (8.0 - (double)x) / 1.5;
                }
                if (goAgainstZ && z > 8) {
                    bottom += ((double)z - 8.0) / 1.5;
                    top -= ((double)z - 8.0) / 1.5;
                }
                if (goAgainstNegativeZ) {
                    if (z < 8) {
                        bottom += (8.0 - (double)z) / 1.5;
                        top -= (8.0 - (double)z) / 1.5;
                    }
                } else if (goAgainstXAndZ) {
                    if (x > 12) {
                        bottom += ((double)x - 12.0) / 4.0;
                        top -= ((double)x - 12.0) / 4.0;
                    }
                    if (z > 12) {
                        bottom += ((double)z - 12.0) / 4.0;
                        top -= ((double)z - 12.0) / 4.0;
                    }
                } else if (goAgainstXAndNegativeZ) {
                    if (x > 12) {
                        bottom += ((double)x - 12.0) / 4.0;
                        top -= ((double)x - 12.0) / 4.0;
                    }
                    if (z < 4) {
                        bottom += (4.0 - (double)z) / 4.0;
                        top -= (4.0 - (double)z) / 4.0;
                    }
                } else if (goAgainstNegativeXAndZ) {
                    if (x < 4) {
                        bottom += (4.0 - (double)x) / 4.0;
                        top -= (4.0 - (double)x) / 4.0;
                    }
                    if (z > 12) {
                        bottom += ((double)z - 12.0) / 4.0;
                        top -= ((double)z - 12.0) / 4.0;
                    }
                } else if (goAgainstNegativeXAndNegativeZ) {
                    if (x < 4) {
                        bottom += (4.0 - (double)x) / 4.0;
                        top -= (4.0 - (double)x) / 4.0;
                    }
                    if (z < 4) {
                        bottom += (4.0 - (double)z) / 4.0;
                        top -= (4.0 - (double)z) / 4.0;
                    }
                }
                int y = Math.round(Math.round((double)lowestY + bottom - top / 2.0));
                while ((double)y < (double)lowestY + top + originalBottom) {
                    this.m_5974_((LevelWriter)reader, pos.m_5487_(Direction.Axis.X, x).m_5487_(Direction.Axis.Z, z).m_175288_(y), config.block().m_213972_(random, pos));
                    ++y;
                }
                originalBottom *= 4.0;
                int a = 0;
                if (originalBottom < 12.0) {
                    a = (int)(12.0 - originalBottom);
                }
                y = 12 + a;
                while ((double)y > originalBottom) {
                    this.m_5974_((LevelWriter)reader, pos.m_5487_(Direction.Axis.X, x).m_5487_(Direction.Axis.Z, z).m_175288_(y + lowestY + 20), config.block().m_213972_(random, pos));
                    --y;
                }
            }
        }
    }
}

