/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.entity.eots;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.dungeon.DoorwayBlock;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.entity.ai.controller.BlankMoveControl;
import com.aetherteam.aether.entity.monster.dungeon.boss.BossNameGenerator;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.BossInfoPacket;
import com.aetherteam.nitrogen.entity.BossRoomTracker;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teamrazor.deepaether.DeepAether;
import teamrazor.deepaether.block.DoorwayPillarBlock;
import teamrazor.deepaether.entity.eots.EOTSSegment;
import teamrazor.deepaether.init.DABlocks;
import teamrazor.deepaether.init.DAEntities;
import teamrazor.deepaether.init.DAParticles;
import teamrazor.deepaether.init.DASounds;

public class EOTSController
extends Mob
implements AetherBossMob<EOTSController>,
Enemy,
IEntityAdditionalSpawnData {
    protected List<EOTSSegment> controllingSegments = new ArrayList<EOTSSegment>();
    protected List<UUID> segmentUUIDs = new ArrayList<UUID>();
    public static final int SEGMENT_COUNT = 22;
    public static final int EXTRA_SEGMENT = 4;
    private static final Music EOTS_MUSIC = new Music((Holder)DASounds.LOCUS_FOR_WINDS.getHolder().orElse(SoundEvents.f_11689_), 0, 0, true);
    private static final EntityDataAccessor<Boolean> DATA_AWAKE_ID = SynchedEntityData.m_135353_(EOTSController.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Component> DATA_BOSS_NAME_ID = SynchedEntityData.m_135353_(EOTSController.class, (EntityDataSerializer)EntityDataSerializers.f_135031_);
    private final ServerBossEvent bossFight;
    private boolean hasBeenContactedBySegment = false;
    @Nullable
    protected BossRoomTracker<EOTSController> brassDungeon;
    private int chatCooldown;
    private int soundCooldown;
    private static final UUID EOTS_BONUS_HEALTH_UUID = UUID.fromString("5a542b1e-8309-4f25-a064-610353094828");
    public static final Map<Block, Function<BlockState, BlockState>> DUNGEON_BLOCK_CONVERSIONS = new HashMap<Block, Function<BlockState, BlockState>>(Map.ofEntries(Map.entry((Block)DABlocks.LOCKED_NIMBUS_STONE.get(), blockState -> ((Block)DABlocks.NIMBUS_STONE.get()).m_49966_()), Map.entry((Block)DABlocks.TRAPPED_NIMBUS_STONE.get(), blockState -> ((Block)DABlocks.NIMBUS_STONE.get()).m_49966_()), Map.entry((Block)DABlocks.LOCKED_LIGHT_NIMBUS_STONE.get(), blockState -> ((Block)DABlocks.LIGHT_NIMBUS_STONE.get()).m_49966_()), Map.entry((Block)DABlocks.TRAPPED_LIGHT_NIMBUS_STONE.get(), blockState -> ((Block)DABlocks.LIGHT_NIMBUS_STONE.get()).m_49966_()), Map.entry((Block)DABlocks.LOCKED_NIMBUS_PILLAR.get(), blockState -> ((Block)DABlocks.NIMBUS_PILLAR.get()).m_49966_()), Map.entry((Block)DABlocks.TRAPPED_NIMBUS_PILLAR.get(), blockState -> ((Block)DABlocks.NIMBUS_PILLAR.get()).m_49966_()), Map.entry((Block)DABlocks.LOCKED_LIGHT_NIMBUS_PILLAR.get(), blockState -> ((Block)DABlocks.LIGHT_NIMBUS_PILLAR.get()).m_49966_()), Map.entry((Block)DABlocks.TRAPPED_LIGHT_NIMBUS_PILLAR.get(), blockState -> ((Block)DABlocks.LIGHT_NIMBUS_PILLAR.get()).m_49966_()), Map.entry((Block)DABlocks.BOSS_DOORWAY_NIMBUS_STONE.get(), blockState -> Blocks.f_50016_.m_49966_()), Map.entry((Block)DABlocks.BOSS_DOORWAY_NIMBUS_PILLAR.get(), blockState -> Blocks.f_50016_.m_49966_()), Map.entry((Block)DABlocks.LOCKED_SKYROOT_PLANKS.get(), blockState -> ((Block)AetherBlocks.SKYROOT_PLANKS.get()).m_49966_()), Map.entry((Block)DABlocks.TRAPPED_SKYROOT_PLANKS.get(), blockState -> ((Block)AetherBlocks.SKYROOT_PLANKS.get()).m_49966_()), Map.entry((Block)DABlocks.TREASURE_DOORWAY_NIMBUS_STONE.get(), blockState -> (BlockState)((TrapDoorBlock)AetherBlocks.SKYROOT_TRAPDOOR.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))))));

    public EOTSController(EntityType<? extends EOTSController> type, Level level) {
        super(type, level);
        this.f_21342_ = new BlankMoveControl((Mob)this);
        this.bossFight = (ServerBossEvent)new ServerBossEvent(this.getBossName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7005_(true);
        this.setBossFight(false);
        this.f_21364_ = 50;
        this.m_19915_(0.0f, 0.0f);
        this.f_19794_ = true;
        this.m_21530_();
        this.soundCooldown = 0;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag compoundTag) {
        this.setBossName((Component)EOTSController.generateEOTSName(this.m_217043_()));
        this.m_6027_(Mth.m_14107_((double)this.m_20185_()), this.m_20186_(), Mth.m_14107_((double)this.m_20189_()));
        return spawnData;
    }

    public static MutableComponent generateEOTSName(RandomSource random) {
        MutableComponent result = BossNameGenerator.generateBossName((RandomSource)random);
        return result.m_7220_((Component)Component.m_237115_((String)"gui.deep_aether.eots.title"));
    }

    @NotNull
    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 220.1).m_22268_(Attributes.f_22277_, 96.0);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_AWAKE_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_BOSS_NAME_ID, (Object)Component.m_237113_((String)"EOTS"));
    }

    public void m_8119_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8119_();
        if (!this.isAwake() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            this.m_6710_(null);
            this.playBlowingSound();
            if (this.m_9236_().m_5776_()) {
                this.spawnParticles();
            }
        }
        this.evaporate();
        if (this.hasBeenContactedBySegment && this.isAwake() && this.segmentUUIDs.isEmpty()) {
            this.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), 255.1f);
        }
        if (this.getChatCooldown() > 0) {
            --this.chatCooldown;
        }
    }

    private void playBlowingSound() {
        if (this.soundCooldown != 0) {
            --this.soundCooldown;
        } else {
            this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)DASounds.EOTS_BLOWING.get(), SoundSource.HOSTILE, 1.0f, 1.0f, true);
            this.soundCooldown = 50;
        }
    }

    public boolean m_217066_(LivingEntity pEntity) {
        return false;
    }

    public boolean m_5789_() {
        return !this.bossFight.m_8323_();
    }

    private void evaporate() {
        Pair minMax = this.getDefaultBounds(this);
        super.evaporate((Mob)this, (BlockPos)minMax.getLeft(), (BlockPos)minMax.getRight(), blockState -> true);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.getDungeon() != null) {
            this.getDungeon().trackPlayers();
            if (this.isBossFight() && (this.getDungeon().dungeonPlayers().isEmpty() || !this.getDungeon().isBossWithinRoom())) {
                this.reset();
            }
        }
        this.trackDungeon();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        if (!this.isBossFight() && source.m_7640_() != null && source.m_7640_().m_6095_() == EntityType.f_20532_) {
            this.start();
            return false;
        }
        if (source.m_7640_() != null && source.m_7640_().m_6095_() == DAEntities.EOTS_SEGMENT.get()) {
            this.f_19802_ = 0;
            return super.m_6469_(source, amount);
        }
        if (source.m_7639_() != null && source.m_7639_().m_7306_((Entity)this) && this.isBossFight()) {
            this.f_19802_ = 0;
            return super.m_6469_(source, amount);
        }
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    private void start() {
        this.getAwakenSound();
        this.m_5496_(this.getAwakenSound(), 2.5f, 1.0f / (this.m_217043_().m_188501_() * 0.2f + 0.9f));
        this.setAwake(true);
        this.setBossFight(true);
        this.closeRoom();
        this.m_146884_(this.m_20182_().m_82492_(0.0, 6.0, 0.0));
        this.spawnSegments();
        this.m_6842_(true);
        this.setHasBeenContactedBySegment();
        AetherEventDispatch.onBossFightStart((Entity)this, this.getDungeon());
    }

    public void closeRoom() {
        if (this.getDungeon() != null) {
            this.getDungeon().modifyRoom(state -> {
                if (state.m_60734_() instanceof DoorwayBlock || state.m_60734_() instanceof DoorwayPillarBlock) {
                    return (BlockState)state.m_61124_((Property)DoorwayBlock.INVISIBLE, (Comparable)Boolean.valueOf(false));
                }
                return null;
            });
        }
    }

    public void reset() {
        this.m_20256_(Vec3.f_82478_);
        this.setAwake(false);
        this.setBossFight(false);
        this.m_6842_(false);
        this.m_6710_(null);
        AttributeInstance instance = this.m_21051_(Attributes.f_22276_);
        if (instance != null) {
            instance.m_22120_(EOTS_BONUS_HEALTH_UUID);
        }
        if (this.getDungeon() != null) {
            this.m_146884_(this.getDungeon().originCoordinates());
            this.getDungeon().modifyRoom(state -> state.m_60734_() instanceof DoorwayBlock || state.m_60734_() instanceof DoorwayPillarBlock ? (BlockState)state.m_61124_((Property)DoorwayBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)) : null);
        }
        this.m_6842_(false);
        this.removeAllSegments();
        AetherEventDispatch.onBossFightStop((Entity)this, this.getDungeon());
    }

    public void m_6667_(@NotNull DamageSource source) {
        this.m_20256_(Vec3.f_82478_);
        this.m_146884_(this.m_20182_().m_82520_(0.0, 8.0, 0.0));
        if (this.m_9236_() instanceof ServerLevel) {
            this.removeAllSegments();
            this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
            if (this.getDungeon() != null) {
                this.getDungeon().grantAdvancements(source);
                this.tearDownRoom();
            }
        }
        super.m_6667_(source);
    }

    public void tearDownRoom() {
        if (this.getDungeon() != null) {
            AABB aabb = this.getDungeon().roomBounds();
            for (BlockPos pos : BlockPos.m_121976_((int)((int)aabb.f_82288_ - 10), (int)((int)aabb.f_82289_), (int)((int)aabb.f_82290_ - 10), (int)((int)aabb.f_82291_ + 10), (int)((int)aabb.f_82292_), (int)((int)aabb.f_82293_ + 10))) {
                BlockState state = this.m_9236_().m_8055_(pos);
                BlockState newState = this.convertBlock(state);
                if (newState == null) continue;
                this.m_9236_().m_7731_(pos, newState, 3);
            }
        }
    }

    private static AttributeModifier getBonusHealth(int extra) {
        return new AttributeModifier(EOTS_BONUS_HEALTH_UUID, "eots_health_multiplayer", (double)((float)extra * 10.0f), AttributeModifier.Operation.ADDITION);
    }

    protected void spawnSegments() {
        int extra = (this.bossFight.m_8324_().size() - 1) * 4;
        AttributeInstance instance = this.m_21051_(Attributes.f_22276_);
        if (instance != null) {
            instance.m_22130_(EOTSController.getBonusHealth(extra));
            instance.m_22118_(EOTSController.getBonusHealth(extra));
            this.m_21153_(this.m_21233_());
        }
        EOTSSegment oldSegment = new EOTSSegment(this.m_9236_(), this);
        this.segmentUUIDs.add(oldSegment.m_20148_());
        for (int i = 0; i < 21 + extra; ++i) {
            oldSegment = new EOTSSegment(this.m_9236_(), oldSegment, this);
        }
    }

    private void removeAllSegments() {
        for (UUID segmentUUID : this.segmentUUIDs) {
            EOTSSegment segment = (EOTSSegment)((ServerLevel)this.m_9236_()).m_8791_(segmentUUID);
            if (segment == null) continue;
            segment.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.segmentUUIDs = new ArrayList<UUID>();
        this.controllingSegments = new ArrayList<EOTSSegment>();
        this.hasBeenContactedBySegment = false;
    }

    public void spawnParticles() {
        for (int i = 0; i < 2; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)DAParticles.EOTS_PRE_FIGHT.get(), this.m_20185_() - 1.1, this.m_20186_() + 0.25 + (double)(this.f_19796_.m_188501_() * 2.0f), this.m_20189_() + 0.3, 0.0, 0.001 + (double)this.f_19796_.m_188501_() * 0.002, 0.0);
        }
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.m_9236_().m_5776_() && this.getChatCooldown() <= 0) {
            pPlayer.m_213846_((Component)Component.m_237115_((String)"gui.deep_aether.eots.message.interact"));
            this.setChatCooldown(15);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public int getChatCooldown() {
        return this.chatCooldown;
    }

    public void setChatCooldown(int cooldown) {
        this.chatCooldown = cooldown;
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    public void m_6043_() {
    }

    @Nullable
    public BlockState convertBlock(BlockState state) {
        return DUNGEON_BLOCK_CONVERSIONS.getOrDefault(state.m_60734_(), blockState -> null).apply(state);
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new BossInfoPacket.Display(this.bossFight.m_18860_(), this.m_19879_()), (ServerPlayer)player);
        if (this.getDungeon() == null || this.getDungeon().isPlayerTracked((Player)player)) {
            this.bossFight.m_6543_(player);
            AetherEventDispatch.onBossFightPlayerAdd((Entity)this, this.getDungeon(), (ServerPlayer)player);
        }
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new BossInfoPacket.Remove(this.bossFight.m_18860_(), this.m_19879_()), (ServerPlayer)player);
        this.bossFight.m_6539_(player);
        AetherEventDispatch.onBossFightPlayerRemove((Entity)this, this.getDungeon(), (ServerPlayer)player);
    }

    public void onDungeonPlayerAdded(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6543_(serverPlayer);
            AetherEventDispatch.onBossFightPlayerAdd((Entity)this, this.getDungeon(), (ServerPlayer)serverPlayer);
        }
    }

    public void onDungeonPlayerRemoved(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6539_(serverPlayer);
            AetherEventDispatch.onBossFightPlayerRemove((Entity)this, this.getDungeon(), (ServerPlayer)serverPlayer);
        }
    }

    protected void setHasBeenContactedBySegment() {
        this.hasBeenContactedBySegment = true;
        this.m_6842_(true);
    }

    public boolean isAwake() {
        return (Boolean)this.m_20088_().m_135370_(DATA_AWAKE_ID);
    }

    public void setAwake(boolean awake) {
        this.m_20088_().m_135381_(DATA_AWAKE_ID, (Object)awake);
    }

    public Component getBossName() {
        return (Component)this.m_20088_().m_135370_(DATA_BOSS_NAME_ID);
    }

    public void setBossName(Component component) {
        this.m_20088_().m_135381_(DATA_BOSS_NAME_ID, (Object)component);
        this.bossFight.m_6456_(component);
    }

    @Nullable
    public BossRoomTracker<EOTSController> getDungeon() {
        return this.brassDungeon;
    }

    public void setDungeon(@Nullable BossRoomTracker<EOTSController> dungeon) {
        this.brassDungeon = dungeon;
    }

    public boolean isBossFight() {
        return this.bossFight.m_8323_();
    }

    public void setBossFight(boolean isFighting) {
        this.bossFight.m_8321_(isFighting);
    }

    @Nullable
    public ResourceLocation getBossBarTexture() {
        return DeepAether.getResource("textures/gui/sprites/boss_bar/eots.png");
    }

    @Nullable
    public Music getBossMusic() {
        return EOTS_MUSIC;
    }

    public int getDeathScore() {
        return this.f_20897_;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.setBossName(name);
    }

    @NotNull
    protected SoundEvent getAwakenSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SLIDER_AWAKEN.get();
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public boolean m_6779_(@NotNull LivingEntity target) {
        return false;
    }

    public boolean m_6128_() {
        return true;
    }

    public float m_146908_() {
        return 0.0f;
    }

    protected boolean m_7341_(@NotNull Entity vehicle) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_147223_() {
        return true;
    }

    protected boolean m_6129_() {
        return false;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_146890_() {
        return false;
    }

    @NotNull
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        this.addBossSaveData(tag);
        tag.m_128379_("Awake", this.isAwake());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.readBossSaveData(tag);
        if (tag.m_128441_("Awake")) {
            this.setAwake(tag.m_128471_("Awake"));
        }
    }

    public void readBossSaveData(CompoundTag tag) {
        Tag tag2;
        MutableComponent name;
        if (tag.m_128441_("BossName") && (name = Component.Serializer.m_130701_((String)tag.m_128461_("BossName"))) != null) {
            this.setBossName((Component)name);
        }
        if (tag.m_128441_("BossFight")) {
            this.setBossFight(tag.m_128471_("BossFight"));
        }
        if (tag.m_128441_("Dungeon") && (tag2 = tag.m_128423_("Dungeon")) instanceof CompoundTag) {
            CompoundTag dungeonTag = (CompoundTag)tag2;
            this.setDungeon((BossRoomTracker<EOTSController>)BossRoomTracker.readAdditionalSaveData((CompoundTag)dungeonTag, (Mob)this));
            if (this.getDungeon() != null) {
                this.m_146884_(this.getDungeon().originCoordinates());
            }
            if (this.isBossFight()) {
                this.m_146884_(this.m_20182_().m_82492_(0.0, 6.0, 0.0));
            }
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        this.addBossSaveData(tag);
        buffer.m_130079_(tag);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        CompoundTag tag = additionalData.m_130260_();
        if (tag != null) {
            this.readBossSaveData(tag);
        }
    }
}

