/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.mixins.common;

import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.utils.ModUtils;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class, LivingEntity.class})
public abstract class EntityBelowWorldMixin {
    @Inject(method={"onBelowWorld"}, at={@At(value="HEAD")}, cancellable=true)
    private void adastra$onBelowWorld(CallbackInfo ci) {
        Entity entity = (Entity)this;
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!PlanetApi.API.isSpace((Level)serverLevel)) {
            return;
        }
        Planet planet = PlanetApi.API.getPlanet((ResourceKey<Level>)serverLevel.m_46472_());
        if (planet == null) {
            return;
        }
        planet.getOrbitPlanet().ifPresent(targetLevelKey -> {
            MinecraftServer server = serverLevel.m_7654_();
            ServerLevel targetLevel = server.m_129880_(targetLevelKey);
            List passengers = entity.m_20197_();
            entity.m_6034_(entity.m_20185_(), (double)AdAstraConfig.atmosphereLeave, entity.m_20189_());
            Entity teleportedEntity = ModUtils.teleportToDimension(entity, targetLevel);
            for (Entity passenger : passengers) {
                Entity teleportedPassenger = ModUtils.teleportToDimension(passenger, targetLevel);
                teleportedPassenger.m_20329_(teleportedEntity);
            }
            ci.cancel();
        });
    }
}

