/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.world;

import com.min01.unleashed.network.UnleashedNetwork;
import com.min01.unleashed.network.UpdateStarfieldPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class UnleashedSavedData
extends SavedData {
    public static final String NAME = "unleashed_data";
    protected boolean isStarfield;
    protected boolean isJellyfishSpawned;
    protected final Map<UUID, ResourceKey<Level>> respawnDimension = new HashMap<UUID, ResourceKey<Level>>();
    protected final Map<UUID, ResourceKey<Level>> prevDimension = new HashMap<UUID, ResourceKey<Level>>();
    protected final Map<UUID, BlockPos> respawnPos = new HashMap<UUID, BlockPos>();
    protected final Map<UUID, BlockPos> prevPos = new HashMap<UUID, BlockPos>();

    public static UnleashedSavedData get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DimensionDataStorage storage = serverLevel.m_8895_();
            UnleashedSavedData data = (UnleashedSavedData)storage.m_164861_(UnleashedSavedData::load, UnleashedSavedData::new, NAME);
            return data;
        }
        return null;
    }

    public static UnleashedSavedData load(CompoundTag nbt) {
        CompoundTag tag;
        int i;
        UnleashedSavedData data = new UnleashedSavedData();
        data.setStarfield(nbt.m_128471_("isStarfield"));
        data.setJellyfishSpawned(nbt.m_128471_("isJellyfishSpawned"));
        ListTag respawnDim = nbt.m_128437_("RespawnDimension", 10);
        ListTag prevDim = nbt.m_128437_("PrevDimension", 10);
        ListTag respawnP = nbt.m_128437_("RespawnPos", 10);
        ListTag prevP = nbt.m_128437_("PrevPos", 10);
        for (i = 0; i < respawnDim.size(); ++i) {
            tag = respawnDim.m_128728_(i);
            data.setRespawnDimension(tag.m_128342_("PlayerUUID"), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("Dimension"))));
        }
        for (i = 0; i < prevDim.size(); ++i) {
            tag = prevDim.m_128728_(i);
            data.setPrevDimension(tag.m_128342_("PlayerUUID"), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("Dimension"))));
        }
        for (i = 0; i < respawnP.size(); ++i) {
            tag = respawnP.m_128728_(i);
            data.setRespawnPos(tag.m_128342_("PlayerUUID"), NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BlockPos")));
        }
        for (i = 0; i < prevP.size(); ++i) {
            tag = prevP.m_128728_(i);
            data.setRespawnPos(tag.m_128342_("PlayerUUID"), NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BlockPos")));
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128379_("isStarfield", this.isStarfield);
        nbt.m_128379_("isJellyfishSpawned", this.isJellyfishSpawned);
        ListTag respawnDim = new ListTag();
        ListTag prevDim = new ListTag();
        ListTag respawnP = new ListTag();
        ListTag prevP = new ListTag();
        this.respawnDimension.forEach((t, u) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("PlayerUUID", t);
            tag.m_128359_("Dimension", u.m_135782_().toString());
            respawnDim.add((Object)tag);
        });
        this.prevDimension.forEach((t, u) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("PlayerUUID", t);
            tag.m_128359_("Dimension", u.m_135782_().toString());
            prevDim.add((Object)tag);
        });
        this.respawnPos.forEach((t, u) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("PlayerUUID", t);
            tag.m_128365_("BlockPos", (Tag)NbtUtils.m_129224_((BlockPos)u));
            respawnP.add((Object)tag);
        });
        this.prevPos.forEach((t, u) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("PlayerUUID", t);
            tag.m_128365_("BlockPos", (Tag)NbtUtils.m_129224_((BlockPos)u));
            prevP.add((Object)tag);
        });
        nbt.m_128365_("RespawnDimension", (Tag)respawnDim);
        nbt.m_128365_("PrevDimension", (Tag)prevDim);
        nbt.m_128365_("RespawnPos", (Tag)respawnP);
        nbt.m_128365_("PrevPos", (Tag)prevP);
        return nbt;
    }

    public void setStarfield(boolean value) {
        this.isStarfield = value;
        UnleashedNetwork.sendToAll(new UpdateStarfieldPacket(value));
        this.m_77762_();
    }

    public boolean isStarfield() {
        return this.isStarfield;
    }

    public void setJellyfishSpawned(boolean value) {
        this.isJellyfishSpawned = value;
        this.m_77762_();
    }

    public boolean isJellyfishSpawned() {
        return this.isJellyfishSpawned;
    }

    public void setRespawnDimension(UUID player, ResourceKey<Level> level) {
        this.respawnDimension.put(player, level);
        this.m_77762_();
    }

    public ResourceKey<Level> getRespawnDimension(UUID player) {
        if (!this.respawnDimension.containsKey(player)) {
            return Level.f_46428_;
        }
        return this.respawnDimension.get(player);
    }

    public void setPrevDimension(UUID player, ResourceKey<Level> level) {
        this.prevDimension.put(player, level);
        this.m_77762_();
    }

    public ResourceKey<Level> getPrevDimension(UUID player) {
        if (!this.prevDimension.containsKey(player)) {
            return Level.f_46428_;
        }
        return this.prevDimension.get(player);
    }

    public void setRespawnPos(UUID player, BlockPos pos) {
        this.respawnPos.put(player, pos);
        this.m_77762_();
    }

    public BlockPos getRespawnPos(UUID player) {
        if (!this.respawnPos.containsKey(player)) {
            return BlockPos.m_274561_((double)0.0, (double)64.0, (double)0.0);
        }
        return this.respawnPos.get(player);
    }

    public void setPrevPos(UUID player, BlockPos pos) {
        this.prevPos.put(player, pos);
        this.m_77762_();
    }

    public BlockPos getPrevPos(UUID player) {
        if (!this.prevPos.containsKey(player)) {
            return BlockPos.f_121853_;
        }
        return this.prevPos.get(player);
    }
}

