/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.util;

import com.min01.unleashed.capabilities.DashCapabilityImpl;
import com.min01.unleashed.capabilities.IDashCapability;
import com.min01.unleashed.capabilities.UnleashedCapabilities;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.joml.Math;

public class UnleashedUtil {
    public static final Method GET_ENTITY = ObfuscationReflectionHelper.findMethod(Level.class, (String)"m_142646_", (Class[])new Class[0]);

    public static BlockPos getGroundPos(BlockGetter pLevel, double pX, double startY, double pZ, int belowY) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(pX, startY, pZ);
        do {
            blockpos$mutable.m_122173_(Direction.DOWN);
        } while ((pLevel.m_8055_((BlockPos)blockpos$mutable).m_60795_() || pLevel.m_8055_((BlockPos)blockpos$mutable).m_278721_() || !pLevel.m_8055_((BlockPos)blockpos$mutable).m_60838_(pLevel, (BlockPos)blockpos$mutable)) && blockpos$mutable.m_123342_() > pLevel.m_141937_());
        BlockPos pos = blockpos$mutable.m_7495_().m_6625_(belowY);
        return pos;
    }

    public static void tickDash(LivingEntity entity) {
        IDashCapability cap = (IDashCapability)entity.getCapability(UnleashedCapabilities.DASH).orElse((Object)new DashCapabilityImpl());
        cap.tick(entity);
    }

    public static void setDashTick(LivingEntity entity, int tick) {
        IDashCapability cap = (IDashCapability)entity.getCapability(UnleashedCapabilities.DASH).orElse((Object)new DashCapabilityImpl());
        cap.setDashTick(tick);
    }

    public static boolean isDash(LivingEntity entity) {
        IDashCapability cap = (IDashCapability)entity.getCapability(UnleashedCapabilities.DASH).orElse((Object)new DashCapabilityImpl());
        return cap.isDash();
    }

    public static int getDashTick(LivingEntity entity) {
        IDashCapability cap = (IDashCapability)entity.getCapability(UnleashedCapabilities.DASH).orElse((Object)new DashCapabilityImpl());
        return cap.getDashTick();
    }

    public static Iterable<Entity> getAllEntities(Level level) {
        try {
            LevelEntityGetter entities = (LevelEntityGetter)GET_ENTITY.invoke((Object)level, new Object[0]);
            return entities.m_142273_();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Vec2 lookAt(Vec3 startPos, Vec3 pos) {
        Vec3 vec3 = startPos;
        double d0 = pos.f_82479_ - vec3.f_82479_;
        double d1 = pos.f_82480_ - vec3.f_82480_;
        double d2 = pos.f_82481_ - vec3.f_82481_;
        double d3 = Math.sqrt((double)(d0 * d0 + d2 * d2));
        float xRot = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
        float yRot = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        return new Vec2(xRot, yRot);
    }

    public static Vec3 getSpreadPosition(Level level, Vec3 startPos, double range) {
        double x = startPos.f_82479_ + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * range + 0.5;
        double y = startPos.f_82480_ + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * range + 0.5;
        double z = startPos.f_82481_ + (level.f_46441_.m_188500_() - level.f_46441_.m_188500_()) * range + 0.5;
        return new Vec3(x, y, z);
    }

    public static Vec3 getSpreadPosition(Entity entity, Vec3 range) {
        double x = entity.m_20185_() + (entity.f_19853_.f_46441_.m_188500_() - entity.f_19853_.f_46441_.m_188500_()) * range.f_82479_ + 0.5;
        double y = entity.m_20186_() + (entity.f_19853_.f_46441_.m_188500_() - entity.f_19853_.f_46441_.m_188500_()) * range.f_82480_ + 0.5;
        double z = entity.m_20189_() + (entity.f_19853_.f_46441_.m_188500_() - entity.f_19853_.f_46441_.m_188500_()) * range.f_82481_ + 0.5;
        return new Vec3(x, y, z);
    }

    public static Vec3 getSpreadPosition(Entity entity, double range) {
        double x = entity.m_20185_() + (entity.f_19853_.f_46441_.m_188500_() - entity.f_19853_.f_46441_.m_188500_()) * range + 0.5;
        double y = entity.m_20186_() + (entity.f_19853_.f_46441_.m_188500_() - entity.f_19853_.f_46441_.m_188500_()) * range + 0.5;
        double z = entity.m_20189_() + (entity.f_19853_.f_46441_.m_188500_() - entity.f_19853_.f_46441_.m_188500_()) * range + 0.5;
        return new Vec3(x, y, z);
    }

    public static Entity teleportEntityToDimension(Entity entity, ServerLevel serverLevel, BlockPos pos) {
        if (entity.f_19853_.m_46472_() != serverLevel.m_46472_()) {
            entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, entity.m_146908_(), 0.0f);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.m_8999_(serverLevel, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, entity.m_146908_(), entity.m_146909_());
            return serverPlayer;
        }
        entity.m_19877_();
        entity.m_5489_(serverLevel);
        Entity teleportedEntity = entity.m_6095_().m_20615_((Level)serverLevel);
        if (teleportedEntity == null) {
            return entity;
        }
        teleportedEntity.m_20361_(entity);
        teleportedEntity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, entity.m_146908_(), entity.m_146909_());
        teleportedEntity.m_5616_(entity.m_146908_());
        serverLevel.m_143334_(teleportedEntity);
        return teleportedEntity;
    }

    public static void getClientLevel(Consumer<Level> consumer) {
        ((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT)).filter(ClientLevel.class::isInstance).ifPresent(level -> consumer.accept((Level)level));
    }

    public static Vec3 fromToVector(Vec3 from, Vec3 to, float scale) {
        Vec3 motion = to.m_82546_(from).m_82541_();
        return motion.m_82490_((double)scale);
    }

    public static void createRandomSpherePos(RandomSource random, float radius, Consumer<Vec3> consumer) {
        float x = random.m_188501_();
        float y = random.m_188501_();
        Vec3 pos = new Vec3((double)radius, 0.0, 0.0);
        pos = pos.m_82524_(y * 2.0f * (float)java.lang.Math.PI);
        pos = pos.m_82496_(x * 2.0f * (float)java.lang.Math.PI);
        consumer.accept(pos);
    }

    public static void createSphere(float radius, Consumer<Vec3> consumer) {
        for (float y = 0.0f; y < 1.0f; y += 0.05f) {
            for (float x = 0.0f; x < 1.0f; x += 0.05f) {
                Vec3 pos = new Vec3((double)radius, 0.0, 0.0);
                pos = pos.m_82524_(y * 2.0f * (float)java.lang.Math.PI);
                pos = pos.m_82496_(x * 2.0f * (float)java.lang.Math.PI);
                consumer.accept(pos);
            }
        }
    }

    public static Vec3 getLookPos(Vec2 rotation, Vec3 position, double left, double up, double forwards) {
        Vec2 vec2 = rotation;
        Vec3 vec3 = position;
        float f = Mth.m_14089_((float)((vec2.f_82471_ + 90.0f) * ((float)java.lang.Math.PI / 180)));
        float f1 = Mth.m_14031_((float)((vec2.f_82471_ + 90.0f) * ((float)java.lang.Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(-vec2.f_82470_ * ((float)java.lang.Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-vec2.f_82470_ * ((float)java.lang.Math.PI / 180)));
        float f4 = Mth.m_14089_((float)((-vec2.f_82470_ + 90.0f) * ((float)java.lang.Math.PI / 180)));
        float f5 = Mth.m_14031_((float)((-vec2.f_82470_ + 90.0f) * ((float)java.lang.Math.PI / 180)));
        Vec3 vec31 = new Vec3((double)(f * f2), (double)f3, (double)(f1 * f2));
        Vec3 vec32 = new Vec3((double)(f * f4), (double)f5, (double)(f1 * f4));
        Vec3 vec33 = vec31.m_82537_(vec32).m_82490_(-1.0);
        double d0 = vec31.f_82479_ * forwards + vec32.f_82479_ * up + vec33.f_82479_ * left;
        double d1 = vec31.f_82480_ * forwards + vec32.f_82480_ * up + vec33.f_82480_ * left;
        double d2 = vec31.f_82481_ * forwards + vec32.f_82481_ * up + vec33.f_82481_ * left;
        return new Vec3(vec3.f_82479_ + d0, vec3.f_82480_ + d1, vec3.f_82481_ + d2);
    }

    public static <T extends Entity> T getEntityByUUID(Level level, UUID uuid) {
        try {
            LevelEntityGetter entities = (LevelEntityGetter)GET_ENTITY.invoke((Object)level, new Object[0]);
            return (T)((Entity)entities.m_142694_(uuid));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isNight(Level level) {
        return level.m_8044_() % 24000L >= 13000L;
    }
}

