/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.util;

import com.min01.unleashed.entity.ITrail;
import com.min01.unleashed.misc.UnleashedRenderType;
import com.min01.unleashed.shader.ExtendedPostChain;
import com.min01.unleashed.shader.UnleashedShaders;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class UnleashedClientUtil {
    public static final Minecraft MC = Minecraft.m_91087_();
    public static final Matrix4f INVERSE_MAT = new Matrix4f();

    public static void animateHead(ModelPart head, float netHeadYaw, float headPitch) {
        head.f_104204_ = (float)((double)head.f_104204_ + Math.toRadians(netHeadYaw));
        head.f_104203_ = (float)((double)head.f_104203_ + Math.toRadians(headPitch));
    }

    public static void applyBlackhole(PoseStack mtx, float frameTime, float tickCount) {
        Minecraft minecraft = MC;
        ExtendedPostChain shaderChain = UnleashedShaders.getBlackhole();
        EffectInstance shader = shaderChain.getMainShader();
        if (shader != null) {
            shader.m_108954_("ImageSampler", () -> minecraft.m_91097_().m_118506_(new ResourceLocation("bossesunleashed", "textures/misc/blue_noise.png")).m_117963_());
            shader.m_108960_("iResolution").m_142326_(minecraft.m_91268_().m_85441_(), minecraft.m_91268_().m_85442_());
            shader.m_108960_("InverseTransformMatrix").m_5679_(UnleashedClientUtil.getInverseTransformMatrix(INVERSE_MAT, mtx.m_85850_().m_252922_()));
            shader.m_108960_("iTime").m_5985_(tickCount / 20.0f);
            shaderChain.m_110023_(frameTime);
            minecraft.m_91385_().m_83947_(false);
        }
    }

    public static void applyWormhole(PoseStack mtx, float frameTime) {
        Minecraft minecraft = MC;
        ExtendedPostChain shaderChain = UnleashedShaders.getWormhole();
        EffectInstance shader = shaderChain.getMainShader();
        if (shader != null) {
            shader.m_108960_("iResolution").m_142326_(minecraft.m_91268_().m_85441_(), minecraft.m_91268_().m_85442_());
            shader.m_108960_("InverseTransformMatrix").m_5679_(UnleashedClientUtil.getInverseTransformMatrix(INVERSE_MAT, mtx.m_85850_().m_252922_()));
            shader.m_108960_("ProjectionMatrix").m_5679_(RenderSystem.getProjectionMatrix());
            shader.m_108960_("ViewMatrix").m_5679_(mtx.m_85850_().m_252922_());
            shader.m_108960_("iTime").m_5985_(((float)(minecraft.f_91073_.m_46467_() % 2400000L) + frameTime) / 20.0f);
            shaderChain.m_110023_(frameTime);
            minecraft.m_91385_().m_83947_(false);
        }
    }

    public static void applyStarfield(PoseStack mtx, float frameTime) {
        Minecraft minecraft = MC;
        ExtendedPostChain shaderChain = UnleashedShaders.getStarfield();
        EffectInstance shader = shaderChain.getMainShader();
        if (shader != null) {
            shader.m_108960_("iResolution").m_142326_(minecraft.m_91268_().m_85441_(), minecraft.m_91268_().m_85442_());
            shader.m_108960_("InverseTransformMatrix").m_5679_(UnleashedClientUtil.getInverseTransformMatrix(INVERSE_MAT, mtx.m_85850_().m_252922_()));
            shader.m_108960_("iTime").m_5985_(((float)(minecraft.f_91073_.m_46467_() % 2400000L) + frameTime) / 20.0f);
            shaderChain.m_110023_(frameTime);
            minecraft.m_91385_().m_83947_(false);
        }
    }

    public static void applyGalaxy(PoseStack mtx, float frameTime, float tickCount, float scale, Vector3f camForward) {
        Minecraft minecraft = MC;
        ExtendedPostChain shaderChain = UnleashedShaders.getGalaxy();
        EffectInstance shader = shaderChain.getMainShader();
        if (shader != null) {
            shader.m_108960_("iResolution").m_142326_(minecraft.m_91268_().m_85441_(), minecraft.m_91268_().m_85442_());
            shader.m_108960_("InverseTransformMatrix").m_5679_(UnleashedClientUtil.getInverseTransformMatrix(INVERSE_MAT, mtx.m_85850_().m_252922_()));
            shader.m_108960_("iTime").m_5985_(tickCount / 20.0f);
            shader.m_108960_("Scale").m_5985_(scale);
            shader.m_108960_("CamForward").m_5889_(camForward.x, camForward.y, camForward.z);
            shaderChain.m_110023_(frameTime);
            minecraft.m_91385_().m_83947_(false);
        }
    }

    public static void applyShockwave(PoseStack mtx, float frameTime, int tickCount) {
        Minecraft minecraft = MC;
        ExtendedPostChain shaderChain = UnleashedShaders.getShockwave();
        EffectInstance shader = shaderChain.getMainShader();
        if (shader != null) {
            shader.m_108960_("iResolution").m_142326_(minecraft.m_91268_().m_85441_(), minecraft.m_91268_().m_85442_());
            shader.m_108960_("InverseTransformMatrix").m_5679_(UnleashedClientUtil.getInverseTransformMatrix(INVERSE_MAT, mtx.m_85850_().m_252922_()));
            shader.m_108960_("ProjectionMat").m_5679_(RenderSystem.getProjectionMatrix());
            shader.m_108960_("ViewMat").m_5679_(mtx.m_85850_().m_252922_());
            shader.m_108960_("iTime").m_5985_((float)tickCount / 20.0f);
            shaderChain.m_110023_(frameTime);
            minecraft.m_91385_().m_83947_(false);
        }
    }

    public static void drawQuad(PoseStack stack, VertexConsumer consumer, float size, int packedLightIn, Vec3 color, float alpha) {
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 1.0f;
        float maxV = 1.0f;
        PoseStack.Pose matrixstack$entry = stack.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        UnleashedClientUtil.drawVertex(matrix4f, matrix3f, consumer, size, size, 0.0f, minU, minV, color, alpha, packedLightIn);
        UnleashedClientUtil.drawVertex(matrix4f, matrix3f, consumer, size, -size, 0.0f, minU, maxV, color, alpha, packedLightIn);
        UnleashedClientUtil.drawVertex(matrix4f, matrix3f, consumer, -size, -size, 0.0f, maxU, maxV, color, alpha, packedLightIn);
        UnleashedClientUtil.drawVertex(matrix4f, matrix3f, consumer, -size, size, 0.0f, maxU, minV, color, alpha, packedLightIn);
    }

    public static void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, Vec3 color, float alpha, int packedLightIn) {
        vertexBuilder.m_252986_(matrix, offsetX, offsetY, offsetZ).m_85950_((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_, alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static Matrix4f getInverseTransformMatrix(Matrix4f outMat, Matrix4f modelView) {
        return outMat.identity().mul((Matrix4fc)RenderSystem.getProjectionMatrix()).mul((Matrix4fc)modelView).invert();
    }

    public static void renderTrail(ITrail entityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, float trailR, float trailG, float trailB, float trailA, int sampleSize, float trailHeight) {
        Camera camera = UnleashedClientUtil.MC.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        Vec3 drawFrom = entityIn.getTrailPosition(0, partialTicks);
        VertexConsumer vertexconsumer = bufferIn.m_6299_(UnleashedRenderType.eyesFix(new ResourceLocation("bossesunleashed", "textures/misc/trail.png")));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = entityIn.getTrailPosition(samples, partialTicks);
            float u1 = (float)samples / (float)sampleSize;
            float u2 = u1 + 1.0f / (float)sampleSize;
            Vec3 draw1 = drawFrom;
            Vec3 draw2 = sample;
            Vec3 segmentDir = draw2.m_82546_(draw1).m_82541_();
            Vec3 midPoint = draw1.m_82549_(draw2).m_82490_(0.5);
            Vec3 toCamera = cameraPos.m_82546_(midPoint).m_82541_();
            Vec3 perpendicular = segmentDir.m_82537_(toCamera).m_82541_().m_82490_((double)trailHeight);
            Vec3 v1Bottom = draw1.m_82546_(perpendicular);
            Vec3 v1Top = draw1.m_82549_(perpendicular);
            Vec3 v2Bottom = draw2.m_82546_(perpendicular);
            Vec3 v2Top = draw2.m_82549_(perpendicular);
            PoseStack.Pose pose = poseStack.m_85850_();
            Matrix4f matrix4f = pose.m_252922_();
            Matrix3f matrix3f = pose.m_252943_();
            vertexconsumer.m_252986_(matrix4f, (float)v1Bottom.f_82479_, (float)v1Bottom.f_82480_, (float)v1Bottom.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u1, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)v2Bottom.f_82479_, (float)v2Bottom.f_82480_, (float)v2Bottom.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)v2Top.f_82479_, (float)v2Top.f_82480_, (float)v2Top.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)v1Top.f_82479_, (float)v1Top.f_82480_, (float)v1Top.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            drawFrom = sample;
        }
    }
}

