/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.network;

import com.min01.unleashed.event.ClientEventHandlerForge;
import com.min01.unleashed.misc.UnleashedBossBarType;
import com.min01.unleashed.util.UnleashedUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateBossBarPacket {
    private final UUID bossBar;
    private final UUID entity;
    private final UnleashedBossBarType barType;

    public UpdateBossBarPacket(UUID bossBar, UUID entity, UnleashedBossBarType barType) {
        this.bossBar = bossBar;
        this.entity = entity;
        this.barType = barType;
    }

    public UpdateBossBarPacket(FriendlyByteBuf buf) {
        this.bossBar = buf.m_130259_();
        this.entity = buf.m_130259_();
        this.barType = UnleashedBossBarType.values()[buf.readInt()];
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.bossBar);
        buf.m_130077_(this.entity);
        buf.writeInt(this.barType.ordinal());
    }

    public static class Handler {
        public static boolean onMessage(UpdateBossBarPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (message.barType == UnleashedBossBarType.NONE) {
                    ClientEventHandlerForge.BOSS_BAR_MAP.remove(message.bossBar);
                    ClientEventHandlerForge.BOSS_MAP.remove(message.bossBar);
                } else {
                    UnleashedUtil.getClientLevel(level -> {
                        ClientEventHandlerForge.BOSS_BAR_MAP.put(message.bossBar, message.barType);
                        Object entity = UnleashedUtil.getEntityByUUID(level, message.entity);
                        if (entity != null) {
                            ClientEventHandlerForge.BOSS_MAP.put(message.bossBar, (Entity)entity);
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

