/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.network;

import com.min01.unleashed.misc.UnleashedEntityDataSerializers;
import com.min01.unleashed.shader.UnleashedShaderEffects;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class AddShaderEffectPacket {
    private final ResourceKey<Level> dimension;
    private final String name;
    private final Vec3 pos;
    private final int lifeTime;
    private final float scale;

    public AddShaderEffectPacket(ResourceKey<Level> dimension, String name, Vec3 pos, int lifeTime, float scale) {
        this.dimension = dimension;
        this.name = name;
        this.pos = pos;
        this.lifeTime = lifeTime;
        this.scale = scale;
    }

    public AddShaderEffectPacket(FriendlyByteBuf buf) {
        this.dimension = buf.m_236801_(Registries.f_256858_);
        this.name = buf.m_130277_();
        this.pos = UnleashedEntityDataSerializers.readVec3((ByteBuf)buf);
        this.lifeTime = buf.readInt();
        this.scale = buf.readFloat();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_236858_(this.dimension);
        buf.m_130070_(this.name);
        UnleashedEntityDataSerializers.writeVec3(buf, this.pos);
        buf.writeInt(this.lifeTime);
        buf.writeFloat(this.scale);
    }

    public static class Handler {
        public static boolean onMessage(AddShaderEffectPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    UnleashedShaderEffects.EFFECTS.add(new UnleashedShaderEffects.ShaderEffect(message.dimension, message.name, message.pos, message.lifeTime, message.scale));
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

