/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.mixin;

import com.min01.unleashed.entity.IShaderEffect;
import com.min01.unleashed.shader.UnleashedShaderEffects;
import com.min01.unleashed.util.UnleashedClientUtil;
import com.min01.unleashed.util.UnleashedUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=-10000)
public class MixinLevelRenderer {
    @Inject(at={@At(value="TAIL")}, method={"renderLevel"})
    private void renderLevel(PoseStack mtx, float frameTime, long nanoTime, boolean renderOutline, Camera camera, GameRenderer gameRenderer, LightTexture light, Matrix4f projMat, CallbackInfo ci) {
        Vec3 camPos = camera.m_90583_();
        RenderSystem.depthMask((boolean)false);
        new ArrayList<UnleashedShaderEffects.ShaderEffect>(UnleashedShaderEffects.EFFECTS).forEach(t -> {
            if (UnleashedClientUtil.MC.f_91073_.m_46472_() == t.dimension) {
                Vec3 worldPos = t.pos;
                Vec3 pos = worldPos.m_82546_(camPos);
                mtx.m_85836_();
                mtx.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                if (t.name.equals("Shockwave")) {
                    UnleashedClientUtil.applyShockwave(mtx, frameTime, t.tickCount);
                }
                mtx.m_85849_();
            }
        });
        for (Entity entity : UnleashedUtil.getAllEntities((Level)UnleashedClientUtil.MC.f_91073_)) {
            IShaderEffect effect;
            if (!(entity instanceof IShaderEffect) || !(effect = (IShaderEffect)entity).shouldApplyEffect()) continue;
            mtx.m_85836_();
            if (effect.getEffetName().equals("Galaxy")) {
                pos = effect.getEffectPosition(entity).m_82546_(camPos);
                float scale = effect.getEffectScale() * 0.1f;
                mtx.m_85837_(pos.f_82479_, pos.f_82480_ + (double)effect.getOffset(), pos.f_82481_);
                Vector3f vector3f = camera.m_253058_();
                if (effect.cameraRotation()) {
                    mtx.m_252781_(camera.m_253121_());
                    mtx.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    vector3f = camera.m_253028_();
                }
                UnleashedClientUtil.applyGalaxy(mtx, frameTime, effect.getEffectTickCount(), scale, vector3f);
            } else if (effect.getEffetName().equals("Wormhole")) {
                pos = effect.getEffectPosition(entity).m_82546_(camPos);
                mtx.m_85837_(pos.f_82479_, pos.f_82480_ + (double)effect.getOffset(), pos.f_82481_);
                UnleashedClientUtil.applyWormhole(mtx, frameTime);
            } else if (effect.getEffetName().equals("Blackhole")) {
                pos = effect.getEffectPosition(entity).m_82546_(camPos);
                mtx.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                UnleashedClientUtil.applyBlackhole(mtx, frameTime, effect.getEffectTickCount());
            }
            mtx.m_85849_();
        }
        RenderSystem.depthMask((boolean)true);
    }
}

