/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.misc;

import com.min01.unleashed.util.UnleashedClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AfterImage<T extends LivingEntity> {
    public final List<ModelState> states = new ArrayList<ModelState>();
    public final T entity;
    public final int lifeTime;
    public final int interval;
    public int tick;
    public boolean shouldAdd;

    public AfterImage(T entity, int lifeTime, int interval) {
        this.entity = entity;
        this.lifeTime = lifeTime;
        this.interval = interval;
    }

    public void tick(boolean shouldAdd) {
        if (((LivingEntity)this.entity).f_19853_.f_46443_) {
            if (shouldAdd) {
                ++this.tick;
                if (this.tick >= this.interval) {
                    this.addAfterImage();
                    this.tick = 0;
                }
            }
            this.states.removeIf(t -> t.tick++ >= this.lifeTime);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public <M extends EntityModel<T>> void render(PoseStack stack, MultiBufferSource bufferSource, RenderType renderType, int packedLight, float partialTicks, float alpha) {
        T living = this.entity;
        EntityRenderer renderer = UnleashedClientUtil.MC.m_91290_().m_114382_(living);
        boolean shouldSit = living.m_20159_() && living.m_20202_() != null && living.m_20202_().shouldRiderSit();
        Vec3 camPos = UnleashedClientUtil.MC.f_91063_.m_109153_().m_90583_();
        double x = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)living).f_19790_, (double)living.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)living).f_19791_, (double)living.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)living).f_19792_, (double)living.m_20189_());
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            EntityModel model = livingRenderer.m_7200_();
            for (ModelState state : this.states) {
                Direction direction;
                stack.m_85836_();
                Vec3 pos = state.pos;
                stack.m_85837_(-(x - camPos.f_82479_), -(y - camPos.f_82480_), -(z - camPos.f_82481_));
                stack.m_85837_(pos.f_82479_ - camPos.f_82479_, pos.f_82480_ - camPos.f_82480_, pos.f_82481_ - camPos.f_82481_);
                model.f_102608_ = living.m_21324_(partialTicks);
                model.f_102609_ = shouldSit;
                model.f_102610_ = living.m_6162_();
                if (living.m_217003_(Pose.SLEEPING) && (direction = living.m_21259_()) != null) {
                    float f4 = living.m_20236_(Pose.STANDING) - 0.1f;
                    stack.m_252880_((float)(-direction.m_122429_()) * f4, 0.0f, (float)(-direction.m_122431_()) * f4);
                }
                this.setupRotations(living, stack, state.f7, state.f, partialTicks);
                stack.m_85841_(-1.0f, -1.0f, 1.0f);
                stack.m_252880_(0.0f, -1.501f, 0.0f);
                model.m_6839_(living, state.f5, state.f8, partialTicks);
                model.m_6973_(living, state.f5, state.f8, state.f7, state.f2, state.f6);
                if (model instanceof HierarchicalModel) {
                    HierarchicalModel animatedModel = (HierarchicalModel)model;
                    animatedModel.m_142109_().f_104207_ = true;
                }
                VertexConsumer consumer = bufferSource.m_6299_(renderType);
                model.m_7695_(stack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
                stack.m_85849_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addAfterImage() {
        T living = this.entity;
        float partialTicks = UnleashedClientUtil.MC.m_91296_();
        boolean shouldSit = living.m_20159_() && living.m_20202_() != null && living.m_20202_().shouldRiderSit();
        double x = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)living).f_19790_, (double)living.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)living).f_19791_, (double)living.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)((LivingEntity)living).f_19792_, (double)living.m_20189_());
        Vec3 entityPos = new Vec3(x, y, z);
        float f = Mth.m_14189_((float)partialTicks, (float)((LivingEntity)living).f_20884_, (float)((LivingEntity)living).f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)((LivingEntity)living).f_20886_, (float)((LivingEntity)living).f_20885_);
        float f2 = f1 - f;
        if (shouldSit && living.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)living.m_20202_();
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            f3 = Mth.m_14036_((float)f3, (float)-85.0f, (float)85.0f);
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)partialTicks, (float)((LivingEntity)living).f_19860_, (float)living.m_146909_());
        if (LivingEntityRenderer.m_194453_(living)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        float f7 = (float)((LivingEntity)living).f_19797_ + partialTicks;
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && living.m_6084_()) {
            f8 = ((LivingEntity)living).f_267362_.m_267711_(partialTicks);
            f5 = ((LivingEntity)living).f_267362_.m_267590_(partialTicks);
            if (living.m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        this.states.add(new ModelState(f, f2, f5, f6, f7, f8, entityPos));
    }

    public void setupRotations(T entity, PoseStack stack, float tick, float yRot, float partialTicks) {
        if (entity.m_146890_()) {
            float wiggle = Mth.m_14089_((float)((float)((LivingEntity)entity).f_19797_ * 3.25f)) * 1.2566f;
            yRot += wiggle;
        }
        if (!entity.m_217003_(Pose.SLEEPING)) {
            stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yRot));
        }
        if (((LivingEntity)entity).f_20919_ > 0) {
            float f = ((float)((LivingEntity)entity).f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            stack.m_252781_(Axis.f_252403_.m_252977_(f * 90.0f));
        } else if (entity.m_21209_()) {
            stack.m_252781_(Axis.f_252529_.m_252977_(-90.0f - entity.m_146909_()));
            stack.m_252781_(Axis.f_252436_.m_252977_(((float)((LivingEntity)entity).f_19797_ + partialTicks) * -75.0f));
        } else if (entity.m_217003_(Pose.SLEEPING)) {
            Direction direction = entity.m_21259_();
            float f1 = direction != null ? this.sleepDirectionToRotation(direction) : partialTicks;
            stack.m_252781_(Axis.f_252436_.m_252977_(f1));
            stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        } else if (LivingEntityRenderer.m_194453_(entity)) {
            stack.m_252880_(0.0f, entity.m_20206_() + 0.1f, 0.0f);
            stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    public float sleepDirectionToRotation(Direction direction) {
        switch (direction) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    public static class ModelState {
        public float f;
        public float f2;
        public float f5;
        public float f6;
        public float f7;
        public float f8;
        public int tick;
        public Vec3 pos;

        public ModelState(float f, float f2, float f5, float f6, float f7, float f8, Vec3 pos) {
            this.f = f;
            this.f2 = f2;
            this.f5 = f5;
            this.f6 = f6;
            this.f7 = f7;
            this.f8 = f8;
            this.pos = pos;
        }
    }
}

