/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.event;

import com.min01.unleashed.config.UnleashedConfig;
import com.min01.unleashed.entity.EntityWormhole;
import com.min01.unleashed.entity.UnleashedEntities;
import com.min01.unleashed.entity.living.EntityCelestialJellyfish;
import com.min01.unleashed.entity.projectile.EntityCelestialOrb;
import com.min01.unleashed.misc.UnleashedTags;
import com.min01.unleashed.network.UnleashedNetwork;
import com.min01.unleashed.network.UpdateStarfieldPacket;
import com.min01.unleashed.util.UnleashedUtil;
import com.min01.unleashed.world.UnleashedSavedData;
import com.min01.unleashed.world.UnleashedWorlds;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bossesunleashed", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandlerForge {
    @SubscribeEvent
    public static void onExplostionDetonate(ExplosionEvent.Detonate event) {
        if (event.getExplosion().getExploder() instanceof EntityCelestialJellyfish) {
            event.getAffectedEntities().removeIf(t -> {
                ItemEntity itemEntity;
                return t instanceof ItemEntity && (itemEntity = (ItemEntity)t).m_32055_().m_204117_(UnleashedTags.UnleashedItems.EXPLOSION_IMMUNE);
            });
        }
    }

    @SubscribeEvent
    public static void onFinalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        MobSpawnType type = event.getSpawnType();
        ServerLevelAccessor level = event.getLevel();
        DifficultyInstance difficulty = event.getDifficulty();
        if (entity instanceof EnderMan) {
            EnderMan enderMan = (EnderMan)entity;
            if (enderMan.f_19853_.m_46472_() == Level.f_46430_ && type == MobSpawnType.NATURAL && level.m_204166_(enderMan.m_20183_()).m_203565_(Biomes.f_48164_) && difficulty.m_19048_() != Difficulty.PEACEFUL && Math.random() <= (Double)UnleashedConfig.wormholeSpawnChance.get() / 100.0) {
                EntityWormhole wormhole = new EntityWormhole((EntityType)UnleashedEntities.WORMHOLE.get(), enderMan.f_19853_);
                wormhole.m_146884_(enderMan.m_20182_());
                level.m_7967_((Entity)wormhole);
                event.setSpawnCancelled(true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            UnleashedSavedData data;
            Player player = (Player)entity;
            if (level.m_46472_() == UnleashedWorlds.CELESTIAL_FIELD && ((Boolean)UnleashedConfig.spawnJellyfish.get()).booleanValue() && (data = UnleashedSavedData.get(level)) != null) {
                UnleashedNetwork.sendToAll(new UpdateStarfieldPacket(data.isStarfield()));
                if (!data.isJellyfishSpawned()) {
                    EntityCelestialJellyfish jellyfish = new EntityCelestialJellyfish((EntityType<? extends Monster>)((EntityType)UnleashedEntities.CELESTIAL_JELLYFISH.get()), level);
                    float yRot = player.m_217043_().m_188501_() * 360.0f;
                    Vec3 lookPos = UnleashedUtil.getLookPos(new Vec2(0.0f, player.m_6080_() + yRot), player.m_20182_(), 0.0, 4.5, player.m_217043_().m_216339_(10, 20));
                    jellyfish.m_146884_(lookPos);
                    level.m_7967_((Entity)jellyfish);
                    data.setJellyfishSpawned(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player.f_19853_.m_46472_() == UnleashedWorlds.CELESTIAL_FIELD && !player.m_150110_().f_35937_ && event.getItemStack().m_41720_() instanceof BlockItem) {
            event.setCancellationResult(InteractionResult.PASS);
            event.setUseBlock(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            UnleashedSavedData data;
            ServerPlayer player = (ServerPlayer)entity;
            if (player.f_19853_.m_46472_() == UnleashedWorlds.CELESTIAL_FIELD && (data = UnleashedSavedData.get(player.f_19853_)) != null && data.isJellyfishSpawned() && event.getSource().m_7639_() instanceof EntityCelestialJellyfish) {
                player.m_9158_(UnleashedWorlds.CELESTIAL_FIELD, player.m_20183_(), player.m_8962_(), player.m_8964_(), false);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int tick;
        Player player = event.player;
        UnleashedUtil.tickDash((LivingEntity)player);
        if (UnleashedUtil.isDash((LivingEntity)player) && (tick = UnleashedUtil.getDashTick((LivingEntity)player)) % 2 == 0) {
            EntityCelestialOrb orb = new EntityCelestialOrb((EntityType<? extends ThrowableProjectile>)((EntityType)UnleashedEntities.CELESTIAL_ORB.get()), player.f_19853_);
            orb.m_146884_(player.m_20182_());
            orb.m_5602_((Entity)player);
            player.f_19853_.m_7967_((Entity)orb);
        }
    }
}

