/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.event;

import com.min01.unleashed.config.UnleashedConfig;
import com.min01.unleashed.entity.EntityCameraShake;
import com.min01.unleashed.misc.UnleashedBossBarType;
import com.min01.unleashed.shader.UnleashedShaderEffects;
import com.min01.unleashed.util.UnleashedClientUtil;
import com.min01.unleashed.util.UnleashedUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bossesunleashed", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEventHandlerForge {
    public static final AtomicBoolean STARFIELD = new AtomicBoolean();
    public static final Map<UUID, UnleashedBossBarType> BOSS_BAR_MAP = new HashMap<UUID, UnleashedBossBarType>();
    public static final Map<UUID, Entity> BOSS_MAP = new HashMap<UUID, Entity>();
    public static final ResourceLocation JELLYFISH_BOSS_BAR_FRAME_TEXTURE = new ResourceLocation("bossesunleashed", "textures/gui/celestial_jellyfish_bossbar_frame.png");
    public static final ResourceLocation JELLYFISH_BOSS_BAR_BAR_TEXTURE = new ResourceLocation("bossesunleashed", "textures/gui/celestial_jellyfish_bossbar_bar.png");

    @SubscribeEvent
    public static void onSetupCamera(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = UnleashedClientUtil.MC.f_91074_;
        float delta = UnleashedClientUtil.MC.m_91296_();
        float ticksExistedDelta = (float)player.f_19797_ + delta;
        if (player != null && ((Boolean)UnleashedConfig.cameraShakes.get()).booleanValue()) {
            float shakeAmplitude = 0.0f;
            for (EntityCameraShake cameraShake : player.f_19853_.m_45976_(EntityCameraShake.class, player.m_20191_().m_82400_(100.0))) {
                if (!(cameraShake.m_20270_((Entity)player) < cameraShake.getRadius())) continue;
                shakeAmplitude += cameraShake.getShakeAmount((Player)player, delta);
            }
            if (shakeAmplitude > 1.0f) {
                shakeAmplitude = 1.0f;
            }
            event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
            event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
            event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (UnleashedUtil.isDash((LivingEntity)player)) {
            PoseStack stack = event.getPoseStack();
            float yRot = Mth.m_14189_((float)event.getPartialTick(), (float)player.f_20884_, (float)player.f_20883_);
            stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yRot));
            stack.m_252781_(Axis.f_252529_.m_252977_(-90.0f - player.m_146909_()));
            stack.m_252781_(Axis.f_252436_.m_252977_(((float)player.f_19797_ + event.getPartialTick()) * -75.0f));
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (UnleashedClientUtil.MC.f_91074_ != null && UnleashedClientUtil.MC.f_91073_ != null) {
                if (!UnleashedClientUtil.MC.m_91104_()) {
                    UnleashedShaderEffects.EFFECTS.removeIf(t -> !t.isAlive());
                }
            } else if (STARFIELD.get()) {
                STARFIELD.set(false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBossEventProgress(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (BOSS_BAR_MAP.containsKey(event.getBossEvent().m_18860_())) {
            PoseStack poseStack = event.getGuiGraphics().m_280168_();
            Component component = event.getBossEvent().m_18861_();
            int width = UnleashedClientUtil.MC.m_91268_().m_85445_();
            int y = event.getY();
            int progressScaled = (int)(event.getBossEvent().m_142717_() * 127.0f);
            int componentWidth = UnleashedClientUtil.MC.f_91062_.m_92852_((FormattedText)component);
            int x = width / 2 - componentWidth / 2;
            event.setCanceled(true);
            poseStack.m_85836_();
            poseStack.m_252880_((float)x / 11.5f, (float)(y - 23), 0.0f);
            event.getGuiGraphics().m_280163_(JELLYFISH_BOSS_BAR_FRAME_TEXTURE, event.getX(), event.getY(), 0.0f, 0.0f, 140, 32, 140, 32);
            event.getGuiGraphics().m_280163_(JELLYFISH_BOSS_BAR_BAR_TEXTURE, event.getX(), event.getY(), 0.0f, 0.0f, 9 + progressScaled, 32, 140, 32);
            poseStack.m_252880_((float)x - 20.0f, (float)(y + 35), 0.0f);
            UnleashedClientUtil.MC.f_91062_.m_272191_(component.m_6879_().m_130940_(ChatFormatting.AQUA).m_7532_(), 0.0f, 0.0f, 0xFFFFFF, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)UnleashedClientUtil.MC.m_91269_().m_110104_(), Font.DisplayMode.POLYGON_OFFSET, 0, 0xF000F0);
            poseStack.m_85849_();
            event.setIncrement(event.getIncrement() + 7);
        }
    }
}

